/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.invoke;

import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.InvokeHelper;
import php.runtime.invoke.Invoker;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ParameterEntity;

public class FunctionInvoker
extends Invoker {
    private final FunctionEntity entity;
    protected final Environment env;

    public FunctionInvoker(Environment env, TraceInfo trace, FunctionEntity function) {
        super(env, trace);
        this.entity = function;
        this.env = env;
    }

    @Override
    public ParameterEntity[] getParameters() {
        return this.entity.getParameters();
    }

    @Override
    public String getName() {
        return this.entity.getName();
    }

    @Override
    public int getArgumentCount() {
        return this.entity.getParameters() == null ? 0 : this.entity.getParameters().length;
    }

    public FunctionEntity getFunction() {
        return this.entity;
    }

    @Override
    public void pushCall(TraceInfo trace, Memory[] args) {
        this.env.pushCall(trace, null, args, this.entity.getName(), null, null);
    }

    @Override
    protected Memory invoke(Memory ... args) throws Throwable {
        return InvokeHelper.call(this.env, this.trace, this.entity, args);
    }

    @Override
    public int canAccess(Environment env) {
        return 0;
    }

    public static FunctionInvoker valueOf(Environment env, TraceInfo trace, String name) {
        FunctionEntity functionEntity = env.fetchFunction(name);
        if (functionEntity == null) {
            if (trace == null) {
                return null;
            }
            env.error(trace, Messages.ERR_CALL_TO_UNDEFINED_FUNCTION.fetch(name), new Object[0]);
        }
        return new FunctionInvoker(env, trace, functionEntity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionInvoker)) {
            return false;
        }
        FunctionInvoker that = (FunctionInvoker)o;
        return this.entity.equals(that.entity);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }
}

