/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="Configuration")
@Reflection.Namespace(value="php\\util")
public class WrapConfiguration
extends BaseObject {
    protected Properties properties;

    public WrapConfiguration(Environment env, Properties properties) {
        super(env);
        this.properties = properties;
    }

    public WrapConfiguration(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() throws IOException {
        this.__construct(null);
    }

    @Reflection.Signature
    public void __construct(@Reflection.Nullable InputStream in) throws IOException {
        this.__construct(in, "UTF-8");
    }

    @Reflection.Signature
    public void __construct(@Reflection.Nullable InputStream in, String encoding) throws IOException {
        this.properties = new Properties();
        if (in != null) {
            this.load(in, encoding);
        }
    }

    @Reflection.Signature
    public Memory get(String key, Memory def) {
        if (!this.properties.containsKey(key)) {
            return def;
        }
        return StringMemory.valueOf(this.properties.getProperty(key, def.toString()));
    }

    @Reflection.Signature
    public boolean has(String key) {
        return this.properties.containsKey(key);
    }

    @Reflection.Signature
    public String remove(String key) {
        Object remove = this.properties.remove(key);
        return remove == null ? null : remove.toString();
    }

    @Reflection.Signature
    public Memory get(String key) {
        return this.get(key, Memory.NULL);
    }

    @Reflection.Signature
    public Memory getArray(String key, ArrayMemory def) {
        if (this.has(key)) {
            Memory memory = this.get(key);
            String[] split = StringUtils.split(memory.toString(), '|');
            ArrayMemory result = new ArrayMemory();
            for (String s : split) {
                result.add(s.trim());
            }
            return result.toConstant();
        }
        return def;
    }

    @Reflection.Signature
    public Memory getArray(String key) {
        return this.getArray(key, new ArrayMemory().toConstant());
    }

    @Reflection.Signature
    public boolean getBoolean(String key, boolean def) {
        return this.get(key, TrueMemory.valueOf(def)).toBoolean();
    }

    @Reflection.Signature
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Reflection.Signature
    public Memory getNumber(String key, Memory def) {
        def = def.toNumeric();
        return this.get(key, def).toNumeric();
    }

    @Reflection.Signature
    public Memory getNumber(String key) {
        return this.getNumber(key, Memory.CONST_INT_0);
    }

    @Reflection.Signature
    public long getInteger(String key, long def) {
        return this.get(key, LongMemory.valueOf(def)).toLong();
    }

    @Reflection.Signature
    public long getInteger(String key) {
        return this.getInteger(key, 0L);
    }

    @Reflection.Signature
    public String set(String key, Memory value) {
        Object property;
        String s = value.toString();
        if (value.isArray()) {
            s = StringUtils.join(value.toValue(ArrayMemory.class).toStringArray(), "|");
        }
        return (property = this.properties.setProperty(key, s)) == null ? null : property.toString();
    }

    @Reflection.Signature
    public void put(Environment env, ForeachIterator iterator) throws Throwable {
        while (iterator.next()) {
            env.invokeMethod(this, "set", iterator.getMemoryKey(), iterator.getValue());
        }
    }

    @Reflection.Signature
    public void clear() {
        this.properties.clear();
    }

    @Reflection.Signature
    public void load(InputStream in, String encoding) throws IOException {
        this.properties.load(new InputStreamReader(in, encoding));
    }

    @Reflection.Signature
    public void load(InputStream in) throws IOException {
        this.load(in, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public void save(Environment env, Memory path, String encoding) throws IOException {
        OutputStream out = Stream.getOutputStream(env, path);
        if (out == null) {
            throw new IOException();
        }
        try {
            this.properties.store(new OutputStreamWriter(out, encoding), null);
        }
        finally {
            Stream.closeStream(env, out);
        }
    }

    @Reflection.Signature
    public void save(Environment env, Memory path) throws IOException {
        this.save(env, path, "UTF-8");
    }

    @Reflection.Signature
    public Memory toArray() {
        ArrayMemory result = new ArrayMemory(true);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            result.putAsKeyString(entry.getKey().toString(), StringMemory.valueOf(entry.getValue().toString()));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    protected void __clone() {
    }
}

