/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.time;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.ext.core.classes.time.WrapTimeZone;
import php.runtime.ext.core.classes.util.WrapLocale;
import php.runtime.lang.BaseObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\time\\TimeFormat")
public class WrapTimeFormat
extends BaseObject {
    protected String format;
    protected DateFormat dateFormat;

    public WrapTimeFormat(Environment env, DateFormat dateFormat) {
        super(env);
        this.dateFormat = dateFormat;
    }

    public WrapTimeFormat(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public String getFormat() {
        return this.format;
    }

    public DateFormat getDateFormat(WrapTime time) {
        if (this.dateFormat.getTimeZone().equals(time.timeZone)) {
            return this.dateFormat;
        }
        DateFormat dt = (DateFormat)this.dateFormat.clone();
        dt.setTimeZone(time.timeZone);
        return dt;
    }

    public DateFormat getDateFormat(TimeZone zone) {
        if (this.dateFormat.getTimeZone().equals(zone)) {
            return this.dateFormat;
        }
        DateFormat dt = (DateFormat)this.dateFormat.clone();
        dt.setTimeZone(zone);
        return dt;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="format"), @Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="null")), @Reflection.Arg(value="formatSymbols", type=HintType.ARRAY, optional=@Reflection.Optional(value="null"))})
    public Memory __construct(Environment env, Memory ... args) {
        this.format = args[0].toString();
        if (args[2].isNull()) {
            this.dateFormat = args[1].isNull() ? new SimpleDateFormat(args[0].toString(), WrapLocale.getDefault(env)) : new SimpleDateFormat(args[0].toString(), args[1].toObject(WrapLocale.class).getLocale());
        } else {
            final ArrayMemory symbols = args[2].toValue(ArrayMemory.class);
            this.dateFormat = new SimpleDateFormat(args[0].toString(), new DateFormatSymbols(WrapLocale.getDefault(env, args[1])){
                {
                    ReferenceMemory localPatternChars;
                    ReferenceMemory amPm;
                    ReferenceMemory shortWeekdays;
                    ReferenceMemory weekdays;
                    ReferenceMemory eras;
                    ReferenceMemory shortMonths;
                    super(x0);
                    ReferenceMemory months = symbols.getByScalar("months");
                    if (months != null && ((Memory)months).isArray()) {
                        this.setMonths(((Memory)months).toValue(ArrayMemory.class).toStringArray());
                    }
                    if ((shortMonths = symbols.getByScalar("short_months")) != null && ((Memory)shortMonths).isArray()) {
                        this.setShortMonths(((Memory)shortMonths).toValue(ArrayMemory.class).toStringArray());
                    }
                    if ((eras = symbols.getByScalar("eras")) != null && ((Memory)eras).isArray()) {
                        this.setEras(((Memory)eras).toValue(ArrayMemory.class).toStringArray());
                    }
                    if ((weekdays = symbols.getByScalar("weekdays")) != null && ((Memory)weekdays).isArray()) {
                        this.setWeekdays(((Memory)weekdays).toValue(ArrayMemory.class).toStringArray());
                    }
                    if ((shortWeekdays = symbols.getByScalar("short_weekdays")) != null && ((Memory)shortWeekdays).isArray()) {
                        this.setShortWeekdays(((Memory)shortWeekdays).toValue(ArrayMemory.class).toStringArray());
                    }
                    if ((amPm = symbols.getByScalar("am_pm")) != null && ((Memory)amPm).isArray()) {
                        this.setAmPmStrings(((Memory)amPm).toValue(ArrayMemory.class).toStringArray());
                    }
                    if ((localPatternChars = symbols.getByScalar("local_pattern_chars")) != null) {
                        this.setLocalPatternChars(((Memory)localPatternChars).toString());
                    }
                }
            });
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("*format").assign(this.format);
        return r.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="time", nativeType=WrapTime.class)})
    public Memory format(Environment env, Memory ... args) {
        WrapTime time = args[0].toObject(WrapTime.class);
        DateFormat df = this.getDateFormat(time);
        return StringMemory.valueOf(df.format(time.date));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="string"), @Reflection.Arg(value="timeZone", nativeType=WrapTimeZone.class, optional=@Reflection.Optional(value="null"))})
    public Memory parse(Environment env, Memory ... args) {
        try {
            TimeZone timeZone = WrapTimeZone.getTimeZone(env, args[1]);
            Date date = this.getDateFormat(timeZone).parse(args[0].toString());
            return new ObjectMemory(new WrapTime(env, date, timeZone));
        }
        catch (ParseException e) {
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    private Memory __clone(Environment env, Memory ... args) {
        return Memory.NULL;
    }
}

