/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.annotation.Runtime;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.Countable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lib\\Arr")
public class ItemsUtils
extends BaseObject {
    public ItemsUtils(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    private Memory __construct(Environment env, Memory ... args) {
        return Memory.NULL;
    }

    protected static Memory call(ForeachIterator iterator, Invoker invoker) {
        if (invoker == null) {
            return iterator.getValue();
        }
        if (invoker.getArgumentCount() == 1) {
            return invoker.callNoThrow(iterator.getValue());
        }
        return invoker.callNoThrow(iterator.getValue(), iterator.getMemoryKey());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE), @Reflection.Arg(value="comparator", type=HintType.CALLABLE, optional=@Reflection.Optional(value="null")), @Reflection.Arg(value="saveKeys", optional=@Reflection.Optional(value="false"))})
    public static Memory sortByKeys(Environment env, Memory ... args) {
        boolean saveKeys = args[2].toBoolean();
        ArrayList<KeyValueMemory> tmp = new ArrayList<KeyValueMemory>();
        ForeachIterator iterator = args[0].toImmutable().getNewIterator(env);
        while (iterator.next()) {
            tmp.add(new KeyValueMemory(iterator.getMemoryKey(), iterator.getValue().toImmutable()));
        }
        final Invoker invoker = args[0].isNull() ? null : Invoker.valueOf(env, null, args[1]);
        Collections.sort(tmp, new Comparator<KeyValueMemory>(){

            @Override
            public int compare(KeyValueMemory o1, KeyValueMemory o2) {
                if (invoker == null) {
                    return o1.key.compareTo(o2.key);
                }
                return invoker.callNoThrow(o1.key, o2.key).toInteger();
            }
        });
        ArrayMemory r = new ArrayMemory();
        Iterator iterator1 = tmp.iterator();
        while (iterator1.hasNext()) {
            if (saveKeys) {
                r.add((Memory)iterator1.next());
            } else {
                r.add(((KeyValueMemory)iterator1.next()).value);
            }
            iterator1.remove();
        }
        return r.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE), @Reflection.Arg(value="comparator", type=HintType.CALLABLE, optional=@Reflection.Optional(value="null")), @Reflection.Arg(value="saveKeys", optional=@Reflection.Optional(value="false"))})
    public static Memory sort(Environment env, Memory ... args) {
        Memory[] sortTmp;
        boolean saveKeys = args[2].toBoolean();
        if (!saveKeys && args[0].isArray()) {
            Memory[] original = args[0].toValue(ArrayMemory.class).values(true);
            sortTmp = Arrays.copyOf(original, original.length);
        } else {
            ForeachIterator iterator = args[0].toImmutable().getNewIterator(env);
            ArrayList<Memory> tmp = new ArrayList<Memory>();
            while (iterator.next()) {
                if (saveKeys) {
                    tmp.add(new KeyValueMemory(iterator.getMemoryKey(), iterator.getValue().toImmutable()));
                    continue;
                }
                tmp.add(iterator.getValue().toImmutable());
            }
            sortTmp = tmp.toArray(new Memory[tmp.size()]);
            tmp.clear();
        }
        if (args[1].isNull()) {
            Arrays.sort(sortTmp, new Comparator<Memory>(){

                @Override
                public int compare(Memory o1, Memory o2) {
                    return o1.compareTo(o2);
                }
            });
        } else {
            final Invoker invoker = Invoker.valueOf(env, null, args[1]);
            Arrays.sort(sortTmp, new Comparator<Memory>(){

                @Override
                public int compare(Memory o1, Memory o2) {
                    return invoker.callNoThrow(o1, o2).toInteger();
                }
            });
        }
        ArrayMemory r = new ArrayMemory();
        for (Memory el : sortTmp) {
            r.add(el);
        }
        return r.toConstant();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE)})
    public static Memory count(Environment env, Memory ... args) {
        if (args[0].isArray()) {
            return LongMemory.valueOf(args[0].toValue(ArrayMemory.class).size());
        }
        if (args[0].isObject()) {
            ObjectMemory objectMemory = args[0].toValue(ObjectMemory.class);
            if (objectMemory.value instanceof Countable) {
                env.pushCall(objectMemory.value, "count", new Memory[0]);
                try {
                    long size = ((Countable)objectMemory.value).count(env, new Memory[0]).toLong();
                    Memory memory = LongMemory.valueOf(size);
                    return memory;
                }
                finally {
                    env.popCall();
                }
            }
            ForeachIterator iterator = args[0].getNewIterator(env);
            if (iterator == null) {
                return Memory.FALSE;
            }
            int r = 0;
            while (iterator.next()) {
                ++r;
            }
            return LongMemory.valueOf(r);
        }
        return Memory.CONST_INT_0;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE), @Reflection.Arg(value="withKeys", optional=@Reflection.Optional(value="false"))})
    public static Memory toArray(Environment env, Memory ... args) {
        boolean withKeys = args[1].toBoolean();
        if (withKeys && args[0].isArray()) {
            return args[0].toImmutable();
        }
        ForeachIterator iterator = args[0].getNewIterator(env);
        if (iterator == null) {
            return Memory.NULL;
        }
        ArrayMemory r = new ArrayMemory();
        while (iterator.next()) {
            if (withKeys) {
                r.put(iterator.getMemoryKey(), iterator.getValue().toImmutable());
                continue;
            }
            r.add(iterator.getValue().toImmutable());
        }
        return r.toConstant();
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE), @Reflection.Arg(value="withKeys", optional=@Reflection.Optional(value="false"))})
    public static Memory of(Environment env, Memory ... args) {
        return ItemsUtils.toArray(env, args);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="keys", type=HintType.TRAVERSABLE), @Reflection.Arg(value="values", type=HintType.TRAVERSABLE)})
    public static Memory combine(Environment env, Memory ... args) {
        ForeachIterator keyIterator = args[0].getNewIterator(env);
        ForeachIterator valueIterator = args[1].getNewIterator(env);
        ArrayMemory r = new ArrayMemory();
        while (keyIterator.next()) {
            if (valueIterator.next()) {
                r.refOfIndex(keyIterator.getValue()).assign(valueIterator.getValue().toImmutable());
                continue;
            }
            return Memory.NULL;
        }
        return r.toConstant();
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE), @Reflection.Arg(value="value"), @Reflection.Arg(value="strict", optional=@Reflection.Optional(value="false"))})
    public static Memory has(Environment env, Memory ... args) {
        ForeachIterator iterator = args[0].getNewIterator(env);
        if (iterator == null) {
            return Memory.NULL;
        }
        Memory needle = args[1];
        boolean strict = args[2].toBoolean();
        while (iterator.next()) {
            if (!(strict ? needle.identical(iterator.getValue()) : needle.equal(iterator.getValue()))) continue;
            return Memory.TRUE;
        }
        return Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE), @Reflection.Arg(value="callback", type=HintType.CALLABLE)})
    public static Memory map(Environment env, Memory ... args) throws Throwable {
        ForeachIterator iterator = args[0].getNewIterator(env);
        if (iterator == null) {
            return Memory.NULL;
        }
        Invoker callback = Invoker.valueOf(env, null, args[1]);
        if (callback == null) {
            return Memory.NULL;
        }
        ArrayMemory r = new ArrayMemory();
        while (iterator.next()) {
            r.refOfIndex(iterator.getMemoryKey()).assign(callback.call(iterator.getValue()));
        }
        return r.toConstant();
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection")})
    public static Memory toList(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        for (Memory arg : args) {
            if (arg.isTraversable()) {
                ForeachIterator iterator = arg.getNewIterator(env);
                while (iterator.next()) {
                    r.add(iterator.getValue().toImmutable());
                }
                continue;
            }
            r.add(arg.toImmutable());
        }
        return r.toConstant();
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE)})
    public static Memory keys(Environment env, Memory ... args) {
        ForeachIterator iterator = args[0].getNewIterator(env);
        if (iterator == null) {
            return Memory.NULL;
        }
        ArrayMemory r = new ArrayMemory();
        while (iterator.next()) {
            r.add(iterator.getMemoryKey());
        }
        return r.toConstant();
    }

    protected static void flatten(Environment env, ForeachIterator iterator, Set<Integer> used, ArrayMemory array, int level, int maxLevel) {
        while (iterator.next()) {
            Memory el = iterator.getValue();
            ForeachIterator innerIterator = el.getNewIterator(env);
            if (innerIterator == null || level >= maxLevel && maxLevel > -1) {
                array.add(el.toImmutable());
                continue;
            }
            if (!used.add(el.getPointer())) continue;
            ItemsUtils.flatten(env, innerIterator, used, array, level + 1, maxLevel);
            used.remove(el.getPointer());
        }
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE), @Reflection.Arg(value="level", optional=@Reflection.Optional(value="-1"))})
    public static Memory flatten(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        int level = args[1].toInteger();
        ForeachIterator iterator = args[0].getNewIterator(env);
        if (iterator == null) {
            return Memory.NULL;
        }
        HashSet<Integer> used = new HashSet<Integer>();
        used.add(args[0].getPointer());
        ItemsUtils.flatten(env, iterator, used, r, 0, level);
        return r.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="array", type=HintType.ARRAY, reference=true), @Reflection.Arg(value="values", type=HintType.VARARG)})
    public static Memory unshift(Environment env, Memory ... args) {
        args[0].toValue(ArrayMemory.class).unshift(Arrays.copyOfRange(args, 1, args.length));
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="array", type=HintType.ARRAY, reference=true)})
    public static Memory shift(Environment env, Memory ... args) {
        return args[0].toValue(ArrayMemory.class).shift();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="array", type=HintType.ARRAY, reference=true)})
    public static Memory pop(Environment env, Memory ... args) throws Throwable {
        Memory array = args[0];
        Memory pop = array.toValue(ArrayMemory.class).pop();
        return pop == null ? Memory.NULL : pop;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="array", type=HintType.ARRAY)})
    public static Memory peak(Environment env, Memory ... args) throws Throwable {
        Memory array = args[0];
        Memory peek = array.toValue(ArrayMemory.class).peek();
        return peek == null ? Memory.NULL : peek;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="array", type=HintType.ARRAY, reference=true), @Reflection.Arg(value="values", type=HintType.VARARG)})
    public static Memory push(Environment env, Memory ... args) throws Throwable {
        Memory array = args[0];
        for (int i = 1; i < args.length; ++i) {
            array.toValue(ArrayMemory.class).add(args[i].toImmutable());
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE)})
    public static Memory first(Environment env, Memory ... args) {
        ForeachIterator iterator = args[0].getNewIterator(env);
        if (iterator.next()) {
            return iterator.getValue();
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.TRAVERSABLE)})
    public static Memory firstKey(Environment env, Memory ... args) {
        ForeachIterator iterator = args[0].getNewIterator(env);
        if (iterator.next()) {
            return iterator.getMemoryKey();
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="collection", type=HintType.ARRAY)})
    public static Memory reverse(Environment env, Memory ... args) {
        ForeachIterator iterator = args[0].getNewIterator(env);
        ArrayMemory result = new ArrayMemory();
        while (iterator.next()) {
            result.unshift(iterator.getValue().toImmutable());
        }
        return result.toConstant();
    }
}

