/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.WrapEnvironment;
import php.runtime.ext.core.classes.WrapFuture;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\ThreadPool")
public class WrapThreadPool
extends BaseObject {
    protected ExecutorService service;

    public WrapThreadPool(Environment env, ExecutorService service) {
        super(env);
        this.service = service;
    }

    public WrapThreadPool(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public ExecutorService getService() {
        return this.service;
    }

    @Reflection.Signature
    private Memory __construct(Environment env, Memory ... args) {
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="runnable", type=HintType.CALLABLE), @Reflection.Arg(value="env", nativeType=WrapEnvironment.class, optional=@Reflection.Optional(value="NULL"))})
    public Memory execute(Environment env, Memory ... args) {
        Environment _env = env;
        if (!args[1].isNull()) {
            _env = args[1].toObject(WrapEnvironment.class).getWrapEnvironment();
        }
        final Invoker invoker = Invoker.valueOf(_env, null, args[0]);
        invoker.setTrace(env.trace());
        final Environment final_env = _env;
        this.service.execute(new Runnable(){

            @Override
            public void run() {
                Environment.addThreadSupport(final_env);
                invoker.callNoThrow(new Memory[0]);
            }
        });
        return Memory.NULL;
    }

    private ScheduledExecutorService getScheduledExecutorService(Environment env) {
        if (!(this.service instanceof ScheduledExecutorService)) {
            env.exception("Unsupported operation for non-scheduled executor service", new Object[0]);
            return null;
        }
        return (ScheduledExecutorService)this.service;
    }

    @Reflection.Signature
    public Memory isScheduled(Environment env, Memory ... args) {
        return this.service instanceof ScheduledExecutorService ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="runnable", type=HintType.CALLABLE), @Reflection.Arg(value="env", typeClass="php\\lang\\Environment", optional=@Reflection.Optional(value="NULL"))})
    public Memory submit(Environment env, Memory ... args) {
        Environment _env = args[1].isNull() ? env : args[1].toObject(WrapEnvironment.class).getWrapEnvironment();
        final Invoker invoker = Invoker.valueOf(_env, null, args[0]);
        Future<Memory> future = this.service.submit(new Callable<Memory>(){

            @Override
            public Memory call() throws Exception {
                return invoker.callNoThrow(new Memory[0]);
            }
        });
        return new ObjectMemory(new WrapFuture(env, future));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="runnable", type=HintType.CALLABLE), @Reflection.Arg(value="delay"), @Reflection.Arg(value="env", typeClass="php\\lang\\Environment", optional=@Reflection.Optional(value="NULL"))})
    public Memory schedule(Environment env, Memory ... args) {
        final Environment _env = args[2].isNull() ? env : args[2].toObject(WrapEnvironment.class).getWrapEnvironment();
        final Invoker invoker = Invoker.valueOf(_env, null, args[0]);
        ScheduledFuture<Memory> future = this.getScheduledExecutorService(env).schedule(new Callable<Memory>(){

            @Override
            public Memory call() throws Exception {
                Environment.addThreadSupport(_env);
                return invoker.callNoThrow(new Memory[0]);
            }
        }, args[1].toLong(), TimeUnit.MILLISECONDS);
        return new ObjectMemory(new WrapFuture(env, future));
    }

    @Reflection.Signature
    public Memory shutdown(Environment env, Memory ... args) {
        this.service.shutdown();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory shutdownNow(Environment env, Memory ... args) {
        this.service.shutdownNow();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory isShutdown(Environment env, Memory ... args) {
        return this.service.isShutdown() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isTerminated(Environment env, Memory ... args) {
        return this.service.isTerminated() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="timeout")})
    public Memory awaitTermination(Environment env, Memory ... args) throws InterruptedException {
        return this.service.awaitTermination(args[0].toLong(), TimeUnit.MILLISECONDS) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="max")})
    public static Memory createFixed(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapThreadPool(env, Executors.newFixedThreadPool(args[0].toInteger())));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="corePoolSize"), @Reflection.Arg(value="maxPoolSize"), @Reflection.Arg(value="keepAliveTime", optional=@Reflection.Optional(value="0"))})
    public static Memory create(Environment env, Memory ... args) {
        int nThreads = args[0].toInteger();
        int nMaxThreads = args[1].toInteger();
        long keepAliveTime = args[2].toLong();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(nThreads, nMaxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        return new ObjectMemory(new WrapThreadPool(env, executor));
    }

    @Reflection.Signature
    public static Memory createCached(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapThreadPool(env, Executors.newCachedThreadPool()));
    }

    @Reflection.Signature
    public static Memory createSingle(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapThreadPool(env, Executors.newSingleThreadExecutor()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="corePoolSize")})
    public static Memory createScheduled(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapThreadPool(env, Executors.newScheduledThreadPool(args[0].toInteger())));
    }
}

