/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.WrapEnvironment;
import php.runtime.ext.core.classes.WrapThreadGroup;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.support.IComparableObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\Thread")
public class WrapThread
extends BaseObject
implements IComparableObject<WrapThread> {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    protected Environment customEnv;
    protected Thread thread;
    protected Invoker invoker;

    public WrapThread(Environment env) {
        super(env);
    }

    public WrapThread(Environment env, Thread thread) {
        super(env);
        this.setThread(thread, env);
    }

    public WrapThread(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Environment getCustomEnv() {
        return this.customEnv;
    }

    public void setCustomEnv(Environment customEnv) {
        this.customEnv = customEnv;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread, Environment env) {
        this.thread = thread;
        if (thread != null) {
            Environment.addThreadSupport(thread, env);
        }
    }

    @Reflection.Signature(value={@Reflection.Arg(value="runnable", type=HintType.CALLABLE), @Reflection.Arg(value="env", typeClass="php\\lang\\Environment", optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="group", typeClass="php\\lang\\ThreadGroup", optional=@Reflection.Optional(value="NULL"))})
    public Memory __construct(Environment env, Memory ... args) {
        if (!args[1].isNull()) {
            this.setCustomEnv(args[1].toObject(WrapEnvironment.class).getWrapEnvironment());
        } else {
            this.setCustomEnv(env);
        }
        final Invoker invoker = Invoker.valueOf(this.getCustomEnv(), null, args[0]);
        ThreadGroup group = null;
        if (!args[2].isNull()) {
            group = args[2].toObject(WrapThreadGroup.class).getGroup();
        }
        this.invoker = invoker;
        if (args[2].isNull()) {
            this.setThread(new Thread(group, new Runnable(){

                @Override
                public void run() {
                    invoker.callNoThrow(new Memory[0]);
                }
            }), env);
        } else {
            this.setThread(new Thread(group, new Runnable(){

                @Override
                public void run() {
                    invoker.callNoThrow(new Memory[0]);
                }
            }, args[2].toString()), env);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("*id").assign(this.thread.getId());
        r.refOfIndex("*name").assign(this.thread.getName());
        if (this.thread.getThreadGroup() != null) {
            r.refOfIndex("*group").assign(this.thread.getThreadGroup().getName());
        } else {
            r.refOfIndex("*group");
        }
        r.refOfIndex("*priority").assign(this.thread.getPriority());
        return r.toConstant();
    }

    @Reflection.Signature
    public Memory getId(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.thread.getId());
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.thread.getName());
    }

    @Reflection.Signature
    public Memory getPriority(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.thread.getPriority());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value")})
    public Memory setPriority(Environment env, Memory ... args) {
        this.thread.setPriority(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getState(Environment env, Memory ... args) {
        return new StringMemory(this.thread.getState().name());
    }

    @Reflection.Signature
    public Memory setDaemon(Environment env, Memory ... args) {
        this.thread.setDaemon(args[0].toBoolean());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory isDaemon(Environment env, Memory ... args) {
        return this.thread.isDaemon() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAlive(Environment env, Memory ... args) {
        return this.thread.isAlive() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isInterrupted(Environment env, Memory ... args) {
        return this.thread.isInterrupted() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory setName(Environment env, Memory ... args) {
        this.thread.setName(args[0].toString());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory interrupt(Environment env, Memory ... args) {
        this.thread.interrupt();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory start(Environment env, Memory ... args) {
        this.invoker.setTrace(env.trace());
        this.thread.start();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory run(Environment env, Memory ... args) {
        this.invoker.setTrace(env.trace());
        this.thread.run();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getGroup(Environment env, Memory ... args) {
        if (this.thread.getThreadGroup() == null) {
            return Memory.NULL;
        }
        return new ObjectMemory(new WrapThreadGroup(env, this.thread.getThreadGroup()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="millis", optional=@Reflection.Optional(value="0", type=HintType.INT)), @Reflection.Arg(value="nanos", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public Memory join(Environment env, Memory ... args) throws InterruptedException {
        this.thread.join(args[0].toLong(), args[1].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature
    public static Memory doYield(Environment env, Memory ... args) {
        Thread.yield();
        return Memory.NULL;
    }

    @Reflection.Signature
    public static Memory getActiveCount(Environment env, Memory ... args) {
        return LongMemory.valueOf(Thread.activeCount());
    }

    @Reflection.Signature
    public static Memory current(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapThread(env, Thread.currentThread()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="millis"), @Reflection.Arg(value="nanos", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public static Memory sleep(Environment env, Memory ... args) throws InterruptedException {
        Thread.sleep(args[0].toLong(), args[1].toInteger());
        return Memory.NULL;
    }

    @Override
    public boolean __equal(WrapThread iObject) {
        return this.thread == iObject.thread;
    }

    @Override
    public boolean __identical(WrapThread iObject) {
        return this.thread == iObject.thread;
    }

    @Override
    public boolean __greater(WrapThread iObject) {
        return false;
    }

    @Override
    public boolean __greaterEq(WrapThread iObject) {
        return false;
    }

    @Override
    public boolean __smaller(WrapThread iObject) {
        return false;
    }

    @Override
    public boolean __smallerEq(WrapThread iObject) {
        return false;
    }
}

