/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext;

import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.TimeoutException;
import php.runtime.env.CompileScope;
import php.runtime.env.Environment;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.ext.core.ArrayConstants;
import php.runtime.ext.core.ArrayFunctions;
import php.runtime.ext.core.InfoConstants;
import php.runtime.ext.core.InfoFunctions;
import php.runtime.ext.core.LangConstants;
import php.runtime.ext.core.LangFunctions;
import php.runtime.ext.core.MathConstants;
import php.runtime.ext.core.MathFunctions;
import php.runtime.ext.core.OutputConstants;
import php.runtime.ext.core.OutputFunctions;
import php.runtime.ext.core.StringFunctions;
import php.runtime.ext.core.classes.WrapClassLoader;
import php.runtime.ext.core.classes.WrapEnvironment;
import php.runtime.ext.core.classes.WrapEnvironmentVariables;
import php.runtime.ext.core.classes.WrapFuture;
import php.runtime.ext.core.classes.WrapInvoker;
import php.runtime.ext.core.classes.WrapJavaExceptions;
import php.runtime.ext.core.classes.WrapModule;
import php.runtime.ext.core.classes.WrapProcess;
import php.runtime.ext.core.classes.WrapSourceMap;
import php.runtime.ext.core.classes.WrapSystem;
import php.runtime.ext.core.classes.WrapThread;
import php.runtime.ext.core.classes.WrapThreadGroup;
import php.runtime.ext.core.classes.WrapThreadPool;
import php.runtime.ext.core.classes.format.WrapProcessor;
import php.runtime.ext.core.classes.lib.BinUtils;
import php.runtime.ext.core.classes.lib.CharUtils;
import php.runtime.ext.core.classes.lib.FsUtils;
import php.runtime.ext.core.classes.lib.ItemsUtils;
import php.runtime.ext.core.classes.lib.MirrorUtils;
import php.runtime.ext.core.classes.lib.NumUtils;
import php.runtime.ext.core.classes.lib.SharedUtils;
import php.runtime.ext.core.classes.lib.StrUtils;
import php.runtime.ext.core.classes.lib.legacy.OldBinUtils;
import php.runtime.ext.core.classes.lib.legacy.OldItemsUtils;
import php.runtime.ext.core.classes.lib.legacy.OldMirrorUtils;
import php.runtime.ext.core.classes.lib.legacy.OldNumUtils;
import php.runtime.ext.core.classes.net.WrapServerSocket;
import php.runtime.ext.core.classes.net.WrapSocket;
import php.runtime.ext.core.classes.net.WrapSocketException;
import php.runtime.ext.core.classes.stream.FileObject;
import php.runtime.ext.core.classes.stream.FileStream;
import php.runtime.ext.core.classes.stream.MemoryMiscStream;
import php.runtime.ext.core.classes.stream.MiscStream;
import php.runtime.ext.core.classes.stream.ResourceStream;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.ext.core.classes.time.WrapTime;
import php.runtime.ext.core.classes.time.WrapTimeFormat;
import php.runtime.ext.core.classes.time.WrapTimeZone;
import php.runtime.ext.core.classes.util.WrapConfiguration;
import php.runtime.ext.core.classes.util.WrapFlow;
import php.runtime.ext.core.classes.util.WrapLocale;
import php.runtime.ext.core.classes.util.WrapRegex;
import php.runtime.ext.core.classes.util.WrapScanner;
import php.runtime.ext.core.reflection.Reflection;
import php.runtime.ext.core.reflection.ReflectionClass;
import php.runtime.ext.core.reflection.ReflectionException;
import php.runtime.ext.core.reflection.ReflectionExtension;
import php.runtime.ext.core.reflection.ReflectionFunction;
import php.runtime.ext.core.reflection.ReflectionFunctionAbstract;
import php.runtime.ext.core.reflection.ReflectionMethod;
import php.runtime.ext.core.reflection.ReflectionObject;
import php.runtime.ext.core.reflection.ReflectionParameter;
import php.runtime.ext.core.reflection.ReflectionProperty;
import php.runtime.ext.core.reflection.Reflector;
import php.runtime.ext.support.Extension;
import php.runtime.ext.support.compile.CompileConstant;
import php.runtime.loader.sourcemap.SourceMap;

public class CoreExtension
extends Extension {
    public static final String NAMESPACE = "php\\";

    @Override
    public String getName() {
        return "Core";
    }

    @Override
    public Extension.Status getStatus() {
        return Extension.Status.STABLE;
    }

    @Override
    public void onRegister(CompileScope scope) {
        this.registerFunctions(new LangFunctions());
        this.registerConstants(new LangConstants());
        this.registerConstants(new InfoConstants());
        this.registerFunctions(new InfoFunctions());
        this.registerConstants(new MathConstants());
        this.registerFunctions(new MathFunctions());
        this.registerFunctions(new StringFunctions());
        this.registerConstants(new ArrayConstants());
        this.registerFunctions(new ArrayFunctions());
        this.registerConstants(new OutputConstants());
        this.registerFunctions(new OutputFunctions());
        for (ErrorType el : ErrorType.values()) {
            this.constants.put(el.name(), new CompileConstant(el.name(), el.value));
        }
        this.registerJavaException(scope, WrapJavaExceptions.IllegalArgumentException.class, IllegalArgumentException.class);
        this.registerJavaException(scope, WrapJavaExceptions.IllegalStateException.class, IllegalStateException.class);
        this.registerJavaException(scope, WrapJavaExceptions.NumberFormatException.class, NumberFormatException.class);
        this.registerJavaException(scope, WrapJavaExceptions.InterruptedException.class, InterruptedException.class);
        this.registerClass(scope, CharUtils.class);
        this.registerClass(scope, StrUtils.class);
        this.registerClass(scope, BinUtils.class);
        this.registerClass(scope, NumUtils.class);
        this.registerClass(scope, ItemsUtils.class);
        this.registerClass(scope, MirrorUtils.class);
        this.registerClass(scope, FsUtils.class);
        this.registerClass(scope, OldBinUtils.class);
        this.registerClass(scope, OldItemsUtils.class);
        this.registerClass(scope, OldNumUtils.class);
        this.registerClass(scope, OldMirrorUtils.class);
        this.registerClass(scope, SharedUtils.SharedMemory.class);
        this.registerClass(scope, SharedUtils.SharedValue.class);
        this.registerClass(scope, SharedUtils.SharedStack.class);
        this.registerClass(scope, SharedUtils.SharedQueue.class);
        this.registerClass(scope, SharedUtils.SharedMap.class);
        this.registerClass(scope, SharedUtils.class);
        this.registerClass(scope, WrapClassLoader.class);
        this.registerClass(scope, WrapClassLoader.WrapLauncherClassLoader.class);
        this.registerClass(scope, WrapLocale.class);
        this.registerClass(scope, WrapScanner.class);
        this.registerClass(scope, WrapFlow.class);
        this.registerClass(scope, WrapConfiguration.class);
        this.registerClass(scope, WrapRegex.class);
        this.registerJavaExceptionForContext(scope, WrapRegex.RegexException.class, WrapRegex.class);
        this.registerClass(scope, WrapTimeZone.class);
        this.registerClass(scope, WrapTimeFormat.class);
        this.registerClass(scope, WrapTime.class);
        this.registerClass(scope, WrapInvoker.class);
        this.registerClass(scope, WrapModule.class);
        this.registerWrapperClass(scope, SourceMap.class, WrapSourceMap.class);
        this.registerClass(scope, WrapEnvironment.class);
        this.registerClass(scope, WrapEnvironmentVariables.class);
        this.registerClass(scope, WrapThreadGroup.class);
        this.registerClass(scope, WrapThread.class);
        this.registerClass(scope, WrapSystem.class);
        this.registerClass(scope, Reflector.class);
        this.registerClass(scope, Reflection.class);
        this.registerClass(scope, ReflectionException.class);
        this.registerClass(scope, ReflectionExtension.class);
        this.registerClass(scope, ReflectionFunctionAbstract.class);
        this.registerClass(scope, ReflectionFunction.class);
        this.registerClass(scope, ReflectionParameter.class);
        this.registerClass(scope, ReflectionProperty.class);
        this.registerClass(scope, ReflectionMethod.class);
        this.registerClass(scope, ReflectionClass.class);
        this.registerClass(scope, ReflectionObject.class);
        this.registerClass(scope, WrapJavaExceptions.NotImplementedException.class);
        this.registerJavaException(scope, WrapIOException.class, IOException.class);
        this.registerClass(scope, FileObject.class);
        this.registerClass(scope, Stream.class);
        this.registerClass(scope, FileStream.class);
        this.registerClass(scope, MiscStream.class);
        this.registerClass(scope, MemoryMiscStream.class);
        this.registerClass(scope, ResourceStream.class);
        this.registerClass(scope, WrapSocket.class);
        this.registerClass(scope, WrapServerSocket.class);
        this.registerJavaException(scope, WrapSocketException.class, SocketException.class);
        this.registerClass(scope, WrapThreadPool.class);
        this.registerClass(scope, WrapFuture.class);
        this.registerJavaException(scope, WrapJavaExceptions.TimeoutException.class, TimeoutException.class);
        this.registerClass(scope, WrapProcessor.class);
        this.registerClass(scope, WrapProcessor.ProcessorException.class);
        this.registerClass(scope, WrapProcess.class);
    }

    @Override
    public void onLoad(Environment env) {
        Stream.initEnvironment(env);
    }
}

