/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.common.collections.iterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import php.runtime.common.collections.ResettableListIterator;
import php.runtime.common.collections.iterators.ObjectArrayIterator;

public class ObjectArrayListIterator<E>
extends ObjectArrayIterator<E>
implements ListIterator<E>,
ResettableListIterator<E> {
    protected int lastItemIndex = -1;

    public ObjectArrayListIterator() {
    }

    public ObjectArrayListIterator(E[] array) {
        super(array);
    }

    public ObjectArrayListIterator(E[] array, int start) {
        super(array, start);
    }

    public ObjectArrayListIterator(E[] array, int start, int end) {
        super(array, start, end);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > this.startIndex;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = --this.index;
        return (E)this.array[this.index];
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = this.index;
        return (E)this.array[this.index++];
    }

    @Override
    public int nextIndex() {
        return this.index - this.startIndex;
    }

    @Override
    public int previousIndex() {
        return this.index - this.startIndex - 1;
    }

    @Override
    public void add(E obj) {
        throw new UnsupportedOperationException("add() method is not supported");
    }

    @Override
    public void set(E obj) {
        if (this.lastItemIndex == -1) {
            throw new IllegalStateException("must call next() or previous() before a call to set()");
        }
        this.array[this.lastItemIndex] = obj;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastItemIndex = -1;
    }
}

