/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.json.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.develnext.jphp.json.JsonSerializable;
import php.runtime.Memory;
import php.runtime.common.collections.map.HashedMap;
import php.runtime.env.Environment;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

public class MemorySerializer
implements JsonSerializer<Memory> {
    protected boolean forceObject;
    protected boolean numericCheck;
    protected WeakReference<Environment> env;
    protected Map<Memory.Type, Handler> typeHandlers = new HashedMap<Memory.Type, Handler>(1);
    protected Map<String, Handler> classHandlers = new HashedMap<String, Handler>(1);

    public Environment getEnv() {
        return this.env == null ? null : (Environment)this.env.get();
    }

    public void setEnv(Environment env) {
        this.env = env == null ? null : new WeakReference<Environment>(env);
    }

    public boolean isForceObject() {
        return this.forceObject;
    }

    public void setForceObject(boolean forceObject) {
        this.forceObject = forceObject;
    }

    public boolean isNumericCheck() {
        return this.numericCheck;
    }

    public void setNumericCheck(boolean numericCheck) {
        this.numericCheck = numericCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonElement convert(Memory src, Set<Integer> used, boolean useHandlers) {
        Handler handler;
        if (useHandlers && (handler = this.typeHandlers.get((Object)src.getRealType())) != null) {
            return this.convert(handler.call(this.getEnv(), src), used, false);
        }
        switch (src.getRealType()) {
            case BOOL: {
                return new JsonPrimitive(src.toBoolean());
            }
            case DOUBLE: {
                return new JsonPrimitive(src.toDouble());
            }
            case INT: {
                return new JsonPrimitive(src.toLong());
            }
            case STRING: {
                if (this.numericCheck) {
                    Memory m = StringMemory.toLong(src.toString());
                    if (m != null) {
                        return new JsonPrimitive(m.toLong());
                    }
                    return new JsonPrimitive(src.toString());
                }
                return new JsonPrimitive(src.toString());
            }
            case NULL: {
                return JsonNull.INSTANCE;
            }
            case ARRAY: {
                if (used.add(src.getPointer())) {
                    JsonArray array = new JsonArray();
                    JsonObject object = new JsonObject();
                    boolean isList = !this.forceObject && src.toValue(ArrayMemory.class).isList();
                    ForeachIterator iterator = src.toValue(ArrayMemory.class).foreachIterator(false, false);
                    while (iterator.next()) {
                        if (isList) {
                            array.add(this.convert(iterator.getValue(), used, useHandlers));
                            continue;
                        }
                        object.add(iterator.getKey().toString(), this.convert(iterator.getValue(), used, useHandlers));
                    }
                    used.remove(src.getPointer());
                    return isList ? array : object;
                }
                return JsonNull.INSTANCE;
            }
            case OBJECT: {
                if (used.add(src.getPointer())) {
                    Object r;
                    IObject object = src.toValue(ObjectMemory.class).value;
                    if (useHandlers) {
                        Handler handler2;
                        ClassEntity pr = object.getReflection();
                        do {
                            handler2 = this.classHandlers.get(pr.getLowerName());
                        } while ((pr = pr.getParent()) != null && handler2 == null);
                        if (handler2 != null) {
                            return this.convert(handler2.call(this.getEnv(), src), used, false);
                        }
                    }
                    if (object instanceof JsonSerializable) {
                        Environment env = this.getEnv() == null ? Environment.current() : this.getEnv();
                        env.pushCall(object, "jsonSerialize", new Memory[0]);
                        try {
                            r = ((JsonSerializable)((Object)object)).jsonSerialize(Environment.current(), new Memory[0]);
                            JsonElement iterator = this.convert((Memory)r, used, useHandlers);
                            return iterator;
                        }
                        finally {
                            env.popCall();
                        }
                    }
                    ForeachIterator iterator = object.getProperties().foreachIterator(false, false);
                    r = new JsonObject();
                    while (iterator.next()) {
                        String key = iterator.getKey().toString();
                        if (key.startsWith("\u0000")) continue;
                        ((JsonObject)r).add(iterator.getKey().toString(), this.convert(iterator.getValue(), used, useHandlers));
                    }
                    return r;
                }
                return JsonNull.INSTANCE;
            }
        }
        return JsonNull.INSTANCE;
    }

    @Override
    public JsonElement serialize(Memory src, Type typeOfSrc, JsonSerializationContext context) {
        return this.convert(src, new HashSet<Integer>(), true);
    }

    public void setTypeHandler(Memory.Type type, Handler handler) {
        if (handler == null) {
            this.typeHandlers.remove((Object)type);
        } else {
            this.typeHandlers.put(type, handler);
        }
    }

    public void setClassHandler(String className, Handler handler) {
        className = className.toLowerCase();
        if (handler == null) {
            this.classHandlers.remove(className);
        } else {
            this.classHandlers.put(className, handler);
        }
    }

    public static interface Handler {
        public Memory call(Environment var1, Memory var2);
    }
}

