/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.tray.animations;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;
import org.develnext.jphp.ext.javafx.support.tray.animations.AnimationType;
import org.develnext.jphp.ext.javafx.support.tray.animations.TrayAnimation;
import org.develnext.jphp.ext.javafx.support.tray.models.CustomStage;

public class PopupAnimation
implements TrayAnimation {
    private final Timeline showAnimation;
    private final Timeline dismissAnimation;
    private final SequentialTransition sq;
    private final CustomStage stage;
    private boolean trayIsShowing;

    public PopupAnimation(CustomStage s) {
        this.stage = s;
        this.showAnimation = this.setupShowAnimation();
        this.dismissAnimation = this.setupDismissAnimation();
        this.sq = new SequentialTransition(new Animation[]{this.setupShowAnimation(), this.setupDismissAnimation()});
    }

    private Timeline setupDismissAnimation() {
        Timeline tl = new Timeline();
        KeyValue kv1 = new KeyValue((WritableValue)this.stage.yLocationProperty(), (Object)(this.stage.getY() + this.stage.getHeight()));
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{kv1});
        KeyValue kv2 = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)0.0);
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{kv2});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{kf1, kf2});
        tl.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                PopupAnimation.this.trayIsShowing = false;
                PopupAnimation.this.stage.hide();
                PopupAnimation.this.stage.setLocation(PopupAnimation.this.stage.getLocation());
            }
        });
        return tl;
    }

    private Timeline setupShowAnimation() {
        Timeline tl = new Timeline();
        KeyValue kv1 = new KeyValue((WritableValue)this.stage.yLocationProperty(), (Object)(this.stage.getLocation().getY() + this.stage.getHeight()));
        KeyFrame kf1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kv1});
        KeyValue kv2 = new KeyValue((WritableValue)this.stage.yLocationProperty(), (Object)this.stage.getLocation().getY());
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{kv2});
        KeyValue kv3 = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)0.0);
        KeyFrame kf3 = new KeyFrame(Duration.ZERO, new KeyValue[]{kv3});
        KeyValue kv4 = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)1.0);
        KeyFrame kf4 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{kv4});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{kf1, kf2, kf3, kf4});
        tl.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                PopupAnimation.this.trayIsShowing = true;
            }
        });
        return tl;
    }

    @Override
    public AnimationType getAnimationType() {
        return AnimationType.POPUP;
    }

    @Override
    public void setOnFinished(EventHandler<ActionEvent> onFinished) {
        this.sq.setOnFinished(onFinished);
    }

    @Override
    public void playSequential(Duration dismissDelay) {
        ((Animation)this.sq.getChildren().get(1)).setDelay(dismissDelay);
        this.sq.play();
    }

    @Override
    public void playShowAnimation() {
        this.showAnimation.play();
    }

    @Override
    public void playDismissAnimation() {
        this.dismissAnimation.play();
    }

    @Override
    public boolean isShowing() {
        return this.trayIsShowing;
    }
}

