/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class TabPaneEx
extends TabPane {
    protected EventHandler<Event> onCloseTab;
    protected EventHandler<Event> onCloseRequestTab;
    protected EventHandler<Event> onSelectionChange;

    public TabPaneEx() {
        this.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                TabPaneEx.this.doSelectionChange(newValue.intValue());
            }
        });
        this.getTabs().addListener((ListChangeListener)new ListChangeListener<Tab>(){

            public void onChanged(ListChangeListener.Change<? extends Tab> c) {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (Tab tab : c.getAddedSubList()) {
                        EventHandler closeRequest = tab.getOnCloseRequest();
                        tab.setOnClosed((EventHandler)new EventHandler<Event>(){

                            public void handle(Event event) {
                                TabPaneEx.this.doCloseTab(event);
                            }
                        });
                        tab.setOnCloseRequest((EventHandler)new EventHandler<Event>(){

                            public void handle(Event event) {
                                TabPaneEx.this.doCloseRequestTab(event);
                            }
                        });
                    }
                }
            }
        });
    }

    private void doCloseTab(Event event) {
        if (this.onCloseTab != null) {
            event = event.copyFor((Object)this, (EventTarget)event.getSource());
            this.onCloseTab.handle(event);
        }
    }

    private void doCloseRequestTab(Event event) {
        if (this.onCloseRequestTab != null) {
            Event newEvent = event.copyFor((Object)this, (EventTarget)event.getSource());
            this.onCloseRequestTab.handle(newEvent);
            if (newEvent.isConsumed()) {
                event.consume();
            }
        }
    }

    private void doSelectionChange(int index) {
        if (this.onSelectionChange != null) {
            Tab tab = (Tab)this.getTabs().get(index);
            Event event = new Event((Object)this, (EventTarget)tab, EventType.ROOT);
            this.onSelectionChange.handle(event);
        }
    }

    public EventHandler<Event> getOnCloseTab() {
        return this.onCloseTab;
    }

    public void setOnCloseTab(EventHandler<Event> onCloseTab) {
        this.onCloseTab = onCloseTab;
    }

    public EventHandler<Event> getOnCloseRequestTab() {
        return this.onCloseRequestTab;
    }

    public void setOnCloseRequestTab(EventHandler<Event> onCloseRequestTab) {
        this.onCloseRequestTab = onCloseRequestTab;
    }

    public EventHandler<Event> getOnSelectionChange() {
        return this.onSelectionChange;
    }

    public void setOnSelectionChange(EventHandler<Event> onSelectionChange) {
        this.onSelectionChange = onSelectionChange;
    }
}

