/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class PaginationEx
extends FlowPane {
    protected ObjectProperty<Font> font = new SimpleObjectProperty((Object)Font.getDefault());
    protected ObjectProperty<Color> textColor = new SimpleObjectProperty((Object)Color.BLACK);
    protected SimpleIntegerProperty total = new SimpleIntegerProperty(0);
    protected SimpleIntegerProperty pageSize;
    protected SimpleIntegerProperty selectedPage = new SimpleIntegerProperty(0);
    protected SimpleIntegerProperty maxPageCount = new SimpleIntegerProperty(9);
    protected BooleanProperty showPrevNext = new SimpleBooleanProperty(true);
    protected Button previousButton = new Button("<");
    protected Button nextButton = new Button(">");
    protected List<Button> pageButtons = new ArrayList<Button>();
    protected SimpleStringProperty hintText = new SimpleStringProperty("");
    protected SimpleBooleanProperty showTotal = new SimpleBooleanProperty(false);

    public PaginationEx() {
        this.getStyleClass().addAll((Object[])new String[]{"nav"});
        this.previousButton.getStyleClass().addAll((Object[])new String[]{"nav-item", "nav-item-prev"});
        this.nextButton.getStyleClass().addAll((Object[])new String[]{"nav-item", "nav-item-next"});
        ChangeListener changeListener = new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                PaginationEx.this.updateUi();
            }
        };
        this.total.addListener(changeListener);
        this.pageSizeProperty().addListener(changeListener);
        this.maxPageCount.addListener(changeListener);
        this.selectedPage.addListener(changeListener);
        this.showTotal.addListener(changeListener);
        this.hintText.addListener(changeListener);
        this.font.addListener(changeListener);
        this.textColor.addListener(changeListener);
        this.showPrevNext.addListener(changeListener);
        this.previousButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PaginationEx.this.selectedPage.get() > 0) {
                    PaginationEx.this.selectedPage.set(PaginationEx.this.selectedPage.get() - 1);
                }
            }
        });
        this.nextButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PaginationEx.this.selectedPage.get() < PaginationEx.this.getPageCount() - 1) {
                    PaginationEx.this.selectedPage.set(PaginationEx.this.selectedPage.get() + 1);
                }
            }
        });
    }

    public Font getFont() {
        return (Font)this.font.get();
    }

    public ObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public Color getTextColor() {
        return (Color)this.textColor.get();
    }

    public ObjectProperty<Color> textColorProperty() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor.set((Object)textColor);
    }

    public boolean getShowPrevNext() {
        return this.showPrevNext.get();
    }

    public BooleanProperty showPrevNextProperty() {
        return this.showPrevNext;
    }

    public void setShowPrevNext(boolean showPrevNext) {
        this.showPrevNext.set(showPrevNext);
    }

    public int getTotal() {
        return this.total.get();
    }

    public SimpleIntegerProperty totalProperty() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total.set(total);
    }

    public int getPageSize() {
        return this.pageSize.get();
    }

    public SimpleIntegerProperty pageSizeProperty() {
        if (this.pageSize == null) {
            this.pageSize = new SimpleIntegerProperty((Object)this, "pageSize", 20);
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize.set(pageSize);
    }

    public int getPageCount() {
        int pages = (int)Math.ceil((float)this.total.get() / (float)this.pageSize.get());
        return pages;
    }

    public int getSelectedPage() {
        return this.selectedPage.get();
    }

    public SimpleIntegerProperty selectedPageProperty() {
        return this.selectedPage;
    }

    public void setSelectedPage(int selectedPage) {
        this.selectedPage.set(selectedPage);
    }

    public int getMaxPageCount() {
        return this.maxPageCount.get();
    }

    public SimpleIntegerProperty maxPageCountProperty() {
        return this.maxPageCount;
    }

    public void setMaxPageCount(int maxPageCount) {
        this.maxPageCount.set(maxPageCount);
    }

    public Button getPreviousButton() {
        return this.previousButton;
    }

    public Button getNextButton() {
        return this.nextButton;
    }

    public String getHintText() {
        return this.hintText.get();
    }

    public SimpleStringProperty hintTextProperty() {
        return this.hintText;
    }

    public void setHintText(String hintText) {
        this.hintText.set(hintText);
    }

    public boolean isShowTotal() {
        return this.showTotal.get();
    }

    public SimpleBooleanProperty showTotalProperty() {
        return this.showTotal;
    }

    public void setShowTotal(boolean showTotal) {
        this.showTotal.set(showTotal);
    }

    protected void updateSelected() {
        this.updateUi();
    }

    protected void updateUi() {
        Button button;
        boolean firstSkip;
        int to;
        int from;
        ObservableList children = this.getChildren();
        children.clear();
        this.pageButtons.clear();
        int selectedPage = this.getSelectedPage();
        final int pages = this.getPageCount();
        if (this.getShowPrevNext()) {
            children.add((Object)this.previousButton);
        }
        if ((from = selectedPage - this.maxPageCount.get() / 2) < 0) {
            from = 0;
        }
        if ((to = from + this.maxPageCount.get()) > pages - 1) {
            to = pages;
        }
        if (to - from < this.maxPageCount.get() && (from -= this.maxPageCount.get() - (to - from)) < 0) {
            from = 0;
        }
        boolean lastSkip = to < pages;
        boolean bl = firstSkip = from > 0;
        if (firstSkip) {
            Button button2 = new Button(String.valueOf(1));
            button2.getStyleClass().addAll((Object[])new String[]{"nav-item", "nav-item-first"});
            button2.setFont(this.getFont());
            button2.setTextFill((Paint)this.getTextColor());
            button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    PaginationEx.this.setSelectedPage(0);
                }
            });
            this.pageButtons.add(button2);
            children.add((Object)button2);
            Label label = new Label("...");
            label.setFont(this.getFont());
            label.getStyleClass().addAll((Object[])new String[]{"nav-item-skip"});
            children.add((Object)label);
        }
        int i = from;
        while (i < to) {
            button = new Button(String.valueOf(i + 1));
            button.getStyleClass().addAll((Object[])new String[]{"nav-item"});
            button.setFont(this.getFont());
            button.setTextFill((Paint)this.getTextColor());
            if (selectedPage == i) {
                button.getStyleClass().addAll((Object[])new String[]{"selected"});
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        button.requestFocus();
                    }
                });
            }
            final int page = i++;
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    PaginationEx.this.setSelectedPage(page);
                }
            });
            this.pageButtons.add(button);
            children.addAll((Object[])new Node[]{button});
        }
        if (lastSkip) {
            Label label = new Label("...");
            label.getStyleClass().addAll((Object[])new String[]{"nav-item-skip"});
            label.setFont(this.getFont());
            children.add((Object)label);
            button = new Button(String.valueOf(pages));
            button.getStyleClass().addAll((Object[])new String[]{"nav-item", "nav-item-last"});
            button.setFont(this.getFont());
            button.setTextFill((Paint)this.getTextColor());
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    PaginationEx.this.setSelectedPage(pages - 1);
                }
            });
            this.pageButtons.add(button);
            children.add((Object)button);
        }
        if (this.getShowPrevNext()) {
            children.add((Object)this.nextButton);
        }
        this.previousButton.setFont(this.getFont());
        this.previousButton.setTextFill((Paint)this.getTextColor());
        this.nextButton.setFont(this.getFont());
        this.nextButton.setTextFill((Paint)this.getTextColor());
        this.previousButton.setDisable(selectedPage == 0);
        this.nextButton.setDisable(selectedPage == this.getPageCount() - 1);
        if (this.hintText.get() != null && !this.hintText.get().isEmpty()) {
            Label label = new Label(this.hintText.get());
            label.getStyleClass().add((Object)"nav-hint-text");
            label.setFont(this.getFont());
            children.add((Object)label);
        }
        if (this.showTotal.get()) {
            Label label = new Label(String.valueOf(this.total.get()));
            label.getStyleClass().addAll((Object[])new String[]{"nav-hint-total"});
            label.setFont(this.getFont());
            children.add((Object)label);
        }
    }
}

