/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.text.Font;
import org.develnext.jphp.ext.javafx.classes.text.UXFont;

public class LabelEx
extends Label {
    protected BooleanProperty autoSize;
    protected ObjectProperty<AutoSizeType> autoSizeType = new SimpleObjectProperty((Object)this, "autoSizeType", (Object)AutoSizeType.ALL);

    public LabelEx() {
        this("");
    }

    public LabelEx(String text) {
        this(text, null);
    }

    public LabelEx(String text, Node graphic) {
        super(text, graphic);
        this.setMnemonicParsing(false);
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                LabelEx.this.updateAutoSize();
            }
        });
        this.fontProperty().addListener((ChangeListener)new ChangeListener<Font>(){

            public void changed(ObservableValue<? extends Font> observable, Font oldValue, Font newValue) {
                LabelEx.this.updateAutoSize();
            }
        });
        this.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                LabelEx.this.updateAutoSize();
            }
        });
        this.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                LabelEx.this.updateAutoSize();
            }
        });
        this.graphicProperty().addListener((ChangeListener)new ChangeListener<Node>(){

            public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                LabelEx.this.updateAutoSize();
            }
        });
        this.autoSizeTypeProperty().addListener((ChangeListener)new ChangeListener<AutoSizeType>(){

            public void changed(ObservableValue<? extends AutoSizeType> observable, AutoSizeType oldValue, AutoSizeType newValue) {
                LabelEx.this.updateAutoSize();
            }
        });
    }

    public AutoSizeType getAutoSizeType() {
        return (AutoSizeType)((Object)this.autoSizeType.get());
    }

    public ObjectProperty<AutoSizeType> autoSizeTypeProperty() {
        return this.autoSizeType;
    }

    public void setAutoSizeType(AutoSizeType autoSizeType) {
        this.autoSizeType.set((Object)autoSizeType);
    }

    void updateAutoSize() {
        if (this.isAutoSize()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Node graphic = LabelEx.this.getGraphic();
                    if (LabelEx.this.getAutoSizeType() == AutoSizeType.ALL || LabelEx.this.getAutoSizeType() == AutoSizeType.HORIZONTAL) {
                        double width = UXFont.calculateTextWidth(LabelEx.this.getText(), LabelEx.this.getFont());
                        if (graphic != null) {
                            width += graphic.getLayoutBounds().getWidth() + LabelEx.this.getGraphicTextGap();
                        }
                        LabelEx.this.setPrefWidth(width);
                    }
                    if (LabelEx.this.getAutoSizeType() == AutoSizeType.ALL || LabelEx.this.getAutoSizeType() == AutoSizeType.VERTICAL) {
                        LabelEx.this.setPrefHeight(Math.max(UXFont.getLineHeight(LabelEx.this.getFont()), graphic == null ? 0.0 : graphic.getLayoutBounds().getHeight()));
                    }
                }
            });
        }
    }

    public final BooleanProperty autoSizeProperty() {
        if (this.autoSize == null) {
            this.autoSize = new SimpleBooleanProperty((Object)this, "autoSize", false);
        }
        return this.autoSize;
    }

    public final void setAutoSize(boolean value) {
        this.autoSizeProperty().setValue(Boolean.valueOf(value));
        this.updateAutoSize();
    }

    public final boolean isAutoSize() {
        return this.autoSize == null ? false : this.autoSize.getValue();
    }

    public static enum AutoSizeType {
        ALL,
        HORIZONTAL,
        VERTICAL;

    }
}

