/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.Invoker;
import php.runtime.memory.support.MemoryOperation;

public class ScriptEventHandler<T extends Event>
implements EventHandler<T> {
    protected final Environment env;
    protected final Map<String, Invoker> invokerMap;

    public ScriptEventHandler(Environment env) {
        this.env = env;
        this.invokerMap = new ConcurrentHashMap<String, Invoker>();
    }

    public void set(Invoker invoker, String group) {
        this.invokerMap.put(group, invoker);
    }

    public void set(Invoker invoker) {
        this.set(invoker, "general");
    }

    public void unset(String group) {
        this.invokerMap.remove(group);
    }

    public void clear() {
        this.invokerMap.clear();
    }

    public void handle(T t) {
        MemoryOperation operation;
        Memory event = Memory.NULL;
        if (t != null && (operation = MemoryOperation.get(t.getClass(), null)) != null) {
            try {
                event = operation.unconvert(this.env, TraceInfo.UNKNOWN, t);
            }
            catch (Throwable throwable) {
                this.env.wrapThrow(throwable);
            }
        }
        for (Invoker invoker : this.invokerMap.values()) {
            try {
                invoker.call(event);
            }
            catch (Throwable throwable) {
                this.env.wrapThrow(throwable);
            }
        }
    }
}

