/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.util.Scanner;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SingleSelectionModel;
import javafx.util.Callback;
import org.develnext.jphp.ext.javafx.classes.UXComboBoxBase;
import org.develnext.jphp.ext.javafx.classes.UXListCell;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.ForeachIterator;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXComboBox")
public class UXComboBox
extends UXComboBoxBase {
    public UXComboBox(Environment env, ComboBox wrappedObject) {
        super(env, wrappedObject);
    }

    public UXComboBox(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    public ComboBox getWrappedObject() {
        return (ComboBox)super.getWrappedObject();
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new ComboBox();
    }

    @Reflection.Signature
    public void __construct(Environment env, ForeachIterator iterator) {
        this.__construct();
        while (iterator.next()) {
            this.getWrappedObject().getItems().add(Memory.unwrap(env, iterator.getValue()));
        }
    }

    @Reflection.Getter
    public Object getSelected() {
        SingleSelectionModel selectionModel = this.getWrappedObject().getSelectionModel();
        return selectionModel.getSelectedItem();
    }

    @Reflection.Setter
    public void setSelected(Object value) {
        this.getWrappedObject().getSelectionModel().select(value);
    }

    @Reflection.Getter
    public int getSelectedIndex() {
        SingleSelectionModel selectionModel = this.getWrappedObject().getSelectionModel();
        return selectionModel.getSelectedIndex();
    }

    @Reflection.Setter
    public void setSelectedIndex(int value) {
        this.getWrappedObject().getSelectionModel().select(value);
    }

    @Reflection.Getter
    public String getText() {
        if (this.getWrappedObject().getEditor() == null) {
            Object value = this.getWrappedObject().getValue();
            return value == null ? null : value.toString();
        }
        return this.getWrappedObject().getEditor().getText();
    }

    @Reflection.Setter
    public void setText(String value) {
        if (this.getWrappedObject().getEditor() == null) {
            throw new IllegalStateException("Property 'text' is read only");
        }
        this.getWrappedObject().getEditor().setText(value);
    }

    @Reflection.Getter
    protected String getItemsText() {
        return StringUtils.join(this.getWrappedObject().getItems(), "\n");
    }

    @Reflection.Setter
    protected void setItemsText(String value) {
        Scanner scanner = new Scanner(value);
        this.getWrappedObject().getItems().clear();
        while (scanner.hasNextLine()) {
            this.getWrappedObject().getItems().add((Object)scanner.nextLine());
        }
    }

    @Reflection.Signature
    public void onButtonRender(final Environment env, final @Reflection.Nullable Invoker handler) {
        this.getWrappedObject().setButtonCell(new ListCell(){

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (handler != null) {
                    if (empty) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else {
                        handler.callAny(new UXListCell(env, this), item);
                    }
                }
            }
        });
    }

    @Reflection.Signature
    public void onCellRender(final Environment env, final @Reflection.Nullable Invoker handler) {
        this.getWrappedObject().setCellFactory((Callback)new Callback<ListView, ListCell>(){

            public ListCell call(ListView param) {
                return new ListCell(){

                    protected void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (handler != null) {
                            if (empty) {
                                this.setText(null);
                                this.setGraphic(null);
                            } else {
                                handler.callAny(new UXListCell(env, this), item, empty);
                            }
                        }
                    }
                };
            }
        });
    }

    static interface WrappedInterface {
        @Reflection.Property
        public ObservableList items();

        @Reflection.Property
        public int visibleRowCount();
    }
}

