/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.develnext.jphp.core.common.GrammarUtils;
import org.develnext.jphp.core.tokenizer.TokenFinder;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.BreakToken;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.OpenEchoTagToken;
import org.develnext.jphp.core.tokenizer.token.StringStartDocToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EchoRawToken;
import php.runtime.common.Directive;
import php.runtime.common.Messages;
import php.runtime.env.Context;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.ParseException;

public class Tokenizer {
    protected Context context;
    protected TokenFinder tokenFinder;
    private int currentPosition;
    private int startRelativePosition;
    private int relativePosition;
    private int currentLine;
    private final int codeLength;
    protected final String code;
    protected Token prevToken;
    protected boolean rawMode;
    protected Map<String, Directive> directives = new HashMap<String, Directive>();
    protected static final Map<Class<?>, Constructor> tokenConstructors = new HashMap();
    private Token token = new Token(null, TokenType.T_STRING);

    public Tokenizer(Context context) throws IOException {
        this.context = context;
        this.code = context.getContent();
        this.codeLength = this.code.length();
        this.rawMode = context.isLikeFile();
        this.reset();
    }

    public Tokenizer(String code, Context context) {
        this.context = context;
        this.currentPosition = -1;
        this.currentLine = 0;
        this.relativePosition = 0;
        this.code = code;
        this.codeLength = code.length();
        this.tokenFinder = new TokenFinder();
        this.rawMode = false;
    }

    public void reset() {
        this.currentPosition = -1;
        this.currentLine = 0;
        this.relativePosition = -1;
        this.tokenFinder = new TokenFinder();
        if (!this.rawMode) {
            this.relativePosition = 0;
        }
        this.directives.clear();
    }

    public boolean hasDirective(String name) {
        return this.directives.get(name) != null;
    }

    public Directive getDirective(String name) {
        Directive value = this.directives.get(name);
        if (value == null) {
            return null;
        }
        return value;
    }

    public String getCode() {
        return this.code;
    }

    protected <T extends Token> T buildToken(Class<T> clazz, TokenMeta meta) {
        Constructor<T> constructor = tokenConstructors.get(clazz);
        if (constructor == null) {
            try {
                constructor = clazz.getConstructor(TokenMeta.class);
                tokenConstructors.put(clazz, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.prevToken = (Token)constructor.newInstance(meta);
            return (T)this.prevToken;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable build " + clazz.getSimpleName() + " token: " + e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TokenMeta buildMeta(int startPosition, int startLine) {
        String word = this.getWord(startPosition, this.currentPosition);
        if (word == null) {
            return null;
        }
        TokenMeta meta = new TokenMeta(word, startLine, this.currentLine, this.startRelativePosition, this.relativePosition);
        int length = word.length();
        meta.setStartIndex(this.currentPosition - length);
        meta.setEndIndex(this.currentPosition);
        if (length == 1 && GrammarUtils.isDelimiter(word.charAt(0))) {
            meta.setStartIndex(this.currentPosition);
            meta.setEndIndex(this.currentPosition + 1);
        }
        return meta;
    }

    protected String getWord(int startPosition, int endPosition) {
        if (endPosition < startPosition) {
            return null;
        }
        if (endPosition == startPosition) {
            if (startPosition >= this.codeLength) {
                return null;
            }
            return this.code.substring(startPosition, startPosition + 1);
        }
        if (endPosition > this.codeLength) {
            endPosition = this.codeLength - 1;
        }
        return this.code.substring(startPosition, endPosition);
    }

    protected Token tryNextToken() {
        char ch;
        int len = 0;
        if (this.currentPosition + 1 < this.codeLength && GrammarUtils.isDelimiter(ch = this.code.charAt(this.currentPosition + 1)) && !GrammarUtils.isSpace(ch)) {
            len = 1;
            if (this.currentPosition + 2 < this.codeLength && GrammarUtils.isDelimiter(ch = this.code.charAt(this.currentPosition + 2)) && !GrammarUtils.isSpace(ch)) {
                len = 2;
            }
        }
        if (len == 0) {
            return null;
        }
        String word = this.getWord(this.currentPosition, this.currentPosition + len + 1);
        Class<? extends Token> tokenClass = this.tokenFinder.find(word);
        if (len == 2 && tokenClass == null) {
            word = this.getWord(this.currentPosition, this.currentPosition + --len + 1);
            tokenClass = this.tokenFinder.find(word);
        }
        if (tokenClass != null) {
            int startPosition = this.currentPosition;
            this.currentPosition += len + 1;
            Token token = this.buildToken(tokenClass, this.buildMeta(startPosition, this.currentLine));
            --this.currentPosition;
            return token;
        }
        return null;
    }

    private void incCurrentPosition(int value) {
        if (value < 0) {
            while (this.currentPosition > 0 && value < 0) {
                --this.currentPosition;
                ++value;
                if (!GrammarUtils.isNewline(this.code.charAt(this.currentPosition))) continue;
                --this.currentLine;
            }
        }
    }

    protected boolean checkNewLine(char ch, boolean invert) {
        if (GrammarUtils.isNewline(ch)) {
            this.currentLine = invert ? --this.currentLine : ++this.currentLine;
            this.relativePosition = 0;
            this.startRelativePosition = 0;
            return true;
        }
        return false;
    }

    protected boolean checkNewLine(char ch) {
        return this.checkNewLine(ch, false);
    }

    protected ValueExprToken readString(StringExprToken.Quote quote, int startPosition, int startLine) {
        int i;
        int pos = this.relativePosition + 1;
        StringExprToken.Quote ch_quote = null;
        boolean slash = false;
        StringBuilder sb = new StringBuilder();
        boolean isMagic = quote != null && quote.isMagic();
        String endString = null;
        int startIndex = this.currentPosition + 1;
        if (quote == StringExprToken.Quote.DOC) {
            StringBuilder tmp = new StringBuilder();
            StringExprToken.Quote docType = null;
            for (i = this.currentPosition + 1; i < this.codeLength; ++i) {
                char ch = this.code.charAt(i);
                ++pos;
                if (docType == null && GrammarUtils.isQuote(ch) != null) {
                    docType = GrammarUtils.isQuote(ch);
                    continue;
                }
                if (docType != null && docType == GrammarUtils.isQuote(ch)) {
                    if (i + 1 >= this.codeLength || !GrammarUtils.isNewline(this.code.charAt(i + 1))) {
                        throw new ParseException(Messages.ERR_PARSE_UNEXPECTED_END_OF_STRING.fetch(new Object[0]), new TraceInfo(this.context, this.currentLine, this.currentLine, pos + 1, pos + 1));
                    }
                    ++i;
                    break;
                }
                if (tmp.length() == 0 && (ch == ' ' || ch == '\t')) continue;
                if (GrammarUtils.isEngLetter(ch) || ch == '_' || tmp.length() != 0 && Character.isDigit(ch)) {
                    tmp.append(ch);
                    continue;
                }
                if (tmp.length() > 0 && this.checkNewLine(ch)) {
                    pos = 0;
                    break;
                }
                String error = Messages.ERR_PARSE_UNEXPECTED_X.fetch(Character.valueOf(ch));
                if (GrammarUtils.isNewline(ch)) {
                    error = Messages.ERR_PARSE_UNEXPECTED_END_OF_STRING.fetch(new Object[0]);
                }
                throw new ParseException(error, new TraceInfo(this.context, this.currentLine, this.currentLine, pos, pos));
            }
            this.currentPosition = i++;
            isMagic = docType == null || docType.isMagic();
            endString = tmp.toString();
        }
        ArrayList<StringExprToken.Segment> segments = new ArrayList<StringExprToken.Segment>();
        while (i < this.codeLength) {
            char ch = this.code.charAt(i);
            ++pos;
            ch_quote = GrammarUtils.isQuote(ch);
            if (endString == null && ch_quote == quote && !slash) {
                this.currentPosition = i;
                this.relativePosition = pos;
                break;
            }
            if (this.checkNewLine(ch)) {
                int end;
                pos = 0;
                if (endString != null && (end = i + 1 + endString.length()) < this.codeLength && this.code.substring(i + 1, end).equals(endString) && (this.code.charAt(end) == ';' && GrammarUtils.isNewline(this.code.charAt(end + 1)) || GrammarUtils.isNewline(this.code.charAt(end)))) {
                    this.currentPosition = i + endString.length();
                    this.relativePosition = endString.length();
                    ch_quote = StringExprToken.Quote.DOC;
                    break;
                }
            }
            if (!isMagic) {
                switch (ch) {
                    case '\\': {
                        if (!slash || endString != null) {
                            sb.append(ch);
                        }
                        slash = !slash;
                        break;
                    }
                    case '\'': {
                        if (endString == null) {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                    }
                    default: {
                        sb.append(ch);
                        slash = false;
                        break;
                    }
                }
            } else {
                int k;
                int j;
                int dynamic = 0;
                if (!slash) {
                    if (ch == '$' && i + 1 < this.codeLength && this.code.charAt(i + 1) == '{') {
                        dynamic = 2;
                    }
                    if (ch == '{' && i + 1 < this.codeLength && this.code.charAt(i + 1) == '$') {
                        dynamic = 1;
                    }
                }
                if (dynamic > 0 && (dynamic == 2 || i + 1 < this.codeLength && this.code.charAt(i + 1) == '$')) {
                    slash = false;
                    int opened = dynamic == 2 ? 0 : 1;
                    for (j = i + 1; j < this.codeLength; ++j) {
                        switch (this.code.charAt(j)) {
                            case '{': {
                                ++opened;
                                break;
                            }
                            case '}': {
                                --opened;
                            }
                        }
                        this.checkNewLine(this.code.charAt(j));
                        if (opened == 0) break;
                    }
                    if (opened != 0) {
                        throw new ParseException(Messages.ERR_PARSE_UNEXPECTED_END_OF_STRING.fetch(new Object[0]), new TraceInfo(this.context, startLine, 0, this.relativePosition, 0));
                    }
                    String sub = this.code.substring(i, j + 1);
                    segments.add(new StringExprToken.Segment(sb.length(), sb.length() + sub.length(), dynamic == 2));
                    sb.append(sub);
                    i = j;
                } else if (slash) {
                    switch (ch) {
                        case 'r': {
                            sb.append('\r');
                            slash = false;
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            slash = false;
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            slash = false;
                            break;
                        }
                        case 'e': {
                            sb.append('\u001b');
                            slash = false;
                            break;
                        }
                        case 'v': {
                            sb.append('\u000b');
                            slash = false;
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            slash = false;
                            break;
                        }
                        case '\\': {
                            sb.append(ch);
                            slash = !slash;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            char digit;
                            k = i + 1;
                            for (j = 1; j < 3 && (k = i + j) < this.codeLength && (digit = this.code.charAt(k)) >= '0' && digit <= '7'; ++j) {
                            }
                            String s = this.code.substring(i, k);
                            if (s.isEmpty()) {
                                sb.append(ch);
                            } else {
                                int val = Integer.parseInt(s, 8);
                                sb.append((char)val);
                            }
                            i = k - 1;
                            slash = false;
                            break;
                        }
                        case 'x': {
                            char digit;
                            int t = i + 1;
                            for (int j2 = 1; j2 < 5 && (t = i + j2) < this.codeLength && (Character.isDigit(digit = this.code.charAt(t)) || digit >= 'A' && digit <= 'F' || digit >= 'a' && digit <= 'f'); ++j2) {
                            }
                            String s16 = this.code.substring(i + 1, t);
                            if (s16.isEmpty()) {
                                sb.append(ch);
                            } else {
                                int val16 = Integer.parseInt(s16, 16);
                                sb.append((char)val16);
                            }
                            i = t - 1;
                            slash = false;
                            break;
                        }
                        default: {
                            slash = false;
                            sb.append(ch);
                            break;
                        }
                    }
                } else {
                    switch (ch) {
                        case '\\': {
                            slash = true;
                            break;
                        }
                        case '$': {
                            char first;
                            k = i + 1;
                            boolean done = false;
                            int opened = 0;
                            int complex = 0;
                            if (k < this.codeLength && (GrammarUtils.isEngLetter(first = this.code.charAt(k)) || first == '_')) {
                                ++k;
                                done = true;
                                while (i < this.codeLength && k < this.codeLength) {
                                    first = this.code.charAt(k);
                                    if (!(Character.isDigit(first) || GrammarUtils.isEngLetter(first) || first == '_' || complex == 1 && GrammarUtils.isVariableChar(first) && this.code.charAt(k - 1) == '[')) {
                                        if (complex == 0 && first == '[') {
                                            ++opened;
                                            complex = 1;
                                        } else if (complex == 1 && opened != 0 && first == ']') {
                                            if (--opened <= 0) {
                                                ++k;
                                                break;
                                            }
                                        } else {
                                            if (complex != 0 || first != '-' || k + 1 >= this.codeLength || this.code.charAt(k + 1) != '>') break;
                                            ++k;
                                            complex = 2;
                                        }
                                    }
                                    ++k;
                                }
                            }
                            if (done) {
                                if (opened != 0) {
                                    throw new ParseException(Messages.ERR_PARSE_UNEXPECTED_END_OF_STRING.fetch(new Object[0]), new TraceInfo(this.context, startLine, 0, pos, 0));
                                }
                                String s = this.code.substring(i, k);
                                segments.add(new StringExprToken.Segment(sb.length(), sb.length() + s.length(), true));
                                sb.append(s);
                            } else {
                                sb.append(ch);
                            }
                            i = k - 1;
                            break;
                        }
                        default: {
                            sb.append(ch);
                        }
                    }
                }
            }
            ++i;
        }
        if (ch_quote != quote || slash) {
            throw new ParseException(Messages.ERR_PARSE_UNEXPECTED_END_OF_STRING.fetch(new Object[0]), new TraceInfo(this.context, this.currentLine, this.currentLine, pos, pos));
        }
        TokenMeta meta = this.buildMeta(startPosition + 1, startLine);
        meta.setStartIndex(startIndex - 1);
        if (quote == StringExprToken.Quote.DOC) {
            meta.setEndIndex(this.currentPosition + 3);
        } else {
            meta.setEndIndex(this.currentPosition + 1);
        }
        meta.setWord(sb.toString());
        StringExprToken expr = new StringExprToken(meta, quote);
        expr.setSegments(segments);
        return expr;
    }

    protected Token readComment(CommentToken.Kind kind, int startPosition, int startLine) {
        int pos = this.relativePosition;
        int k = 0;
        boolean isOldComment = this.code.charAt(this.currentPosition) == '#';
        int i = this.currentPosition + 1;
        while (i < this.codeLength) {
            char ch = this.code.charAt(i);
            ++pos;
            if (this.checkNewLine(ch)) {
                pos = 0;
            }
            char prev_ch = i > 0 ? this.code.charAt(i - 1) : (char)'\u0000';
            boolean closed = false;
            switch (kind) {
                case SIMPLE: {
                    closed = GrammarUtils.isNewline(ch);
                    if (!GrammarUtils.isCloseTag(String.valueOf(new char[]{prev_ch, ch}))) break;
                    i -= 2;
                    closed = true;
                    break;
                }
                case DOCTYPE: 
                case BLOCK: {
                    closed = k != 0 && GrammarUtils.isCloseComment(String.valueOf(new char[]{prev_ch, ch}));
                }
            }
            boolean bl = closed = closed || i == this.codeLength - 1;
            if (closed) {
                int p;
                String directive;
                String text = this.code.substring(startPosition, kind == CommentToken.Kind.SIMPLE ? i : i - 1);
                TokenMeta meta = new TokenMeta(text, startLine, this.currentLine, this.startRelativePosition, this.relativePosition);
                meta.setStartIndex(this.currentPosition - 1);
                if (isOldComment || kind == CommentToken.Kind.DOCTYPE) {
                    meta.setStartIndex(this.currentPosition);
                }
                if (kind == CommentToken.Kind.BLOCK || kind == CommentToken.Kind.DOCTYPE) {
                    meta.setEndIndex(i + 1);
                } else {
                    meta.setEndIndex(i);
                }
                this.currentPosition = i;
                this.relativePosition = pos;
                CommentToken result = this.buildToken(CommentToken.class, meta);
                if (kind == CommentToken.Kind.SIMPLE && text.startsWith("//") && (directive = text.substring(2).trim()).startsWith("@@") && (p = directive.indexOf(32)) != -1) {
                    String value;
                    String name = directive.substring(2, p);
                    String string = value = p + 1 < directive.length() ? directive.substring(p + 1) : "";
                    if (!this.directives.containsKey(name.toLowerCase())) {
                        this.directives.put(name.toLowerCase(), new Directive(value, result.toTraceInfo(this.context)));
                    }
                }
                return result;
            }
            ++i;
            ++k;
        }
        assert (false);
        return null;
    }

    protected Token readNumber(int startPosition, int startLine) {
        boolean isBinary;
        boolean dot = false;
        boolean e_char = false;
        int i = this.currentPosition;
        boolean isHex = this.code.charAt(i) == '0' && i < this.codeLength && Character.toLowerCase(this.code.charAt(i + 1)) == 'x';
        boolean bl = isBinary = this.code.charAt(i) == '0' && i < this.codeLength && this.code.charAt(i + 1) == 'b';
        if (isHex || isBinary) {
            i += 2;
        }
        while (i < this.codeLength) {
            char ch = this.code.charAt(i);
            if (!isHex && GrammarUtils.isFloatDot(ch)) {
                if (dot) break;
                dot = true;
            } else if (!(isHex || ch != 'e' && ch != 'E')) {
                if (e_char || i + 1 >= this.codeLength) break;
                if (this.code.charAt(i + 1) == '-' || this.code.charAt(i + 1) == '+' || Character.isDigit(this.code.charAt(i + 2))) {
                    if (i + 2 >= this.codeLength || !Character.isDigit(this.code.charAt(i + 2))) break;
                    ++i;
                }
                e_char = true;
            } else if (!(isHex && (ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f') || isBinary && (ch == '0' || ch == '1') || Character.isDigit(ch))) break;
            ++i;
        }
        this.currentPosition = i;
        TokenMeta meta = this.buildMeta(startPosition, startLine);
        Class<? extends Token> tokenClazz = this.tokenFinder.find(meta);
        --this.currentPosition;
        return this.buildToken(tokenClazz, meta);
    }

    public Token nextToken() {
        Class<EchoRawToken> tokenClazz;
        boolean init = false;
        char ch = '\u0000';
        char prev_ch = '\u0000';
        int startPosition = this.currentPosition + 1;
        this.startRelativePosition = this.relativePosition;
        int startLine = this.currentLine;
        StringExprToken.Quote string = null;
        CommentToken.Kind comment = null;
        if (this.codeLength == 0) {
            return null;
        }
        boolean first = true;
        while (this.currentPosition < this.codeLength) {
            ++this.currentPosition;
            ++this.relativePosition;
            if (this.currentPosition == this.codeLength) break;
            ch = this.code.charAt(this.currentPosition);
            if (this.currentPosition > 0 && init) {
                prev_ch = this.code.charAt(this.currentPosition - 1);
            }
            this.checkNewLine(ch);
            if (this.rawMode) {
                if (GrammarUtils.isOpenTag(String.valueOf(new char[]{prev_ch, ch}))) {
                    TokenMeta meta = new TokenMeta(this.code.substring(startPosition, this.currentPosition - 1), startLine, this.currentLine, this.startRelativePosition, this.relativePosition);
                    this.rawMode = false;
                    startLine = this.currentLine;
                    this.startRelativePosition = this.relativePosition;
                    EchoRawToken token = this.buildToken(EchoRawToken.class, meta);
                    if (this.codeLength >= this.currentPosition + 4 && this.code.substring(this.currentPosition + 1, this.currentPosition + 4).equals("php")) {
                        this.relativePosition += 4;
                        this.currentPosition += 3;
                        token.setShort(false);
                    } else {
                        token.setShort(true);
                    }
                    return token;
                }
                init = true;
                first = true;
                continue;
            }
            if (ch == '=' && this.prevToken != null && this.prevToken instanceof EchoRawToken && ((EchoRawToken)this.prevToken).isShort()) {
                return this.buildToken(OpenEchoTagToken.class, this.buildMeta(startPosition, startLine));
            }
            if (first && (!init || this.prevToken == null)) {
                if (Character.isDigit(ch) || ch == '.' && this.prevToken == null && this.currentPosition + 1 < this.codeLength && Character.isDigit(this.code.charAt(this.currentPosition + 1))) {
                    return this.readNumber(startPosition, startLine);
                }
                comment = CommentToken.Kind.isComment(ch, prev_ch);
                if (comment != null) {
                    return this.readComment(comment, startPosition, startLine);
                }
                string = GrammarUtils.isQuote(ch);
                if (string != null) {
                    return this.readString(string, startPosition, startLine);
                }
            }
            init = true;
            first = false;
            if (GrammarUtils.isDelimiter(ch)) {
                if (startPosition == this.currentPosition && GrammarUtils.isSpace(ch)) {
                    startPosition = this.currentPosition + 1;
                    startLine = this.currentLine;
                    this.startRelativePosition = this.relativePosition;
                    this.prevToken = null;
                    first = true;
                    continue;
                }
                if (startPosition != this.currentPosition) break;
                Token token = this.tryNextToken();
                if (token instanceof BreakToken) {
                    this.rawMode = true;
                }
                if (token instanceof CommentToken) {
                    comment = ((CommentToken)token).getKind();
                    return this.readComment(comment, startPosition, startLine);
                }
                if (token instanceof StringStartDocToken) {
                    string = StringExprToken.Quote.DOC;
                    return this.readString(string, startPosition, startLine);
                }
                if (token == null) break;
                return token;
            }
            if (!GrammarUtils.isVariableChar(ch) || !GrammarUtils.isVariableChar(prev_ch)) continue;
            --this.currentPosition;
            break;
        }
        TokenMeta meta = this.buildMeta(startPosition, startLine);
        if (this.currentPosition != startPosition && GrammarUtils.isDelimiter(ch)) {
            this.checkNewLine(ch, true);
            --this.currentPosition;
            --this.relativePosition;
        }
        if (meta == null) {
            return null;
        }
        Class clazz = tokenClazz = this.rawMode ? EchoRawToken.class : this.tokenFinder.find(meta);
        if (tokenClazz == null) {
            this.prevToken = new Token(meta, TokenType.T_J_CUSTOM);
            return this.prevToken;
        }
        return this.buildToken(tokenClazz, meta);
    }

    public List<Token> fetchAll() {
        Token token;
        ArrayList<Token> result = new ArrayList<Token>();
        while ((token = this.nextToken()) != null) {
            result.add(token);
        }
        return result;
    }

    public Context getContext() {
        return this.context;
    }
}

