/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tester;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import php.runtime.common.StringUtils;

public class Test {
    protected String test;
    protected String description;
    protected String credits;
    protected String skipIf;
    protected String request;
    protected String post;
    protected String put;
    protected String post_raw;
    protected String gzip_post;
    protected String deflate_post;
    protected String get;
    protected String cookie;
    protected String stdin;
    protected String ini;
    protected String args;
    protected String env;
    protected String file;
    protected String fileEof;
    protected String file_external;
    protected String redirectTest;
    protected String headers;
    protected String cgi;
    protected String xfail;
    protected String expectHeaders;
    protected String expect;
    protected String expectF;
    protected String expectRegex;
    protected String expectExternal;
    protected String expectRegex_external;
    protected String clean;
    private Map<String, String> _sections;
    private Map<String, Integer> _sectionLines;

    public Test(File file) {
        try {
            this._sections = new LinkedHashMap<String, String>();
            this._sectionLines = new HashMap<String, Integer>();
            Scanner reader = new Scanner(new FileReader(file));
            ArrayList<String> content = new ArrayList<String>();
            String section = null;
            int i = 0;
            while (reader.hasNextLine()) {
                String line = reader.nextLine();
                if (line == null) {
                    line = "";
                }
                if (line.startsWith("--") && line.endsWith("--") && line.length() > 2 && Character.isLetter(line.charAt(2))) {
                    if (section != null) {
                        this._sections.put(section, StringUtils.join(content, '\n'));
                    }
                    section = line.substring(2, line.length() - 2);
                    this._sectionLines.put(section, i);
                    content = new ArrayList();
                } else if (section != null) {
                    content.add(line);
                }
                ++i;
            }
            if (section != null) {
                this._sections.put(section, StringUtils.join(content, '\n'));
            }
            this.test = this._sections.get("TEST");
            this.description = this._sections.get("DESCRIPTION");
            this.credits = this._sections.get("CREDITS");
            this.skipIf = this._sections.get("SKIPIF");
            this.request = this._sections.get("REQUEST");
            this.post = this._sections.get("POST");
            this.post_raw = this._sections.get("POST_RAW");
            this.put = this._sections.get("PUT");
            this.gzip_post = this._sections.get("GZIP_POST");
            this.deflate_post = this._sections.get("DEFLATE_POST");
            this.get = this._sections.get("GET");
            this.cookie = this._sections.get("COOKIE");
            this.stdin = this._sections.get("STDIN");
            this.ini = this._sections.get("INI");
            this.args = this._sections.get("ARGS");
            this.env = this._sections.get("ENV");
            this.file = this._sections.get("FILE");
            this.fileEof = this._sections.get("FILEEOF");
            this.file_external = this._sections.get("FILE_EXTERNAL");
            this.redirectTest = this._sections.get("REDIRECT_TEST");
            this.headers = this._sections.get("HEADERS");
            this.cgi = this._sections.get("CGI");
            this.xfail = this._sections.get("XFAIL");
            this.expectHeaders = this._sections.get("EXPECT_HEADERS");
            this.expect = this._sections.get("EXPECT");
            this.expectF = this._sections.get("EXPECTF");
            this.expectRegex = this._sections.get("EXPECTREGEX");
            this.expectExternal = this._sections.get("EXPECTEXTERNAL");
            this.expectRegex_external = this._sections.get("EXPECTREGEX_EXTERNAL");
            this.clean = this._sections.get("CLEAN");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean run(PrintStream output) {
        return true;
    }

    public Map<String, String> getSections() {
        return this._sections;
    }

    public String getExpect() {
        return this.expect;
    }

    public String getExpectF() {
        return this.expectF;
    }

    public String getTest() {
        return this.test;
    }

    public String getFile() {
        return this.file;
    }

    public String getCookie() {
        return this.cookie;
    }

    public int getSectionLine(String section) {
        return this._sectionLines.get(section);
    }
}

