/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.manually.BodyGenerator;
import org.develnext.jphp.core.syntax.generators.manually.SimpleExprGenerator;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.CommaToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AmpersandRefToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArgumentUnpackExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ImportExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ArgumentStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EchoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;
import php.runtime.common.HintType;

public class FunctionGenerator
extends Generator<FunctionStmtToken> {
    protected static final Set<String> scalarTypeHints = new HashSet<String>(){
        {
            this.add("array");
            this.add("callable");
        }
    };
    protected static final Set<String> jphp_scalarTypeHints = new HashSet<String>(){
        {
            this.add("scalar");
            this.add("number");
            this.add("string");
            this.add("int");
            this.add("integer");
            this.add("double");
            this.add("float");
            this.add("bool");
            this.add("boolean");
        }
    };

    public FunctionGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    protected ArgumentStmtToken processArgument(ListIterator<Token> iterator) {
        boolean isReference = false;
        boolean isVariadic = false;
        VariableExprToken variable = null;
        ExprStmtToken value = null;
        Token next = this.nextToken(iterator);
        if (next instanceof CommaToken || this.isClosedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            return null;
        }
        FulledNameToken hintTypeClass = null;
        HintType hintType = null;
        if (next instanceof SelfExprToken) {
            if (this.analyzer.getClazz() == null) {
                this.unexpectedToken(next);
            }
            next = this.analyzer.getClazz().getName();
        }
        if (next instanceof NameToken) {
            String word = ((NameToken)next).getName().toLowerCase();
            if (scalarTypeHints.contains(word)) {
                hintType = HintType.of(word);
            } else {
                HintType hintType2 = hintType = jphp_scalarTypeHints.contains(word) ? null : HintType.of(word);
                if (hintType == null) {
                    hintTypeClass = this.analyzer.getRealName((NameToken)next);
                }
            }
            next = this.nextToken(iterator);
        }
        if (next instanceof AmpersandRefToken) {
            isReference = true;
            next = this.nextToken(iterator);
        }
        if (next instanceof ArgumentUnpackExprToken) {
            isVariadic = true;
            next = this.nextToken(iterator);
        }
        if (next instanceof VariableExprToken) {
            variable = (VariableExprToken)next;
        } else {
            this.unexpectedToken(next);
        }
        next = this.nextToken(iterator);
        if (next instanceof AssignExprToken) {
            if (isVariadic) {
                this.unexpectedToken(next);
            }
            value = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, true, BraceExprToken.Kind.SIMPLE);
        } else if (next instanceof CommaToken || this.isClosedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            if (next instanceof BraceExprToken) {
                iterator.previous();
            } else if (isVariadic) {
                this.unexpectedToken(next);
            }
        } else {
            this.unexpectedToken(next);
        }
        ArgumentStmtToken argument = new ArgumentStmtToken(variable.getMeta());
        argument.setName(variable);
        argument.setHintType(hintType);
        argument.setHintTypeClass(hintTypeClass);
        argument.setReference(isReference);
        argument.setVariadic(isVariadic);
        argument.setValue(value);
        if (argument.isReference() && argument.getValue() != null) {
            this.analyzer.getFunction().variable(argument.getName()).setUsed(true);
        }
        return argument;
    }

    protected void processArguments(FunctionStmtToken result, ListIterator<Token> iterator) {
        ArgumentStmtToken argument;
        this.checkUnexpectedEnd(iterator);
        ArrayList<ArgumentStmtToken> arguments = new ArrayList<ArgumentStmtToken>();
        while (iterator.hasNext() && (argument = this.processArgument(iterator)) != null) {
            arguments.add(argument);
        }
        result.setArguments(arguments);
    }

    protected void processUses(FunctionStmtToken result, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        if (next instanceof NamespaceUseStmtToken) {
            ArgumentStmtToken argument;
            next = this.nextToken(iterator);
            if (!this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
                this.unexpectedToken(next, "(");
            }
            ArrayList<ArgumentStmtToken> arguments = new ArrayList<ArgumentStmtToken>();
            while (iterator.hasNext() && (argument = this.processArgument(iterator)) != null) {
                if (argument.getValue() != null) {
                    this.unexpectedToken(argument.getValue().getSingle());
                }
                arguments.add(argument);
                FunctionStmtToken parent = this.analyzer.getFunction(true);
                if (parent == null) continue;
                parent.variable(argument.getName()).setUsed(true);
                if (argument.isReference()) {
                    parent.variable(argument.getName()).setPassed(true).setUnstable(true);
                }
                if ((parent = this.analyzer.peekClosure()) == null) continue;
                parent.variable(argument.getName()).setUnstable(true);
            }
            result.setUses(arguments);
        } else {
            result.setUses(new ArrayList<ArgumentStmtToken>());
            iterator.previous();
        }
    }

    protected void processBody(FunctionStmtToken result, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        if (this.isOpenedBrace(next, BraceExprToken.Kind.BLOCK)) {
            Token body = this.analyzer.generator(BodyGenerator.class).getToken(next, (ListIterator)iterator);
            result.setBody((BodyStmtToken)body);
        } else if (next instanceof SemicolonToken) {
            result.setInterfacable(true);
            result.setBody(null);
        } else {
            this.unexpectedToken(next);
        }
    }

    public FunctionStmtToken getToken(Token current, ListIterator<Token> iterator, boolean closureAllowed) {
        if (current instanceof FunctionStmtToken) {
            Token next;
            CommentToken commentToken = null;
            iterator.previous();
            if (iterator.hasPrevious()) {
                int cnt = 0;
                while (iterator.hasPrevious()) {
                    ++cnt;
                    Token previous = iterator.previous();
                    if (previous.isNamedToken()) continue;
                    if (!(previous instanceof CommentToken) || ((CommentToken)previous).getKind() != CommentToken.Kind.DOCTYPE) break;
                    commentToken = (CommentToken)previous;
                    break;
                }
                for (int i = 0; i < cnt; ++i) {
                    iterator.next();
                }
            }
            iterator.next();
            FunctionStmtToken result = (FunctionStmtToken)current;
            result.setStatic(this.analyzer.getFunction() == null);
            Class[] excludes = new Class[]{EchoStmtToken.class, ImportExprToken.class};
            if (this.analyzer.getClazz() != null) {
                excludes = new Class[]{};
            }
            if ((next = this.nextTokenSensitive(iterator, excludes)) instanceof AmpersandRefToken) {
                result.setReturnReference(true);
                next = this.nextTokenSensitive(iterator, excludes);
            }
            if (next instanceof NameToken) {
                this.analyzer.addScope(true);
                FunctionStmtToken oldFunction = this.analyzer.getFunction();
                this.analyzer.setFunction(result);
                BraceExprToken brace = this.nextAndExpected(iterator, BraceExprToken.class);
                if (!brace.isSimpleOpened()) {
                    this.unexpectedToken(brace, "(");
                }
                result.setNamespace(this.analyzer.getNamespace());
                result.setName((NameToken)next);
                result.setDocComment(commentToken);
                this.processArguments(result, iterator);
                this.processBody(result, iterator);
                result.setTypeInfo(this.analyzer.getScope().getTypeInfo());
                result.setLabels(this.analyzer.getScope().getLabels());
                result.setLocal(this.analyzer.removeScope().getVariables());
                Token previous = iterator.previous();
                result.getMeta().setEndLine(previous.getMeta().getStartLine());
                result.getMeta().setEndPosition(previous.getMeta().getStartPosition());
                iterator.next();
                this.analyzer.setFunction(oldFunction);
                return result;
            }
            if (next instanceof BraceExprToken && ((BraceExprToken)next).isSimpleOpened()) {
                if (closureAllowed) {
                    this.analyzer.pushClosure(result);
                    this.analyzer.addScope(true);
                    this.processArguments(result, iterator);
                    this.processUses(result, iterator);
                    this.processBody(result, iterator);
                    result.setTypeInfo(this.analyzer.getScope().getTypeInfo());
                    result.setLabels(this.analyzer.getScope().getLabels());
                    result.setStaticExists(this.analyzer.getScope().isStaticExists());
                    result.setLocal(this.analyzer.removeScope().getVariables());
                    this.analyzer.popClosure();
                    FunctionStmtToken prevClosure = this.analyzer.peekClosure();
                    if (prevClosure != null && result.isThisExists()) {
                        this.analyzer.getScope().addVariable(FunctionStmtToken.thisVariable);
                    }
                    ArrayList<VariableExprToken> uses = new ArrayList<VariableExprToken>();
                    for (ArgumentStmtToken argument : result.getUses()) {
                        if (argument.isReference() && this.analyzer.getFunction() != null) {
                            this.analyzer.getFunction().variable(argument.getName()).setReference(true);
                        }
                        if (this.analyzer.getFunction() != null) {
                            this.analyzer.getFunction().variable(argument.getName()).setUsed(true);
                        }
                        uses.add(argument.getName());
                    }
                    this.analyzer.getScope().addVariables(uses);
                    Token previous = iterator.previous();
                    result.getMeta().setEndLine(previous.getMeta().getStartLine());
                    result.getMeta().setEndPosition(previous.getMeta().getStartPosition());
                    iterator.next();
                    return result;
                }
                iterator.previous();
                return null;
            }
            this.unexpectedToken(next);
        }
        return null;
    }

    @Override
    public FunctionStmtToken getToken(Token current, ListIterator<Token> iterator) {
        return this.getToken(current, iterator, false);
    }
}

