/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import php.runtime.Memory;

public class PrintF {
    private static final BigInteger BIG_2_64 = BigInteger.ONE.shiftLeft(64);
    private static final BigInteger BIG_TEN = new BigInteger("10");
    private final String format;
    private final Locale locale;
    protected final Memory[] args;

    public PrintF(Locale locale, String format, Memory[] args) {
        this.locale = locale;
        this.format = format;
        this.args = args;
    }

    private List<Segment> parse() {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int length = this.format.length();
        boolean start = false;
        int index = 0;
        StringBuilder sb = new StringBuilder();
        StringBuilder flags = new StringBuilder();
        block17: for (int i = 0; i < length; ++i) {
            char ch = this.format.charAt(i);
            if (i + 1 < length && ch == '%') {
                int j;
                sb.append(ch);
                boolean isLeft = false;
                boolean isAlt = false;
                boolean isShowSign = false;
                int argIndex = -1;
                int leftPadLength = 0;
                int width = 0;
                int padChar = -1;
                flags.setLength(0);
                block18: for (j = i + 1; j < length; ++j) {
                    ch = this.format.charAt(j);
                    switch (ch) {
                        case '-': {
                            isLeft = true;
                            if (j + 1 >= length || this.format.charAt(j + 1) != '0') continue block18;
                            padChar = 48;
                            ++j;
                            continue block18;
                        }
                        case '#': {
                            isAlt = true;
                            continue block18;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            char digit;
                            if (ch == '0' && padChar < 0) {
                                padChar = 48;
                                continue block18;
                            }
                            int value = ch - 48;
                            for (int k = j + 1; k < length && Character.isDigit(digit = this.format.charAt(k)); ++k) {
                                value = value * 10 + digit - 48;
                                ++j;
                            }
                            if (j + 1 < length && this.format.charAt(j + 1) == '$') {
                                argIndex = value - 1;
                                ++j;
                                continue block18;
                            }
                            width = value;
                            continue block18;
                        }
                        case '\'': {
                            padChar = this.format.charAt(j + 1);
                            ++j;
                            continue block18;
                        }
                        case '+': {
                            isShowSign = true;
                            continue block18;
                        }
                        case ' ': 
                        case '(': 
                        case ',': {
                            flags.append(ch);
                            continue block18;
                        }
                    }
                }
                int head = j;
                if (argIndex < 0) {
                    argIndex = index;
                }
                while (j < length) {
                    ch = this.format.charAt(j);
                    switch (ch) {
                        case '%': {
                            i = j;
                            segments.add(new TextSegment(sb.toString()));
                            sb.setLength(0);
                            continue block17;
                        }
                        case '$': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case 'S': 
                        case 's': {
                            sb.setLength(sb.length() - 1);
                            if (width <= 0 && 0 < leftPadLength) {
                                width = leftPadLength;
                            }
                            ++index;
                            segments.add(new StringSegment(sb, isLeft || isAlt, padChar, ch == 'S', width, this.format.substring(head, j), argIndex));
                            sb.setLength(0);
                            i = j;
                            continue block17;
                        }
                        case 'C': 
                        case 'c': {
                            sb.setLength(sb.length() - 1);
                            if (width <= 0 && 0 < leftPadLength) {
                                width = leftPadLength;
                            }
                            ++index;
                            segments.add(new CharSegment(sb, isLeft || isAlt, padChar, ch == 'C', width, this.format.substring(head, j), argIndex));
                            sb.setLength(0);
                            i = j;
                            continue block17;
                        }
                        case 'i': {
                            ch = 'd';
                        }
                        case 'B': 
                        case 'X': 
                        case 'b': 
                        case 'd': 
                        case 'o': 
                        case 'u': 
                        case 'x': {
                            sb.setLength(sb.length() - 1);
                            if (sb.length() > 0) {
                                segments.add(new TextSegment(sb.toString()));
                            }
                            sb.setLength(0);
                            if (isAlt) {
                                sb.append('#');
                            }
                            if (isShowSign) {
                                sb.append('+');
                            }
                            sb.append((CharSequence)flags);
                            if (width > 0) {
                                if (isLeft) {
                                    sb.append('-');
                                } else if (padChar == 48) {
                                    sb.append('0');
                                }
                                sb.append(width);
                            }
                            sb.append(this.format, head, j);
                            sb.append(ch);
                            ++index;
                            segments.add(LongSegment.valueOf(sb.toString(), argIndex));
                            sb.setLength(0);
                            i = j;
                            continue block17;
                        }
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            Locale _locale = this.locale;
                            if (ch == 'F') {
                                ch = 'f';
                            } else {
                                _locale = null;
                            }
                            sb.setLength(sb.length() - 1);
                            if (sb.length() > 0) {
                                segments.add(new TextSegment(sb.toString()));
                            }
                            sb.setLength(0);
                            if (isAlt) {
                                sb.append('#');
                            }
                            if (isShowSign) {
                                sb.append('+');
                            }
                            sb.append((CharSequence)flags);
                            if (width > 0) {
                                if (isLeft) {
                                    sb.append('-');
                                } else if (padChar == 48) {
                                    sb.append('0');
                                }
                                sb.append(width);
                            }
                            sb.append(this.format, head, j);
                            sb.append(ch);
                            ++index;
                            segments.add(new DoubleSegment(sb.toString(), isLeft && padChar == 48, argIndex, _locale));
                            sb.setLength(0);
                            i = j;
                            continue block17;
                        }
                        default: {
                            if (isLeft) {
                                sb.append('-');
                            }
                            if (isAlt) {
                                sb.append('#');
                            }
                            sb.append((CharSequence)flags);
                            sb.append(this.format, head, j);
                            sb.append(ch);
                            i = j;
                            continue block17;
                        }
                    }
                    ++j;
                }
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            segments.add(new TextSegment(sb.toString()));
        }
        return segments;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Segment segment : this.parse()) {
            if (segment.apply(this.locale, builder, this.args)) continue;
            return null;
        }
        return builder.toString();
    }

    static class DoubleSegment
    extends Segment {
        private final String _format;
        private final boolean _isLeftZero;
        private final int _index;
        private final Locale _locale;

        @Override
        public Memory.Type getType() {
            return Memory.Type.DOUBLE;
        }

        DoubleSegment(String format, boolean isLeftZero, int index, Locale locale) {
            super(format);
            if (DoubleSegment.hasIndex(format)) {
                this._index = DoubleSegment.getIndex(format);
                this._format = DoubleSegment.getIndexFormat(format);
            } else {
                this._format = '%' + format;
                this._index = index;
            }
            this._isLeftZero = isLeftZero;
            this._locale = locale;
        }

        @Override
        public boolean apply(Locale locale, StringBuilder sb, Memory[] args) {
            if (this._index >= args.length) {
                return false;
            }
            double value = args[this._index].toDouble();
            String s = this._locale == null ? String.format(Locale.ENGLISH, this._format, value) : String.format(this._locale, this._format, value);
            if (this._isLeftZero) {
                int len = s.length();
                for (int i = 0; i < len; ++i) {
                    char ch = s.charAt(i);
                    if (ch == ' ') {
                        sb.append('0');
                        continue;
                    }
                    sb.append(ch);
                }
            } else {
                sb.append(s);
            }
            return true;
        }
    }

    static class UnsignedSegment
    extends Segment {
        private final int _index;
        private final int _min;
        private final char _pad;

        @Override
        public Memory.Type getType() {
            return Memory.Type.INT;
        }

        UnsignedSegment(String format, int index, int min, int pad) {
            super(format);
            this._index = index;
            this._min = min;
            this._pad = pad >= 0 ? (char)pad : (char)32;
        }

        static UnsignedSegment valueOf(String format, int index) {
            int length = format.length();
            int offset = 1;
            if (format.charAt(offset) == '+') {
                ++offset;
            }
            int pad = 32;
            if (format.charAt(offset) == ' ') {
                pad = 32;
                ++offset;
            } else if (format.charAt(offset) == '0') {
                pad = 48;
                ++offset;
            }
            int min = 0;
            while (offset < length - 1) {
                char ch = format.charAt(offset);
                if ('0' > ch || ch > '9') {
                    return null;
                }
                min = 10 * min + ch - 48;
                ++offset;
            }
            return new UnsignedSegment(format, index, min, pad);
        }

        @Override
        public boolean apply(Locale locale, StringBuilder sb, Memory[] args) {
            long value;
            if (this._index < 0 || this._index >= args.length) {
                return false;
            }
            char[] buf = new char[32];
            int digits = buf.length;
            if (value == 0L) {
                buf[--digits] = 48;
            } else if (value > 0L) {
                for (value = args[this._index].toLong(); value != 0L; value /= 10L) {
                    int digit = (int)(value % 10L);
                    buf[--digits] = (char)(48 + digit);
                }
            } else {
                BigInteger bigInt = new BigInteger(String.valueOf(value));
                bigInt = bigInt.add(BIG_2_64);
                while (bigInt.compareTo(BigInteger.ZERO) != 0) {
                    int digit = bigInt.mod(BIG_TEN).intValue();
                    buf[--digits] = (char)(48 + digit);
                    bigInt = bigInt.divide(BIG_TEN);
                }
            }
            for (int i = buf.length - digits; i < this._min; ++i) {
                sb.append(this._pad);
            }
            while (digits < buf.length) {
                sb.append(buf[digits]);
                ++digits;
            }
            return true;
        }
    }

    static class BinarySegment
    extends Segment {
        private final int _index;
        private final int _min;
        private final char _pad;

        @Override
        public Memory.Type getType() {
            return Memory.Type.INT;
        }

        BinarySegment(String format, int index, int min, int pad) {
            super(format);
            this._index = index;
            this._min = min;
            this._pad = pad >= 0 ? (char)pad : (char)32;
        }

        static BinarySegment valueOf(String format, int index) {
            int length = format.length();
            int offset = 1;
            int pad = 32;
            if (format.charAt(offset) == ' ') {
                pad = 32;
                ++offset;
            } else if (format.charAt(offset) == '0') {
                pad = 48;
                ++offset;
            }
            int min = 0;
            while (offset < length - 1) {
                char ch = format.charAt(offset);
                if ('0' > ch || ch > '9') {
                    return null;
                }
                min = 10 * min + ch - 48;
                ++offset;
            }
            return new BinarySegment(format, index, min, pad);
        }

        @Override
        public boolean apply(Locale locale, StringBuilder sb, Memory[] args) {
            int i;
            if (this._index < 0 || this._index >= args.length) {
                return false;
            }
            long value = args[this._index].toLong();
            int digits = 0;
            long shift = value;
            for (i = 0; i < 64; ++i) {
                if (shift != 0L) {
                    digits = i;
                }
                shift >>>= 1;
            }
            for (i = digits + 1; i < this._min; ++i) {
                sb.append(this._pad);
            }
            while (digits >= 0) {
                int digit = (int)(value >>> digits) & 1;
                sb.append((char)(48 + digit));
                --digits;
            }
            return true;
        }
    }

    static class HexSegment
    extends Segment {
        private final int _index;
        private final int _min;
        private final char _pad;
        private boolean _isUpper;

        HexSegment(String format, int index, int min, int pad, boolean isUpper) {
            super(format);
            this._index = index;
            this._min = min;
            this._pad = pad >= 0 ? (char)pad : (char)32;
            this._isUpper = isUpper;
        }

        static HexSegment valueOf(String format, int index) {
            int length = format.length();
            int offset = 1;
            boolean isUpper = format.charAt(length - 1) == 'X';
            int pad = 32;
            if (format.charAt(offset) == ' ') {
                pad = 32;
                ++offset;
            } else if (format.charAt(offset) == '0') {
                pad = 48;
                ++offset;
            }
            int min = 0;
            while (offset < length - 1) {
                char ch = format.charAt(offset);
                if ('0' > ch || ch > '9') {
                    return null;
                }
                min = 10 * min + ch - 48;
                ++offset;
            }
            return new HexSegment(format, index, min, pad, isUpper);
        }

        @Override
        public Memory.Type getType() {
            return Memory.Type.INT;
        }

        @Override
        public boolean apply(Locale locale, StringBuilder sb, Memory[] args) {
            int i;
            if (this._index < 0 || this._index >= args.length) {
                return false;
            }
            long value = args[this._index].toLong();
            int digits = 0;
            long shift = value;
            for (i = 0; i < 16; ++i) {
                if (shift != 0L) {
                    digits = i;
                }
                shift >>>= 4;
            }
            for (i = digits + 1; i < this._min; ++i) {
                sb.append(this._pad);
            }
            while (digits >= 0) {
                int digit = (int)(value >>> 4 * digits) & 0xF;
                if (digit <= 9) {
                    sb.append((char)(48 + digit));
                } else if (this._isUpper) {
                    sb.append((char)(65 + digit - 10));
                } else {
                    sb.append((char)(97 + digit - 10));
                }
                --digits;
            }
            return true;
        }
    }

    static class LongSegment
    extends Segment {
        protected int _index;

        LongSegment(String format, int _index) {
            super(format);
            this._index = _index;
        }

        static Segment valueOf(String format, int index) {
            UnsignedSegment unsign;
            BinarySegment bin;
            HexSegment hex;
            if (LongSegment.hasIndex(format)) {
                index = LongSegment.getIndex(format);
                format = LongSegment.getIndexFormat(format);
            } else {
                format = '%' + format;
            }
            if (format.length() > 1 && format.charAt(1) == '.') {
                char ch;
                int i;
                for (i = 2; i < format.length() && Character.isDigit(ch = format.charAt(i)); ++i) {
                }
                format = '%' + format.substring(i);
            }
            if ((format.charAt(format.length() - 1) == 'x' || format.charAt(format.length() - 1) == 'X') && (hex = HexSegment.valueOf(format, index)) != null) {
                return hex;
            }
            if ((format.charAt(format.length() - 1) == 'b' || format.charAt(format.length() - 1) == 'B') && (bin = BinarySegment.valueOf(format, index)) != null) {
                return bin;
            }
            if (format.charAt(format.length() - 1) == 'u' && (unsign = UnsignedSegment.valueOf(format, index)) != null) {
                return unsign;
            }
            return new LongSegment(format, index);
        }

        @Override
        public Memory.Type getType() {
            return Memory.Type.INT;
        }

        @Override
        protected boolean apply(Locale locale, StringBuilder sb, Memory[] args) {
            if (this._index >= args.length) {
                return false;
            }
            long value = args[this._index].toLong();
            sb.append(String.format(Locale.ENGLISH, this.format, value));
            return true;
        }
    }

    static class StringSegment
    extends Segment {
        protected final char[] _prefix;
        protected final int _min;
        protected final int _max;
        protected final boolean _isLeft;
        protected final boolean _isUpper;
        protected final char _pad;
        protected final int _index;

        public StringSegment(StringBuilder prefix, boolean isLeft, int pad, boolean isUpper, int width, String format, int index) {
            super(format);
            this._prefix = new char[prefix.length()];
            this._isLeft = isLeft;
            this._isUpper = isUpper;
            this._pad = pad >= 0 ? (char)pad : (char)32;
            prefix.getChars(0, this._prefix.length, this._prefix, 0);
            if (StringSegment.hasIndex(format)) {
                index = StringSegment.getIndex(format);
                format = StringSegment.getIndexFormat(format);
            }
            int i = 0;
            int len = format.length();
            int max = Integer.MAX_VALUE;
            if (0 < len && format.charAt(0) == '.') {
                char ch;
                max = 0;
                ++i;
                while (i < len && '0' <= (ch = format.charAt(i)) && ch <= '9') {
                    max = 10 * max + ch - 48;
                    ++i;
                }
            }
            this._min = width;
            this._max = max;
            this._index = index;
        }

        @Override
        public Memory.Type getType() {
            return Memory.Type.STRING;
        }

        protected String toValue(Memory[] args) {
            return args[this._index].toString();
        }

        @Override
        protected boolean apply(Locale locale, StringBuilder sb, Memory[] args) {
            int i;
            sb.append(this._prefix, 0, this._prefix.length);
            if (this._index >= args.length) {
                return false;
            }
            String value = this.toValue(args);
            int len = value.length();
            if (this._max < len) {
                value = value.substring(0, this._max);
                len = this._max;
            }
            if (this._isUpper) {
                value = value.toUpperCase();
            }
            if (!this._isLeft) {
                for (i = len; i < this._min; ++i) {
                    sb.append(this._pad);
                }
            }
            sb.append(value);
            if (this._isLeft) {
                for (i = len; i < this._min; ++i) {
                    sb.append(this._pad);
                }
            }
            return true;
        }
    }

    public class TextSegment
    extends Segment {
        public TextSegment(String format) {
            super(format);
        }

        @Override
        public Memory.Type getType() {
            return Memory.Type.STRING;
        }

        @Override
        protected boolean apply(Locale locale, StringBuilder sb, Memory[] args) {
            sb.append(this.format);
            return true;
        }
    }

    static class CharSegment
    extends StringSegment {
        public CharSegment(StringBuilder prefix, boolean isLeft, int pad, boolean isUpper, int width, String format, int index) {
            super(prefix, isLeft, pad, isUpper, width, format, index);
        }

        @Override
        public Memory.Type getType() {
            return Memory.Type.INT;
        }

        @Override
        protected String toValue(Memory[] args) {
            return String.valueOf(args[this._index].toChar());
        }
    }

    public static abstract class Segment {
        protected final String format;

        public Segment(String format) {
            this.format = format;
        }

        static boolean hasIndex(String format) {
            return format.indexOf(36) >= 0;
        }

        static int getIndex(String format) {
            char ch;
            int value = 0;
            for (int i = 0; i < format.length() && '0' <= (ch = format.charAt(i)) && ch <= '9'; ++i) {
                value = 10 * value + ch - 48;
            }
            return value - 1;
        }

        static String getIndexFormat(String format) {
            int p = format.indexOf(36);
            return '%' + format.substring(p + 1);
        }

        public abstract Memory.Type getType();

        protected abstract boolean apply(Locale var1, StringBuilder var2, Memory[] var3);
    }
}

