/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection.support;

import php.runtime.Memory;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.IObject;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.support.ReflectionUtils;

public abstract class TypeChecker {
    public abstract String getSignature();

    public abstract boolean check(Environment var1, Memory var2, boolean var3);

    public static TypeChecker of(HintType type) {
        return new Simple(type);
    }

    public static TypeChecker of(String className) {
        return new ClassName(className);
    }

    public static TypeChecker of(Class<?> typeNativeClass) {
        return new NativeClass(typeNativeClass);
    }

    public static TypeChecker ofEnum(Class<? extends Enum> enumClass) {
        return new EnumClass(enumClass);
    }

    public static class EnumClass
    extends TypeChecker {
        protected Class<? extends Enum> typeEnum;

        public EnumClass(Class<? extends Enum> typeEnum) {
            this.typeEnum = typeEnum;
        }

        public Class<? extends Enum> getTypeEnum() {
            return this.typeEnum;
        }

        @Override
        public String getSignature() {
            return null;
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable) {
            try {
                if (nullable && value.isNull()) {
                    return true;
                }
                Enum.valueOf(this.typeEnum, value.toString());
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    public static class NativeClass
    extends TypeChecker {
        protected Class<?> typeNativeClass;

        public NativeClass(Class<?> typeNativeClass) {
            this.typeNativeClass = typeNativeClass;
        }

        @Override
        public String getSignature() {
            return ReflectionUtils.getClassName(this.typeNativeClass);
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable) {
            if (nullable && value.isNull()) {
                return true;
            }
            if (value.isObject()) {
                IObject object = value.toObject(IObject.class);
                if (object instanceof BaseWrapper) {
                    return this.typeNativeClass.isAssignableFrom(((BaseWrapper)object).getWrappedObject().getClass());
                }
                return false;
            }
            return false;
        }
    }

    public static class ClassName
    extends TypeChecker {
        protected String typeClass;
        protected String typeClassLower;

        public ClassName(String typeClass) {
            this.typeClass = typeClass;
            this.typeClassLower = typeClass.toLowerCase();
        }

        public String getTypeClass() {
            return this.typeClass;
        }

        public String getTypeClassLower() {
            return this.typeClassLower;
        }

        @Override
        public String getSignature() {
            return this.typeClass;
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable) {
            if (nullable && value.isNull()) {
                return true;
            }
            if (!value.isObject()) {
                return false;
            }
            ObjectMemory object = value.toValue(ObjectMemory.class);
            ClassEntity oEntity = object.getReflection();
            return oEntity.isInstanceOfLower(this.typeClassLower);
        }
    }

    public static class Simple
    extends TypeChecker {
        protected HintType type;

        public Simple(HintType type) {
            this.type = type;
        }

        public HintType getType() {
            return this.type;
        }

        @Override
        public String getSignature() {
            return this.type.toString();
        }

        @Override
        public boolean check(Environment env, Memory value, boolean nullable) {
            if (nullable && value.isNull()) {
                return true;
            }
            switch (this.type) {
                case SCALAR: {
                    switch (value.getRealType()) {
                        case BOOL: 
                        case INT: 
                        case DOUBLE: 
                        case STRING: {
                            return true;
                        }
                    }
                    return false;
                }
                case OBJECT: {
                    return value.isObject();
                }
                case NUMBER: {
                    return value.isNumber();
                }
                case DOUBLE: {
                    return value.getRealType() == Memory.Type.DOUBLE;
                }
                case INT: {
                    return value.getRealType() == Memory.Type.INT;
                }
                case STRING: {
                    return value.isString();
                }
                case BOOLEAN: {
                    return value.getRealType() == Memory.Type.BOOL;
                }
                case ARRAY: {
                    return value.isArray();
                }
                case TRAVERSABLE: {
                    return value.isArray() || value.instanceOf("Traversable", "traversable");
                }
                case CALLABLE: {
                    Invoker invoker = Invoker.valueOf(env, null, value);
                    return invoker != null && invoker.canAccess(env) == 0;
                }
            }
            return true;
        }
    }
}

