/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection.support;

import php.runtime.Memory;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.ext.support.Extension;
import php.runtime.lang.Closure;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.GeneratorEntity;
import php.runtime.reflection.support.Entity;
import php.runtime.reflection.support.TypeChecker;

public abstract class AbstractFunctionEntity
extends Entity {
    protected boolean isImmutable;
    protected boolean isEmpty = false;
    protected DocumentComment docComment;
    protected boolean returnReference;
    protected ParameterEntity[] parameters;
    protected TypeChecker returnTypeChecker;
    protected Memory result;
    protected boolean abstractable = false;
    protected Extension extension;
    protected boolean deprecated;
    protected boolean usesStackTrace = false;
    protected GeneratorEntity generatorEntity;

    protected AbstractFunctionEntity(Context context) {
        super(context);
    }

    public Closure getClosure(Environment env) {
        return null;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public Memory getResult() {
        return this.result;
    }

    public void setResult(Memory result) {
        this.result = result;
    }

    public void unsetArguments(Memory[] arguments) {
        if (arguments != null) {
            int x = 0;
            for (Memory argument : arguments) {
                if (argument == null) continue;
                if (argument.isArray()) {
                    ParameterEntity param;
                    ParameterEntity parameterEntity = param = this.parameters != null && x < this.parameters.length ? this.parameters[x] : null;
                    if (param == null || param.isUsed() && param.isMutable() && !param.isReference()) {
                        argument.unset();
                    }
                }
                ++x;
            }
        }
    }

    public boolean isAbstractable() {
        return this.abstractable;
    }

    public void setAbstractable(boolean abstractable) {
        this.abstractable = abstractable;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean empty) {
        this.isEmpty = empty;
    }

    public DocumentComment getDocComment() {
        return this.docComment;
    }

    public void setDocComment(DocumentComment docComment) {
        this.docComment = docComment;
    }

    public void setParameters(ParameterEntity[] parameters) {
        this.parameters = parameters;
    }

    public ParameterEntity[] getParameters() {
        return this.getParameters(-1);
    }

    public ParameterEntity[] getParameters(int count) {
        return this.parameters;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public Memory getImmutableResult() {
        if (this.isImmutable && !this.abstractable) {
            return this.getResult().toImmutable();
        }
        return null;
    }

    public void setImmutable(boolean immutable) {
        this.isImmutable = immutable;
    }

    public boolean isReturnReference() {
        return this.returnReference;
    }

    public void setReturnReference(boolean returnReference) {
        this.returnReference = returnReference;
    }

    public boolean isUsesStackTrace() {
        return this.usesStackTrace;
    }

    public void setUsesStackTrace(boolean usesStackTrace) {
        this.usesStackTrace = usesStackTrace;
    }

    public GeneratorEntity getGeneratorEntity() {
        return this.generatorEntity;
    }

    public void setGeneratorEntity(GeneratorEntity generatorEntity) {
        this.generatorEntity = generatorEntity;
    }

    public void setReturnTypeChecker(TypeChecker returnTypeChecker) {
        this.returnTypeChecker = returnTypeChecker;
    }

    public TypeChecker getReturnTypeChecker() {
        return this.returnTypeChecker;
    }
}

