/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.support.operation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import php.runtime.exceptions.CriticalException;
import php.runtime.memory.support.MemoryOperation;

public abstract class GenericMemoryOperation<T>
extends MemoryOperation<T> {
    protected MemoryOperation[] operations;

    protected GenericMemoryOperation() {
        this(null);
    }

    public static Class<?> getRawType(ParameterizedType type) {
        try {
            return Class.forName(type.getRawType().toString().split(" ", 2)[1]);
        }
        catch (ClassNotFoundException e) {
            throw new CriticalException(e);
        }
    }

    public GenericMemoryOperation(Type ... genericTypes) {
        if (genericTypes != null) {
            this.operations = new MemoryOperation[genericTypes.length];
            for (int i = 0; i < genericTypes.length; ++i) {
                Type genericType;
                if (genericTypes[i] instanceof ParameterizedType) {
                    genericType = (ParameterizedType)genericTypes[i];
                    this.operations[i] = MemoryOperation.get(GenericMemoryOperation.getRawType(genericType), genericType);
                    if (this.operations[i] != null) continue;
                    throw new CriticalException("Unsupported generic type binding - " + genericType);
                }
                genericType = (Class)genericTypes[i];
                this.operations[i] = MemoryOperation.get(genericType, null);
                if (this.operations[i] != null) continue;
                throw new CriticalException("Unsupported type binding - " + genericType);
            }
        }
    }

    @Override
    protected GenericMemoryOperation<T> instance(Type ... genericTypes) {
        if (genericTypes != null && genericTypes.length > 0) {
            try {
                return (GenericMemoryOperation)this.getClass().getConstructor(Type[].class).newInstance(new Object[]{genericTypes});
            }
            catch (InstantiationException e) {
                throw new CriticalException(e);
            }
            catch (IllegalAccessException e) {
                throw new CriticalException(e);
            }
            catch (InvocationTargetException e) {
                throw new CriticalException(e);
            }
            catch (NoSuchMethodException e) {
                throw new CriticalException(e);
            }
        }
        return (GenericMemoryOperation)super.instance(genericTypes);
    }
}

