/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.IObject;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.support.operation.ArrayMemoryMemoryOperation;
import php.runtime.memory.support.operation.BigDecimalOperation;
import php.runtime.memory.support.operation.BigIntegerOperation;
import php.runtime.memory.support.operation.BinaryMemoryOperation;
import php.runtime.memory.support.operation.BooleanMemoryOperation;
import php.runtime.memory.support.operation.ByteArrayInputStreamMemoryOperation;
import php.runtime.memory.support.operation.ByteMemoryOperation;
import php.runtime.memory.support.operation.CharSequenceMemoryOperation;
import php.runtime.memory.support.operation.CharacterMemoryOperation;
import php.runtime.memory.support.operation.ClassMemoryOperation;
import php.runtime.memory.support.operation.DateMemoryOperation;
import php.runtime.memory.support.operation.DoubleMemoryOperation;
import php.runtime.memory.support.operation.FileMemoryOperation;
import php.runtime.memory.support.operation.FloatMemoryOperation;
import php.runtime.memory.support.operation.ForeachIteratorMemoryOperation;
import php.runtime.memory.support.operation.InputStreamMemoryOperation;
import php.runtime.memory.support.operation.IntegerMemoryOperation;
import php.runtime.memory.support.operation.InvokerMemoryOperation;
import php.runtime.memory.support.operation.LocaleMemoryOperation;
import php.runtime.memory.support.operation.LongMemoryOperation;
import php.runtime.memory.support.operation.MemoryMemoryOperation;
import php.runtime.memory.support.operation.NumberMemoryOperation;
import php.runtime.memory.support.operation.ObjectMemoryOperation;
import php.runtime.memory.support.operation.OutputStreamMemoryOperation;
import php.runtime.memory.support.operation.PatternMemoryOperation;
import php.runtime.memory.support.operation.ScannerMemoryOperation;
import php.runtime.memory.support.operation.ShortMemoryOperation;
import php.runtime.memory.support.operation.StringMemoryOperation;
import php.runtime.memory.support.operation.ThreadGroupMemoryOperation;
import php.runtime.memory.support.operation.ThreadMemoryOperation;
import php.runtime.memory.support.operation.TimeZoneMemoryOperation;
import php.runtime.memory.support.operation.UriMemoryOperation;
import php.runtime.memory.support.operation.UrlMemoryOperation;
import php.runtime.memory.support.operation.VoidMemoryOperation;
import php.runtime.memory.support.operation.array.ArrayMemoryOperation;
import php.runtime.memory.support.operation.array.BooleanArrayMemoryOperation;
import php.runtime.memory.support.operation.array.CharArrayMemoryOperation;
import php.runtime.memory.support.operation.array.DoubleArrayMemoryOperation;
import php.runtime.memory.support.operation.array.FloatArrayMemoryOperation;
import php.runtime.memory.support.operation.array.IntegerArrayMemoryOperation;
import php.runtime.memory.support.operation.array.LongArrayMemoryOperation;
import php.runtime.memory.support.operation.array.ShortArrayMemoryOperation;
import php.runtime.memory.support.operation.collection.HashSetMemoryOperation;
import php.runtime.memory.support.operation.collection.ListMemoryOperation;
import php.runtime.memory.support.operation.collection.SetMemoryOperation;
import php.runtime.memory.support.operation.iterator.IterableMemoryOperation;
import php.runtime.memory.support.operation.map.HashMapMemoryOperation;
import php.runtime.memory.support.operation.map.MapMemoryOperation;
import php.runtime.memory.support.operation.map.PropertiesMemoryOperation;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.support.ReflectionUtils;

public abstract class MemoryOperation<T> {
    protected static final Map<Class<?>, Class<? extends BaseWrapper>> wrappers = new HashMap();
    protected static final Map<Class<? extends BaseWrapper>, Class<?>> wrappersOut = new HashMap();
    protected static final Map<Class<?>, MemoryOperation> operations = new HashMap();
    protected static final Map<ParametrizedClass, MemoryOperation> genericOperations = new HashMap<ParametrizedClass, MemoryOperation>();

    public abstract Class<?>[] getOperationClasses();

    public final T convertNoThrow(Environment env, TraceInfo trace, Memory arg) {
        try {
            return this.convert(env, trace, arg);
        }
        catch (Throwable throwable) {
            env.forwardThrow(throwable);
            return null;
        }
    }

    public final Memory unconvertNoThow(Environment env, TraceInfo trace, T arg) {
        try {
            return this.unconvert(env, trace, arg);
        }
        catch (Throwable throwable) {
            env.forwardThrow(throwable);
            return Memory.NULL;
        }
    }

    public abstract T convert(Environment var1, TraceInfo var2, Memory var3) throws Throwable;

    public abstract Memory unconvert(Environment var1, TraceInfo var2, T var3) throws Throwable;

    public void releaseConverted(Environment env, TraceInfo info, T arg) {
    }

    public Type[] getGenericTypes() {
        return null;
    }

    public void applyTypeHinting(ParameterEntity parameter) {
    }

    protected MemoryOperation<T> instance(Type ... genericTypes) {
        return this;
    }

    public static <T> Class<? extends BaseWrapper> getWrapper(Class<T> clazz) {
        return wrappers.get(clazz);
    }

    public static <T> Class<T> getClassOfWrapper(Class<? extends BaseWrapper<T>> clazz) {
        return wrappersOut.get(clazz);
    }

    public static MemoryOperation get(Class<?> type, Type genericTypes) {
        return MemoryOperation.get(type, genericTypes, false);
    }

    public static MemoryOperation get(final Class<?> type, Type genericTypes, boolean includeParents) {
        MemoryOperation operation = null;
        if (genericTypes instanceof ParameterizedType) {
            operation = genericOperations.get(new ParametrizedClass(type, ((ParameterizedType)genericTypes).getActualTypeArguments()));
        }
        if (operation == null && (operation = operations.get(type)) == null) {
            if (type.isArray()) {
                ArrayMemoryOperation arrayMemoryOperation = new ArrayMemoryOperation(type);
                MemoryOperation.register(arrayMemoryOperation);
                return arrayMemoryOperation;
            }
            if (Enum.class.isAssignableFrom(type)) {
                return new MemoryOperation(){

                    @Override
                    public Class<?>[] getOperationClasses() {
                        return new Class[]{Enum.class};
                    }

                    public Object convert(Environment env, TraceInfo trace, Memory arg) throws Throwable {
                        return arg.isNull() ? null : Enum.valueOf(type, arg.toString());
                    }

                    public Memory unconvert(Environment env, TraceInfo trace, Object arg) throws Throwable {
                        return arg == null ? Memory.NULL : StringMemory.valueOf(((Enum)arg).name());
                    }

                    @Override
                    public void applyTypeHinting(ParameterEntity parameter) {
                        parameter.setTypeEnum(type);
                    }
                };
            }
            final Class<? extends BaseWrapper> wrapperClass = wrappers.get(type);
            if (wrapperClass != null) {
                Constructor<? extends BaseWrapper> constructor;
                try {
                    constructor = wrapperClass.getConstructor(Environment.class, type);
                }
                catch (NoSuchMethodException e) {
                    try {
                        constructor = wrapperClass.getConstructor(Environment.class, Object.class);
                    }
                    catch (NoSuchMethodException e1) {
                        throw new CriticalException(e);
                    }
                }
                final Constructor<? extends BaseWrapper> finalConstructor = constructor;
                return new MemoryOperation(){

                    @Override
                    public Class<?>[] getOperationClasses() {
                        return new Class[0];
                    }

                    public Object convert(Environment env, TraceInfo trace, Memory arg) throws Throwable {
                        if (arg.isNull()) {
                            return null;
                        }
                        return arg.toObject(BaseWrapper.class).getWrappedObject();
                    }

                    public Memory unconvert(Environment env, TraceInfo trace, Object arg) throws Throwable {
                        if (arg == null) {
                            return Memory.NULL;
                        }
                        Constructor constructorContext = finalConstructor;
                        Class wrapperClassContext = wrapperClass;
                        if (arg.getClass() != type) {
                            wrapperClassContext = (Class)wrappers.get(arg.getClass());
                        }
                        if (wrapperClassContext != null && wrapperClassContext != wrapperClass) {
                            constructorContext = wrapperClassContext.getConstructor(Environment.class, arg.getClass());
                        }
                        try {
                            BaseWrapper instance = (BaseWrapper)constructorContext.newInstance(env, arg);
                            return ObjectMemory.valueOf(instance.__getOriginInstance());
                        }
                        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                            throw new CriticalException(e);
                        }
                    }

                    @Override
                    public void applyTypeHinting(ParameterEntity parameter) {
                        parameter.setTypeNativeClass(type);
                    }
                };
            }
            if (IObject.class.isAssignableFrom(type)) {
                return new MemoryOperation(){

                    @Override
                    public Class<?>[] getOperationClasses() {
                        return new Class[]{IObject.class};
                    }

                    public Object convert(Environment env, TraceInfo trace, Memory arg) throws Throwable {
                        if (arg.isNull()) {
                            return null;
                        }
                        return arg.toObject(type);
                    }

                    public Memory unconvert(Environment env, TraceInfo trace, Object arg) throws Throwable {
                        if (arg == null) {
                            return Memory.NULL;
                        }
                        return ObjectMemory.valueOf((IObject)arg);
                    }

                    @Override
                    public void applyTypeHinting(ParameterEntity parameter) {
                        parameter.setType(ReflectionUtils.getClassName(type));
                    }
                };
            }
            Class<?> superType = type.getSuperclass();
            if (Object.class != superType && (includeParents || type.isAnonymousClass())) {
                return MemoryOperation.get(superType, type.getGenericSuperclass(), includeParents);
            }
        }
        if (operation == null) {
            return null;
        }
        if (genericTypes instanceof ParameterizedType) {
            return operation.instance(((ParameterizedType)genericTypes).getActualTypeArguments());
        }
        return operation;
    }

    public static void register(MemoryOperation operation) {
        if (operation.getGenericTypes() != null) {
            for (Class<?> type : operation.getOperationClasses()) {
                genericOperations.put(new ParametrizedClass(type, operation.getGenericTypes()), operation);
            }
        } else {
            for (Class<?> type : operation.getOperationClasses()) {
                operations.put(type, operation);
            }
        }
    }

    public static <T> void registerWrapper(Class<T> clazz, Class<? extends BaseWrapper> wrapperClass) {
        wrappers.put(clazz, wrapperClass);
        wrappersOut.put(wrapperClass, clazz);
    }

    static {
        MemoryOperation.register(new ObjectMemoryOperation());
        MemoryOperation.register(new VoidMemoryOperation());
        MemoryOperation.register(new MemoryMemoryOperation());
        MemoryOperation.register(new ArrayMemoryMemoryOperation());
        MemoryOperation.register(new BooleanMemoryOperation());
        MemoryOperation.register(new LongMemoryOperation());
        MemoryOperation.register(new IntegerMemoryOperation());
        MemoryOperation.register(new ShortMemoryOperation());
        MemoryOperation.register(new ByteMemoryOperation());
        MemoryOperation.register(new DoubleMemoryOperation());
        MemoryOperation.register(new FloatMemoryOperation());
        MemoryOperation.register(new StringMemoryOperation());
        MemoryOperation.register(new CharSequenceMemoryOperation());
        MemoryOperation.register(new CharacterMemoryOperation());
        MemoryOperation.register(new InvokerMemoryOperation());
        MemoryOperation.register(new ForeachIteratorMemoryOperation());
        MemoryOperation.register(new InputStreamMemoryOperation());
        MemoryOperation.register(new OutputStreamMemoryOperation());
        MemoryOperation.register(new FileMemoryOperation());
        MemoryOperation.register(new ByteArrayInputStreamMemoryOperation());
        MemoryOperation.register(new PatternMemoryOperation());
        MemoryOperation.register(new IterableMemoryOperation(new Type[0]));
        MemoryOperation.register(new ListMemoryOperation(new Type[0]));
        MemoryOperation.register(new SetMemoryOperation(new Type[0]));
        MemoryOperation.register(new HashSetMemoryOperation());
        MemoryOperation.register(new MapMemoryOperation(new Type[0]));
        MemoryOperation.register(new HashMapMemoryOperation(new Type[0]));
        MemoryOperation.register(new PropertiesMemoryOperation());
        MemoryOperation.register(new UrlMemoryOperation());
        MemoryOperation.register(new UriMemoryOperation());
        MemoryOperation.register(new BinaryMemoryOperation());
        MemoryOperation.register(new NumberMemoryOperation());
        MemoryOperation.register(new BigDecimalOperation());
        MemoryOperation.register(new BigIntegerOperation());
        MemoryOperation.register(new ClassMemoryOperation());
        MemoryOperation.register(new LocaleMemoryOperation());
        MemoryOperation.register(new DateMemoryOperation());
        MemoryOperation.register(new TimeZoneMemoryOperation());
        MemoryOperation.register(new ScannerMemoryOperation());
        MemoryOperation.register(new ThreadMemoryOperation());
        MemoryOperation.register(new ThreadGroupMemoryOperation());
        MemoryOperation.register(new FloatArrayMemoryOperation());
        MemoryOperation.register(new DoubleArrayMemoryOperation());
        MemoryOperation.register(new LongArrayMemoryOperation());
        MemoryOperation.register(new IntegerArrayMemoryOperation());
        MemoryOperation.register(new ShortArrayMemoryOperation());
        MemoryOperation.register(new BooleanArrayMemoryOperation());
        MemoryOperation.register(new CharArrayMemoryOperation());
    }

    public static class ParametrizedClass<T> {
        protected Class<T> clazz;
        protected Type[] genericTypes;

        public ParametrizedClass(Class<T> clazz, Type[] genericTypes) {
            this.clazz = clazz;
            this.genericTypes = genericTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParametrizedClass)) {
                return false;
            }
            ParametrizedClass that = (ParametrizedClass)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            return Arrays.equals(this.genericTypes, that.genericTypes);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + Arrays.hashCode(this.genericTypes);
            return result;
        }
    }
}

