/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.CharMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringBuilderMemory;
import php.runtime.memory.StringMemory;

public class ReferenceMemory
extends Memory {
    public Memory value;

    protected ReferenceMemory(Memory.Type type, Memory value) {
        super(type);
        this.value = value;
    }

    public ReferenceMemory(Memory value) {
        super(Memory.Type.REFERENCE);
        this.value = value == null ? Memory.NULL : value;
    }

    public static Memory valueOf(Memory value) {
        return new ReferenceMemory(value);
    }

    public ReferenceMemory() {
        super(Memory.Type.REFERENCE);
        this.value = Memory.NULL;
    }

    public ReferenceMemory duplicate() {
        return new ReferenceMemory(this.value.toImmutable());
    }

    @Override
    public int getPointer() {
        return this.value.getPointer();
    }

    @Override
    public int getPointer(boolean absolute) {
        return absolute ? this.value.getPointer() : this.getPointer();
    }

    @Override
    public long toLong() {
        return this.value.toLong();
    }

    @Override
    public double toDouble() {
        return this.value.toDouble();
    }

    @Override
    public boolean toBoolean() {
        return this.value.toBoolean();
    }

    @Override
    public Memory toNumeric() {
        return this.value.toNumeric();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public char toChar() {
        return this.value.toChar();
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public boolean isObject() {
        return this.value.isObject();
    }

    @Override
    public boolean isResource() {
        return this.value.isResource();
    }

    @Override
    public boolean isArray() {
        return this.value.isArray();
    }

    @Override
    public boolean isString() {
        return this.value.isString();
    }

    @Override
    public boolean isNumber() {
        return this.value.isNumber();
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public Memory inc() {
        return this.value.inc();
    }

    @Override
    public Memory dec() {
        return this.value.dec();
    }

    @Override
    public Memory negative() {
        return this.value.negative();
    }

    @Override
    public Memory plus(Memory memory) {
        return this.value.plus(memory);
    }

    @Override
    public Memory plus(long value) {
        return this.value.plus(value);
    }

    @Override
    public Memory plus(double value) {
        return this.value.plus(value);
    }

    @Override
    public Memory plus(boolean value) {
        return this.value.plus(value);
    }

    @Override
    public Memory plus(String value) {
        return this.value.plus(value);
    }

    @Override
    public Memory minus(Memory memory) {
        return this.value.minus(memory);
    }

    @Override
    public Memory minus(double value) {
        return this.value.minus(value);
    }

    @Override
    public Memory minus(boolean value) {
        return this.value.minus(value);
    }

    @Override
    public Memory minus(String value) {
        return this.value.minus(value);
    }

    @Override
    public Memory minus(long value) {
        return this.value.minus(value);
    }

    @Override
    public Memory mul(Memory memory) {
        return this.value.mul(memory);
    }

    @Override
    public Memory mul(long value) {
        return this.value.mul(value);
    }

    @Override
    public Memory mul(double value) {
        return this.value.mul(value);
    }

    @Override
    public Memory mul(boolean value) {
        return this.value.mul(value);
    }

    @Override
    public Memory mul(String value) {
        return this.value.mul(value);
    }

    @Override
    public Memory pow(Memory memory) {
        return this.value.pow(memory);
    }

    @Override
    public Memory pow(long value) {
        return this.value.pow(value);
    }

    @Override
    public Memory pow(double value) {
        return this.value.pow(value);
    }

    @Override
    public Memory pow(boolean value) {
        return this.value.pow(value);
    }

    @Override
    public Memory pow(String value) {
        return this.value.pow(value);
    }

    @Override
    public Memory div(Memory memory) {
        return this.value.div(memory);
    }

    @Override
    public Memory div(long value) {
        return this.value.div(value);
    }

    @Override
    public Memory div(double value) {
        return this.value.div(value);
    }

    @Override
    public Memory div(boolean value) {
        return this.value.div(value);
    }

    @Override
    public Memory div(String value) {
        return this.value.div(value);
    }

    @Override
    public Memory mod(long value) {
        return this.value.mod(value);
    }

    @Override
    public Memory mod(double value) {
        return this.value.mod(value);
    }

    @Override
    public Memory mod(boolean value) {
        return this.value.mod(value);
    }

    @Override
    public Memory mod(String value) {
        return this.value.mod(value);
    }

    @Override
    public boolean equal(Memory memory) {
        return this.value.equal(memory);
    }

    @Override
    public boolean equal(long value) {
        return this.value.equal(value);
    }

    @Override
    public boolean equal(double value) {
        return this.value.equal(value);
    }

    @Override
    public boolean equal(boolean value) {
        return this.value.equal(value);
    }

    @Override
    public boolean equal(String value) {
        return this.value.equal(value);
    }

    @Override
    public boolean notEqual(Memory memory) {
        return this.value.notEqual(memory);
    }

    @Override
    public boolean notEqual(long value) {
        return this.value.notEqual(value);
    }

    @Override
    public boolean notEqual(double value) {
        return this.value.notEqual(value);
    }

    @Override
    public boolean notEqual(boolean value) {
        return this.value.notEqual(value);
    }

    @Override
    public boolean notEqual(String value) {
        return this.value.notEqual(value);
    }

    @Override
    public String concat(Memory memory) {
        return this.value.concat(memory);
    }

    @Override
    public String concat(long value) {
        return this.value.concat(value);
    }

    @Override
    public String concat(double value) {
        return this.value.concat(value);
    }

    @Override
    public String concat(boolean value) {
        return this.value.concat(value);
    }

    @Override
    public String concat(String value) {
        return this.value.concat(value);
    }

    @Override
    public boolean smaller(Memory memory) {
        return this.value.smaller(memory);
    }

    @Override
    public boolean smaller(long value) {
        return this.value.smaller(value);
    }

    @Override
    public boolean smaller(double value) {
        return this.value.smaller(value);
    }

    @Override
    public boolean smaller(boolean value) {
        return this.value.smaller(value);
    }

    @Override
    public boolean smaller(String value) {
        return this.value.smaller(value);
    }

    @Override
    public boolean smallerEq(Memory memory) {
        return this.value.smallerEq(memory);
    }

    @Override
    public boolean smallerEq(long value) {
        return this.value.smallerEq(value);
    }

    @Override
    public boolean smallerEq(double value) {
        return this.value.smallerEq(value);
    }

    @Override
    public boolean smallerEq(boolean value) {
        return this.value.smallerEq(value);
    }

    @Override
    public boolean smallerEq(String value) {
        return this.value.smallerEq(value);
    }

    @Override
    public boolean greater(Memory memory) {
        return this.value.greater(memory);
    }

    @Override
    public boolean greater(long value) {
        return this.value.greater(value);
    }

    @Override
    public boolean greater(double value) {
        return this.value.greater(value);
    }

    @Override
    public boolean greater(boolean value) {
        return this.value.greater(value);
    }

    @Override
    public boolean greater(String value) {
        return this.value.greater(value);
    }

    @Override
    public boolean greaterEq(Memory memory) {
        return this.value.greaterEq(memory);
    }

    @Override
    public boolean greaterEq(long value) {
        return this.value.greaterEq(value);
    }

    @Override
    public boolean greaterEq(double value) {
        return this.value.greaterEq(value);
    }

    @Override
    public boolean greaterEq(boolean value) {
        return this.value.greaterEq(value);
    }

    @Override
    public boolean greaterEq(String value) {
        return this.value.greaterEq(value);
    }

    @Override
    public Memory bitAnd(Memory memory) {
        return this.value.bitAnd(memory);
    }

    @Override
    public Memory bitAnd(long memory) {
        return this.value.bitAnd(memory);
    }

    @Override
    public Memory bitAnd(double memory) {
        return this.value.bitAnd(memory);
    }

    @Override
    public Memory bitAnd(boolean memory) {
        return this.value.bitAnd(memory);
    }

    @Override
    public Memory bitAnd(String memory) {
        return this.value.bitAnd(memory);
    }

    @Override
    public Memory bitOr(Memory memory) {
        return this.value.bitOr(memory);
    }

    @Override
    public Memory bitOr(long memory) {
        return this.value.bitOr(memory);
    }

    @Override
    public Memory bitOr(double memory) {
        return this.value.bitOr(memory);
    }

    @Override
    public Memory bitOr(boolean memory) {
        return this.value.bitOr(memory);
    }

    @Override
    public Memory bitOr(String memory) {
        return this.value.bitOr(memory);
    }

    @Override
    public Memory bitXor(Memory memory) {
        return this.value.bitXor(memory);
    }

    @Override
    public Memory bitXor(long memory) {
        return this.value.bitXor(memory);
    }

    @Override
    public Memory bitXor(double memory) {
        return this.value.bitXor(memory);
    }

    @Override
    public Memory bitXor(boolean memory) {
        return this.value.bitXor(memory);
    }

    @Override
    public Memory bitXor(String memory) {
        return this.value.bitXor(memory);
    }

    @Override
    public Memory bitNot() {
        return this.value.bitNot();
    }

    @Override
    public Memory bitShr(Memory memory) {
        return this.value.bitShr(memory);
    }

    @Override
    public Memory bitShr(long memory) {
        return this.value.bitShr(memory);
    }

    @Override
    public Memory bitShr(double memory) {
        return this.value.bitShr(memory);
    }

    @Override
    public Memory bitShr(boolean memory) {
        return this.value.bitShr(memory);
    }

    @Override
    public Memory bitShr(String memory) {
        return this.value.bitShr(memory);
    }

    @Override
    public Memory bitShl(Memory memory) {
        return this.value.bitShl(memory);
    }

    @Override
    public Memory bitShl(long memory) {
        return this.value.bitShl(memory);
    }

    @Override
    public Memory bitShl(double memory) {
        return this.value.bitShl(memory);
    }

    @Override
    public Memory bitShl(boolean memory) {
        return this.value.bitShl(memory);
    }

    @Override
    public Memory bitShl(String memory) {
        return this.value.bitShl(memory);
    }

    @Override
    public Memory newKeyValue(Memory memory) {
        return this.value.newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(long memory) {
        return this.value.newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(double memory) {
        return this.value.newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(boolean memory) {
        return this.value.newKeyValue(memory);
    }

    @Override
    public Memory newKeyValue(String memory) {
        return this.value.newKeyValue(memory);
    }

    @Override
    public Memory toImmutable() {
        switch (this.value.type) {
            case NULL: 
            case REFERENCE: 
            case ARRAY: {
                return this.value.toImmutable();
            }
        }
        return this.value;
    }

    @Override
    public <T extends Memory> T toValue(Class<T> clazz) {
        switch (this.value.type) {
            case REFERENCE: {
                return this.value.toValue(clazz);
            }
        }
        return (T)this.value;
    }

    @Override
    public Memory toValue() {
        switch (this.value.type) {
            case REFERENCE: {
                return this.value.toValue();
            }
        }
        return this.value;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Memory assign(Memory memory) {
        switch (this.value.type) {
            case REFERENCE: {
                return this.value.assign(memory);
            }
            case ARRAY: {
                this.value.unset();
            }
        }
        this.value = memory;
        return this.value;
    }

    public ReferenceMemory getReference() {
        if (this.value.type == Memory.Type.REFERENCE) {
            return ((ReferenceMemory)this.value).getReference();
        }
        return this;
    }

    @Override
    public Memory assignRef(Memory reference) {
        if (reference.isReference()) {
            reference = ((ReferenceMemory)reference).getReference();
        }
        this.value = reference;
        return reference;
    }

    @Override
    public Memory assign(long memory) {
        switch (this.value.type) {
            case REFERENCE: {
                return this.value.assign(memory);
            }
            case ARRAY: {
                this.value.unset();
            }
        }
        this.value = LongMemory.valueOf(memory);
        return this.value;
    }

    @Override
    public Memory assign(String memory) {
        switch (this.value.type) {
            case REFERENCE: {
                return this.value.assign(memory);
            }
            case ARRAY: {
                this.value.unset();
            }
        }
        this.value = StringMemory.valueOf(memory);
        return this.value;
    }

    @Override
    public Memory assign(boolean memory) {
        switch (this.value.type) {
            case REFERENCE: {
                return this.value.assign(memory);
            }
            case ARRAY: {
                this.value.unset();
            }
        }
        this.value = memory ? TRUE : FALSE;
        return this.value;
    }

    @Override
    public Memory assign(double memory) {
        switch (this.value.type) {
            case REFERENCE: {
                return this.value.assign(memory);
            }
            case ARRAY: {
                this.value.unset();
            }
        }
        this.value = new DoubleMemory(memory);
        return this.value;
    }

    private StringMemory typeString() {
        if (this.toValue().type != Memory.Type.STRING) {
            this.assign(new StringMemory(this.value.toString()));
        }
        return (StringMemory)this.toImmutable();
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return this.value.getBinaryBytes(charset);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public void unset() {
        this.value = UNDEFINED;
    }

    @Override
    public void manualUnset(Environment env) {
        if (this.value.isObject()) {
            this.value.manualUnset(env);
        }
        this.unset();
    }

    public void needArray() {
        Memory.Type type = this.getRealType();
        if (type != Memory.Type.STRING && type != Memory.Type.ARRAY && type != Memory.Type.OBJECT) {
            this.assign(new ArrayMemory());
        }
    }

    public StringBuilderMemory needStringBuilder() {
        Memory value = this.toValue();
        if (value instanceof StringBuilderMemory) {
            return (StringBuilderMemory)value;
        }
        StringBuilderMemory builderMemory = new StringBuilderMemory(value.toString());
        this.assign(builderMemory);
        return builderMemory;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        return this.value.valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        return this.value.valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        return this.value.valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        return this.value.valueOfIndex(trace, index);
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        return this.value.valueOfIndex(trace, index);
    }

    @Override
    public Memory refOfPush(TraceInfo trace) {
        this.needArray();
        return this.value.refOfPush(trace);
    }

    @Override
    public Memory refOfIndexAsShortcut(TraceInfo trace, Memory index) {
        this.needArray();
        switch (this.value.type) {
            case STRING: {
                return this.refOfIndex(trace, index);
            }
        }
        return this.value.refOfIndexAsShortcut(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, Memory index) {
        this.needArray();
        switch (this.value.type) {
            case STRING: {
                if (index.isString()) {
                    int _index = -1;
                    Memory tmp = StringMemory.toLong(index.toString());
                    if (tmp != null) {
                        _index = tmp.toInteger();
                    }
                    return CharMemory.valueOf(this, (StringMemory)this.value, _index);
                }
                return CharMemory.valueOf(this, (StringMemory)this.value, (int)index.toNumeric().toLong());
            }
        }
        return this.value.refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, long index) {
        this.needArray();
        switch (this.value.type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.value, (int)index);
            }
        }
        return this.value.refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, double index) {
        this.needArray();
        switch (this.value.type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.value, (int)index);
            }
        }
        return this.value.refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, String index) {
        this.needArray();
        int _index = -1;
        Memory tmp = StringMemory.toLong(index);
        if (tmp != null) {
            _index = tmp.toInteger();
        }
        switch (this.value.type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.value, _index);
            }
        }
        return this.value.refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, boolean index) {
        this.needArray();
        switch (this.value.type) {
            case STRING: {
                return CharMemory.valueOf(this, (StringMemory)this.value, index ? 1 : 0);
            }
        }
        return this.value.refOfIndex(trace, index);
    }

    @Override
    public void unsetOfIndex(TraceInfo trace, Memory index) {
        this.value.unsetOfIndex(trace, index);
    }

    @Override
    public Memory issetOfIndex(TraceInfo trace, Memory index) {
        return this.value.issetOfIndex(trace, index);
    }

    @Override
    public Memory emptyOfIndex(TraceInfo trace, Memory index) {
        return this.value.emptyOfIndex(trace, index);
    }

    @Override
    public boolean isShortcut() {
        return this.value.isReference();
    }

    @Override
    public boolean identical(Memory memory) {
        return this.value.identical(memory);
    }

    @Override
    public boolean identical(long value) {
        return this.value.identical(value);
    }

    @Override
    public boolean identical(double value) {
        return this.value.identical(value);
    }

    @Override
    public boolean identical(boolean value) {
        return this.value.identical(value);
    }

    @Override
    public boolean identical(String value) {
        return this.value.identical(value);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return this.value.getNewIterator(env, getReferences, getKeyReferences);
    }

    @Override
    public Memory.Type getRealType() {
        if (this.value.type == Memory.Type.REFERENCE) {
            return this.value.getRealType();
        }
        return this.value.type;
    }

    @Override
    public Memory assignConcat(Memory memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(long memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(double memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(boolean memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public Memory assignConcat(String memory) {
        this.needStringBuilder().append(memory);
        return this;
    }

    @Override
    public boolean instanceOf(String className, String lowerClassName) {
        return this.value.instanceOf(className, lowerClassName);
    }

    @Override
    public boolean instanceOf(String name) {
        return this.value.instanceOf(name);
    }

    @Override
    public Memory toArray() {
        return this.value.toArray();
    }

    @Override
    public Memory toObject(Environment env) {
        return this.value.toObject(env);
    }

    @Override
    public Memory clone(Environment env, TraceInfo trace) throws Throwable {
        return this.value.clone(env, trace);
    }

    @Override
    public boolean isClosure() {
        return this.value.isClosure();
    }

    @Override
    public String toBinaryString() {
        return this.value.toBinaryString();
    }

    @Override
    public boolean instanceOf(Class<? extends IObject> clazz) {
        return this.value.instanceOf(clazz);
    }

    @Override
    public <T extends IObject> T toObject(Class<T> clazz) {
        return this.value.toObject(clazz);
    }

    @Override
    public int compareTo(Memory o) {
        return this.value.compareTo(o);
    }
}

