/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.common.Modifier;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.lang.Closure;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.Generator;
import php.runtime.lang.IObject;
import php.runtime.lang.Resource;
import php.runtime.lang.spl.ArrayAccess;
import php.runtime.lang.spl.Traversable;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.lang.spl.iterator.IteratorAggregate;
import php.runtime.lang.support.ICloneableObject;
import php.runtime.lang.support.IComparableObject;
import php.runtime.lang.support.IManualDestructable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.PropertyEntity;

public class ObjectMemory
extends Memory {
    public IObject value;

    public ObjectMemory() {
        super(Memory.Type.OBJECT);
    }

    public ObjectMemory(IObject object) {
        this();
        this.value = object;
    }

    public static Memory valueOf(IObject object) {
        if (object == null) {
            return NULL;
        }
        return new ObjectMemory(object);
    }

    public ClassEntity getReflection() {
        return this.value.getReflection();
    }

    public ArrayMemory getProperties() {
        return this.value.getProperties();
    }

    @Override
    public int getPointer(boolean absolute) {
        return this.value.getPointer();
    }

    @Override
    public int getPointer() {
        return this.value.getPointer();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isResource() {
        return this.value instanceof Resource;
    }

    @Override
    public long toLong() {
        return 0L;
    }

    @Override
    public double toDouble() {
        return 0.0;
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public Memory toNumeric() {
        return CONST_INT_0;
    }

    @Override
    public String toString() {
        ClassEntity entity = this.value.getReflection();
        if (entity.methodMagicToString != null) {
            Environment env = this.value.getEnvironment();
            if (env == null) {
                return "Object";
            }
            env.pushCall(entity.methodMagicToString.getTrace(), this.value, null, entity.methodMagicToString.getName(), entity.getName(), null);
            try {
                Memory result = entity.methodMagicToString.invokeDynamic(this.value, env, null);
                if (!result.isString()) {
                    env.error(ErrorType.E_RECOVERABLE_ERROR, "Method %s must return a string value", entity.methodMagicToString.getSignatureString(false));
                    String string = "";
                    return string;
                }
                String string = result.toString();
                return string;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                env.popCall();
            }
        }
        return "Object";
    }

    @Override
    public Memory inc() {
        return CONST_INT_1;
    }

    @Override
    public Memory dec() {
        return CONST_INT_M1;
    }

    @Override
    public Memory negative() {
        return CONST_INT_0;
    }

    @Override
    public Memory plus(Memory memory) {
        return this.toNumeric().plus(memory);
    }

    @Override
    public Memory minus(Memory memory) {
        return this.toNumeric().minus(memory);
    }

    @Override
    public Memory mul(Memory memory) {
        return this.toNumeric().mul(memory);
    }

    @Override
    public Memory pow(Memory memory) {
        return this.toNumeric().pow(memory);
    }

    @Override
    public Memory div(Memory memory) {
        return this.toNumeric().div(memory);
    }

    private boolean compare(Memory other, Comparator comparator) {
        switch (other.type) {
            case OBJECT: {
                ClassEntity otherReflection = ((ObjectMemory)other).getReflection();
                if (otherReflection.getId() != this.getReflection().getId()) {
                    return false;
                }
                IObject otherObject = ((ObjectMemory)other).value;
                return comparator.compare(this.value, otherObject);
            }
            case REFERENCE: {
                return this.compare(other.toValue(), comparator);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(IObject other, boolean strict, Set<Integer> used) {
        ClassEntity otherReflection = other.getReflection();
        if (otherReflection.getId() != this.getReflection().getId()) {
            return -2;
        }
        if (used == null) {
            used = new HashSet<Integer>();
        }
        try {
            if (used.add(other.getPointer())) {
                int n = this.value.getProperties().compare(other.getProperties(), strict, used);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            used.remove(other.getPointer());
        }
    }

    @Override
    public boolean equal(Memory memory) {
        return this.compare(memory, new Comparator(){

            @Override
            public boolean compare(IObject o1, IObject o2) {
                if (o1 instanceof IComparableObject) {
                    return ((IComparableObject)((Object)o1)).__equal(o2);
                }
                return o1.getProperties().equal(o2.getProperties());
            }
        });
    }

    @Override
    public boolean notEqual(Memory memory) {
        return !this.equal(memory);
    }

    @Override
    public boolean smaller(Memory memory) {
        return this.compare(memory, new Comparator(){

            @Override
            public boolean compare(IObject o1, IObject o2) {
                if (o1 instanceof IComparableObject) {
                    return ((IComparableObject)((Object)o1)).__smaller(o2);
                }
                return o1.getProperties().smaller(o2.getProperties());
            }
        });
    }

    @Override
    public boolean smallerEq(Memory memory) {
        return this.compare(memory, new Comparator(){

            @Override
            public boolean compare(IObject o1, IObject o2) {
                if (o1 instanceof IComparableObject) {
                    return ((IComparableObject)((Object)o1)).__smallerEq(o2);
                }
                return o1.getProperties().smallerEq(o2.getProperties());
            }
        });
    }

    @Override
    public boolean greater(Memory memory) {
        return this.compare(memory, new Comparator(){

            @Override
            public boolean compare(IObject o1, IObject o2) {
                if (o1 instanceof IComparableObject) {
                    return ((IComparableObject)((Object)o1)).__greater(o2);
                }
                return o1.getProperties().greater(o2.getProperties());
            }
        });
    }

    @Override
    public boolean greaterEq(Memory memory) {
        return this.compare(memory, new Comparator(){

            @Override
            public boolean compare(IObject o1, IObject o2) {
                if (o1 instanceof IComparableObject) {
                    return ((IComparableObject)((Object)o1)).__greaterEq(o2);
                }
                return o1.getProperties().greaterEq(o2.getProperties());
            }
        });
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return this.toString().getBytes(charset);
    }

    @Override
    public boolean identical(Memory memory) {
        return this.compare(memory, new Comparator(){

            @Override
            public boolean compare(IObject o1, IObject o2) {
                if (o1 instanceof IComparableObject) {
                    return ((IComparableObject)((Object)o1)).__identical(o2);
                }
                return o1.getPointer() == o2.getPointer();
            }
        });
    }

    @Override
    public boolean identical(long value) {
        return false;
    }

    @Override
    public boolean identical(double value) {
        return false;
    }

    @Override
    public boolean identical(boolean value) {
        return false;
    }

    @Override
    public boolean identical(String value) {
        return false;
    }

    @Override
    public ForeachIterator getNewIterator(final Environment env, boolean getReferences, boolean getKeyReferences) {
        if (this.value instanceof IteratorAggregate) {
            return env.invokeMethodNoThrow(this.value, "getIterator", new Memory[0]).getNewIterator(env, getReferences, getKeyReferences);
        }
        if (this.value instanceof Iterator) {
            final Iterator iterator = (Iterator)this.value;
            final String className = this.value.getReflection().getName();
            final boolean isNative = this.value.getReflection().isInternal();
            return new ForeachIterator(getReferences, getKeyReferences, false){
                private boolean keyInit;
                private boolean needNext;
                private boolean rewind;
                {
                    super(getReferences, getKeyReferences, withPrevious);
                    this.keyInit = false;
                    this.needNext = false;
                    this.rewind = false;
                }

                @Override
                public void reset() {
                    this.rewind();
                }

                @Override
                protected boolean init() {
                    return this.rewind();
                }

                protected boolean rewind() {
                    if (this.getReferences && ObjectMemory.this.value instanceof Generator && !((Generator)ObjectMemory.this.value).isReturnReferences()) {
                        env.exception(this.trace, "You can only iterate a generator by-reference if it declared that it yields by-reference", new Object[0]);
                    }
                    if (!this.rewind) {
                        if (!isNative) {
                            env.pushCall(this.trace, ObjectMemory.this.value, null, "rewind", className, null);
                        }
                        try {
                            boolean bl = iterator.rewind(env, new Memory[0]).toValue() != Memory.FALSE;
                            return bl;
                        }
                        finally {
                            this.rewind = true;
                            if (!isNative) {
                                env.popCall();
                            }
                        }
                    }
                    return true;
                }

                @Override
                protected boolean prevValue() {
                    return false;
                }

                @Override
                protected boolean nextValue() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean next() {
                    boolean valid;
                    block20: {
                        if (!this.rewind()) {
                            return false;
                        }
                        valid = false;
                        this.keyInit = false;
                        if (this.needNext) {
                            if (!isNative) {
                                env.pushCall(this.trace, ObjectMemory.this.value, null, "next", className, null);
                            }
                            try {
                                iterator.next(env, new Memory[0]);
                            }
                            finally {
                                if (!isNative) {
                                    env.popCall();
                                }
                            }
                        }
                        this.needNext = true;
                        if (!isNative) {
                            env.pushCall(this.trace, ObjectMemory.this.value, null, "valid", className, null);
                        }
                        try {
                            valid = iterator.valid(env, new Memory[0]).toBoolean();
                            if (valid) {
                                if (!isNative) {
                                    env.pushCall(this.trace, ObjectMemory.this.value, null, "current", className, null);
                                }
                                try {
                                    this.currentValue = iterator.current(env, new Memory[0]);
                                    if (!this.getReferences) {
                                        this.currentValue = this.currentValue.toImmutable();
                                    }
                                    break block20;
                                }
                                finally {
                                    if (!isNative) {
                                        env.popCall();
                                    }
                                }
                            }
                            this.rewind = false;
                        }
                        finally {
                            if (!isNative) {
                                env.popCall();
                            }
                        }
                    }
                    return valid;
                }

                @Override
                public Object getKey() {
                    return this.getMemoryKey();
                }

                @Override
                public Memory getMemoryKey() {
                    if (this.keyInit) {
                        return (Memory)this.currentKey;
                    }
                    if (!isNative) {
                        env.pushCall(this.trace, ObjectMemory.this.value, null, "key", className, null);
                    }
                    try {
                        this.currentKey = iterator.key(env, new Memory[0]).toImmutable();
                        this.keyInit = true;
                        Memory memory = (Memory)this.currentKey;
                        return memory;
                    }
                    finally {
                        if (!isNative) {
                            env.popCall();
                        }
                    }
                }
            };
        }
        if (this.value instanceof Traversable) {
            return ((Traversable)this.value).getNewIterator(env, getReferences, getKeyReferences);
        }
        return new ForeachIterator(getReferences, getKeyReferences, false){
            private ForeachIterator child;
            private ClassEntity reflection;
            private ClassEntity context;

            @Override
            protected boolean init() {
                this.context = env.getLastClassOnStack();
                this.reflection = ObjectMemory.this.value.getReflection();
                this.child = ObjectMemory.this.value.getProperties().foreachIterator(this.getReferences, this.getKeyReferences);
                return true;
            }

            @Override
            public void reset() {
                this.child.reset();
            }

            @Override
            protected boolean nextValue() {
                block2: {
                    String keyS;
                    PropertyEntity entity;
                    int accessFlag;
                    do {
                        if (!this.child.next()) {
                            return false;
                        }
                        Object key = this.child.getKey();
                        if (!(key instanceof String)) break block2;
                        keyS = (String)key;
                        int pos = keyS.lastIndexOf(0);
                        if (pos <= -1) continue;
                        keyS = keyS.substring(pos + 1);
                    } while ((accessFlag = (entity = this.reflection.isInstanceOf(this.context) ? this.context.properties.get(keyS) : this.reflection.properties.get(keyS)) == null ? 0 : entity.canAccess(env)) != 0);
                    this.currentKey = entity == null ? keyS : entity.getName();
                }
                this.currentValue = this.child.getValue();
                return true;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }
        };
    }

    @Override
    public boolean instanceOf(String className, String lowerClassName) {
        ClassEntity origin = this.value.getReflection();
        if (!lowerClassName.isEmpty() && lowerClassName.charAt(0) == '\\') {
            return origin.isInstanceOf(lowerClassName.substring(1));
        }
        return origin.isInstanceOfLower(lowerClassName);
    }

    @Override
    public boolean instanceOf(String name) {
        return this.instanceOf(name, name.toLowerCase());
    }

    @Override
    public Memory toObject(Environment env) {
        return this;
    }

    @Override
    public Memory clone(Environment env, TraceInfo trace) throws Throwable {
        if (this.value instanceof ICloneableObject) {
            return new ObjectMemory((IObject)((ICloneableObject)((Object)this.value)).__clone(env, trace));
        }
        return new ObjectMemory(this.value.getReflection().cloneObject(this.value, env, trace));
    }

    @Override
    public Memory toArray() {
        ForeachIterator iterator;
        ArrayMemory result = new ArrayMemory();
        ArrayMemory props = this.value.getProperties();
        ForeachIterator foreachIterator = iterator = props == null ? null : props.foreachIterator(false, false);
        if (iterator == null) {
            return new ArrayMemory().toConstant();
        }
        ClassEntity reflection = this.value.getReflection();
        while (iterator.next()) {
            Object key = iterator.getKey();
            Memory value = iterator.getValue().toImmutable();
            if (key instanceof String) {
                String keyS = (String)key;
                PropertyEntity prop = reflection.properties.get(keyS);
                if (prop == null || prop.getModifier() == Modifier.PUBLIC) {
                    result.refOfIndex(keyS).assign(iterator.getValue().toImmutable());
                    continue;
                }
                if (prop.getModifier() == Modifier.PROTECTED) {
                    result.refOfIndex("\u0000*\u0000" + keyS).assign(value);
                    continue;
                }
                result.refOfIndex("\u0000" + prop.getClazz().getName() + "\u0000" + keyS).assign(value);
                continue;
            }
            result.refOfIndex(null, iterator.getMemoryKey()).assign(value);
        }
        return result.toConstant();
    }

    @Override
    public void manualUnset(Environment env) {
        ClassEntity entity = this.value.getReflection();
        if (entity.methodDestruct != null && !this.value.isFinalized()) {
            this.value.doFinalize();
            env.pushCall(this.value, entity.methodDestruct.getName(), new Memory[0]);
            try {
                if (this.value instanceof IManualDestructable) {
                    ((IManualDestructable)((Object)this.value)).onManualDestruct(env);
                }
                entity.methodDestruct.invokeDynamic(this.value, env, new Memory[0]);
            }
            catch (InvocationTargetException e) {
                env.__throwException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new CriticalException(throwable);
            }
            finally {
                env.popCall();
            }
        }
    }

    private void invalidUseAsArray(TraceInfo trace) {
        Environment env = this.value.getEnvironment();
        if (env != null) {
            env.error(trace == null ? this.getReflection().getTrace() : trace, ErrorType.E_ERROR, Messages.ERR_CANNOT_USE_OBJECT_AS_ARRAY, this.getReflection().getName());
        }
    }

    @Override
    public Memory refOfIndex(final TraceInfo trace, final Memory index) {
        if (this.value instanceof ArrayAccess) {
            return new ReferenceMemory(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Memory assign(Memory memory) {
                    Environment env = ObjectMemory.this.value.getEnvironment();
                    if (env != null && trace != null) {
                        ArrayAccess array = (ArrayAccess)ObjectMemory.this.value;
                        Memory[] args = new Memory[]{index, memory};
                        env.pushCall(ObjectMemory.this.value, "offsetSet", args);
                        try {
                            array.offsetSet(env, args);
                        }
                        finally {
                            env.popCall();
                        }
                    } else {
                        ObjectMemory.this.invalidUseAsArray(trace);
                    }
                    return memory;
                }

                @Override
                public Memory assignRef(Memory reference) {
                    return this.assign(reference);
                }

                @Override
                public Memory assign(long memory) {
                    return this.assign(LongMemory.valueOf(memory));
                }

                @Override
                public Memory assign(String memory) {
                    return this.assign(StringMemory.valueOf(memory));
                }

                @Override
                public Memory assign(boolean memory) {
                    return this.assign(TrueMemory.valueOf(memory));
                }

                @Override
                public Memory assign(double memory) {
                    return this.assign(DoubleMemory.valueOf(memory));
                }

                @Override
                public Memory assignConcat(Memory memory) {
                    return this.assign(this.toValue().concat(memory));
                }

                @Override
                public Memory assignConcat(long memory) {
                    return this.assign(this.toValue().concat(memory));
                }

                @Override
                public Memory assignConcat(double memory) {
                    return this.assign(this.toValue().concat(memory));
                }

                @Override
                public Memory assignConcat(boolean memory) {
                    return this.assign(this.toValue().concat(memory));
                }

                @Override
                public Memory assignConcat(String memory) {
                    return this.assign(this.toValue().concat(memory));
                }

                @Override
                public Memory assignPlus(Memory memory) {
                    this.value = this.toValue();
                    return super.assignPlus(memory);
                }

                @Override
                public Memory assignPlus(long memory) {
                    this.value = this.toValue();
                    return super.assignPlus(memory);
                }

                @Override
                public Memory assignPlus(double memory) {
                    this.value = this.toValue();
                    return super.assignPlus(memory);
                }

                @Override
                public Memory assignPlus(boolean memory) {
                    this.value = this.toValue();
                    return super.assignPlus(memory);
                }

                @Override
                public Memory assignPlus(String memory) {
                    this.value = this.toValue();
                    return super.assignPlus(memory);
                }

                @Override
                public Memory assignPlusRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignPlusRight(memory);
                }

                @Override
                public Memory assignMinus(Memory memory) {
                    this.value = this.toValue();
                    return super.assignMinus(memory);
                }

                @Override
                public Memory assignMinus(long memory) {
                    this.value = this.toValue();
                    return super.assignMinus(memory);
                }

                @Override
                public Memory assignMinus(double memory) {
                    this.value = this.toValue();
                    return super.assignMinus(memory);
                }

                @Override
                public Memory assignMinus(boolean memory) {
                    this.value = this.toValue();
                    return super.assignMinus(memory);
                }

                @Override
                public Memory assignMinus(String memory) {
                    this.value = this.toValue();
                    return super.assignMinus(memory);
                }

                @Override
                public Memory assignMinusRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignMinusRight(memory);
                }

                @Override
                public Memory assignMul(Memory memory) {
                    this.value = this.toValue();
                    return super.assignMul(memory);
                }

                @Override
                public Memory assignMul(long memory) {
                    this.value = this.toValue();
                    return super.assignMul(memory);
                }

                @Override
                public Memory assignMul(double memory) {
                    this.value = this.toValue();
                    return super.assignMul(memory);
                }

                @Override
                public Memory assignMul(boolean memory) {
                    this.value = this.toValue();
                    return super.assignMul(memory);
                }

                @Override
                public Memory assignMul(String memory) {
                    this.value = this.toValue();
                    return super.assignMul(memory);
                }

                @Override
                public Memory assignMulRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignMulRight(memory);
                }

                @Override
                public Memory assignDiv(Memory memory) {
                    this.value = this.toValue();
                    return super.assignDiv(memory);
                }

                @Override
                public Memory assignDiv(long memory) {
                    this.value = this.toValue();
                    return super.assignDiv(memory);
                }

                @Override
                public Memory assignDiv(double memory) {
                    this.value = this.toValue();
                    return super.assignDiv(memory);
                }

                @Override
                public Memory assignDiv(boolean memory) {
                    this.value = this.toValue();
                    return super.assignDiv(memory);
                }

                @Override
                public Memory assignDiv(String memory) {
                    this.value = this.toValue();
                    return super.assignDiv(memory);
                }

                @Override
                public Memory assignDivRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignDivRight(memory);
                }

                @Override
                public Memory assignMod(Memory memory) {
                    this.value = this.toValue();
                    return super.assignMod(memory);
                }

                @Override
                public Memory assignMod(long memory) {
                    this.value = this.toValue();
                    return super.assignMod(memory);
                }

                @Override
                public Memory assignMod(double memory) {
                    this.value = this.toValue();
                    return super.assignMod(memory);
                }

                @Override
                public Memory assignMod(boolean memory) {
                    this.value = this.toValue();
                    return super.assignMod(memory);
                }

                @Override
                public Memory assignMod(String memory) {
                    this.value = this.toValue();
                    return super.assignMod(memory);
                }

                @Override
                public Memory assignModRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignModRight(memory);
                }

                @Override
                public Memory assignBitShr(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitShr(memory);
                }

                @Override
                public Memory assignBitShr(long memory) {
                    this.value = this.toValue();
                    return super.assignBitShr(memory);
                }

                @Override
                public Memory assignBitShr(double memory) {
                    this.value = this.toValue();
                    return super.assignBitShr(memory);
                }

                @Override
                public Memory assignBitShr(boolean memory) {
                    this.value = this.toValue();
                    return super.assignBitShr(memory);
                }

                @Override
                public Memory assignBitShr(String memory) {
                    this.value = this.toValue();
                    return super.assignBitShr(memory);
                }

                @Override
                public Memory assignBitShrRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitShrRight(memory);
                }

                @Override
                public Memory assignBitShl(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitShl(memory);
                }

                @Override
                public Memory assignBitShl(long memory) {
                    this.value = this.toValue();
                    return super.assignBitShl(memory);
                }

                @Override
                public Memory assignBitShl(double memory) {
                    this.value = this.toValue();
                    return super.assignBitShl(memory);
                }

                @Override
                public Memory assignBitShl(boolean memory) {
                    this.value = this.toValue();
                    return super.assignBitShl(memory);
                }

                @Override
                public Memory assignBitShl(String memory) {
                    this.value = this.toValue();
                    return super.assignBitShl(memory);
                }

                @Override
                public Memory assignBitShlRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitShlRight(memory);
                }

                @Override
                public Memory assignBitAnd(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitAnd(memory);
                }

                @Override
                public Memory assignBitAnd(long memory) {
                    this.value = this.toValue();
                    return super.assignBitAnd(memory);
                }

                @Override
                public Memory assignBitAnd(double memory) {
                    this.value = this.toValue();
                    return super.assignBitAnd(memory);
                }

                @Override
                public Memory assignBitAnd(boolean memory) {
                    this.value = this.toValue();
                    return super.assignBitAnd(memory);
                }

                @Override
                public Memory assignBitAnd(String memory) {
                    this.value = this.toValue();
                    return super.assignBitAnd(memory);
                }

                @Override
                public Memory assignBitAndRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitAndRight(memory);
                }

                @Override
                public Memory assignBitOr(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitOr(memory);
                }

                @Override
                public Memory assignBitOr(long memory) {
                    this.value = this.toValue();
                    return super.assignBitOr(memory);
                }

                @Override
                public Memory assignBitOr(double memory) {
                    this.value = this.toValue();
                    return super.assignBitOr(memory);
                }

                @Override
                public Memory assignBitOr(boolean memory) {
                    this.value = this.toValue();
                    return super.assignBitOr(memory);
                }

                @Override
                public Memory assignBitOr(String memory) {
                    this.value = this.toValue();
                    return super.assignBitOr(memory);
                }

                @Override
                public Memory assignBitOrRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitOrRight(memory);
                }

                @Override
                public Memory assignBitXor(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitXor(memory);
                }

                @Override
                public Memory assignBitXor(long memory) {
                    this.value = this.toValue();
                    return super.assignBitXor(memory);
                }

                @Override
                public Memory assignBitXor(double memory) {
                    this.value = this.toValue();
                    return super.assignBitXor(memory);
                }

                @Override
                public Memory assignBitXor(boolean memory) {
                    this.value = this.toValue();
                    return super.assignBitXor(memory);
                }

                @Override
                public Memory assignBitXor(String memory) {
                    this.value = this.toValue();
                    return super.assignBitXor(memory);
                }

                @Override
                public Memory assignBitXorRight(Memory memory) {
                    this.value = this.toValue();
                    return super.assignBitXorRight(memory);
                }

                @Override
                public Memory toValue() {
                    return ObjectMemory.this.valueOfIndex(trace, index);
                }

                @Override
                public ReferenceMemory getReference() {
                    Memory ret = this.toValue();
                    if (ret instanceof ReferenceMemory) {
                        return (ReferenceMemory)ret;
                    }
                    return new ReferenceMemory();
                }

                @Override
                public Memory toImmutable() {
                    return this.toValue().toImmutable();
                }

                @Override
                public Memory inc() {
                    return this.toValue().inc();
                }

                @Override
                public Memory dec() {
                    return this.toValue().dec();
                }

                @Override
                public Memory valueOfIndex(TraceInfo trace2, Memory index2) {
                    return this.toValue().valueOfIndex(trace2, index2);
                }

                @Override
                public Memory valueOfIndex(TraceInfo trace2, long index2) {
                    return this.toValue().valueOfIndex(trace2, index2);
                }

                @Override
                public Memory valueOfIndex(TraceInfo trace2, double index2) {
                    return this.toValue().valueOfIndex(trace2, index2);
                }

                @Override
                public Memory valueOfIndex(TraceInfo trace2, String index2) {
                    return this.toValue().valueOfIndex(trace2, index2);
                }

                @Override
                public Memory valueOfIndex(TraceInfo trace2, boolean index2) {
                    return this.toValue().valueOfIndex(trace2, index2);
                }

                @Override
                public Memory refOfPush(TraceInfo trace2) {
                    return this.toValue().refOfPush(trace2);
                }

                @Override
                public Memory refOfIndexAsShortcut(TraceInfo trace2, Memory index2) {
                    return this.toValue().refOfIndexAsShortcut(trace2, index2);
                }

                @Override
                public Memory refOfIndex(TraceInfo trace2, Memory index2) {
                    return this.toValue().refOfIndex(trace2, index2);
                }

                @Override
                public Memory refOfIndex(TraceInfo trace2, long index2) {
                    return this.toValue().refOfIndex(trace2, index2);
                }

                @Override
                public Memory refOfIndex(TraceInfo trace2, double index2) {
                    return this.toValue().refOfIndex(trace2, index2);
                }

                @Override
                public Memory refOfIndex(TraceInfo trace2, String index2) {
                    return this.toValue().refOfIndex(trace2, index2);
                }

                @Override
                public Memory refOfIndex(TraceInfo trace2, boolean index2) {
                    return this.toValue().refOfIndex(trace2, index2);
                }

                @Override
                public void unsetOfIndex(TraceInfo trace2, Memory index2) {
                    this.toValue().unsetOfIndex(trace2, index2);
                }

                @Override
                public Memory issetOfIndex(TraceInfo trace2, Memory index2) {
                    return this.toValue().issetOfIndex(trace2, index2);
                }

                @Override
                public Memory emptyOfIndex(TraceInfo trace2, Memory index2) {
                    return this.toValue().emptyOfIndex(trace2, index2);
                }
            };
        }
        this.invalidUseAsArray(trace);
        return new ReferenceMemory();
    }

    @Override
    public Memory refOfIndexAsShortcut(TraceInfo trace, Memory index) {
        return this.refOfIndex(trace, index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, long index) {
        return this.refOfIndex(trace, LongMemory.valueOf(index));
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, double index) {
        return this.refOfIndex(trace, DoubleMemory.valueOf(index));
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, String index) {
        return this.refOfIndex(trace, StringMemory.valueOf(index));
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, boolean index) {
        return this.refOfIndex(trace, index ? TRUE : FALSE);
    }

    @Override
    public Memory refOfPush(TraceInfo trace) {
        if (this.value instanceof ArrayAccess) {
            return this.refOfIndex(trace, NULL);
        }
        this.invalidUseAsArray(trace);
        return new ReferenceMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        if (this.value instanceof ArrayAccess) {
            Environment env = this.value.getEnvironment();
            if (env != null && trace != null) {
                Memory[] args = new Memory[]{index};
                env.pushCall(this.value, "offsetGet", args);
                try {
                    Memory memory = ((ArrayAccess)this.value).offsetGet(env, args);
                    return memory;
                }
                finally {
                    env.popCall();
                }
            }
            this.invalidUseAsArray(trace);
            return NULL;
        }
        this.invalidUseAsArray(trace);
        return NULL;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        return this.valueOfIndex(trace, TrueMemory.valueOf(index));
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        return this.valueOfIndex(trace, LongMemory.valueOf(index));
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        return this.valueOfIndex(trace, DoubleMemory.valueOf(index));
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        return this.valueOfIndex(trace, StringMemory.valueOf(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsetOfIndex(TraceInfo trace, Memory index) {
        if (this.value instanceof ArrayAccess) {
            Environment env = this.value.getEnvironment();
            if (env != null && trace != null) {
                Memory[] args = new Memory[]{index};
                env.pushCall(this.value, "offsetUnset", args);
                try {
                    ((ArrayAccess)this.value).offsetUnset(env, args);
                }
                finally {
                    env.popCall();
                }
            } else {
                this.invalidUseAsArray(trace);
            }
        } else {
            this.invalidUseAsArray(trace);
        }
    }

    @Override
    public Memory emptyOfIndex(TraceInfo trace, Memory index) {
        return this.issetOfIndex(trace, index, true);
    }

    @Override
    public Memory issetOfIndex(TraceInfo trace, Memory index) {
        return this.issetOfIndex(trace, index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memory issetOfIndex(TraceInfo trace, Memory index, boolean asEmpty) {
        if (this.value instanceof ArrayAccess) {
            Environment env = this.value.getEnvironment();
            if (env != null && trace != null) {
                Memory[] args = new Memory[]{index};
                env.pushCall(this.value, "offsetExists", args);
                try {
                    if (((ArrayAccess)this.value).offsetExists(env, args).toBoolean()) {
                        Memory memory = asEmpty ? this.valueOfIndex(trace, index) : TRUE;
                        return memory;
                    }
                    Memory memory = NULL;
                    return memory;
                }
                finally {
                    env.popCall();
                }
            }
            this.invalidUseAsArray(trace);
            return NULL;
        }
        this.invalidUseAsArray(trace);
        return NULL;
    }

    @Override
    public boolean isClosure() {
        return this.value instanceof Closure;
    }

    private static interface Comparator {
        public boolean compare(IObject var1, IObject var2);
    }
}

