/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import php.runtime.Memory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.support.MemoryStringUtils;

public class LongMemory
extends Memory {
    protected static final int MAX_CACHE_STRING = 10000;
    protected static final int MAX_NEG_CACHE = 4681;
    protected static final int MAX_POS_CACHE = 28086;
    protected static final String[] STRING_VALUES;
    protected static final LongMemory[] CACHE;
    public long value;

    public LongMemory(long value) {
        super(Memory.Type.INT);
        this.value = value;
    }

    public static Memory valueOf(long value) {
        if (value >= -4681L && value < 28086L) {
            return CACHE[(int)value + 4681];
        }
        return new LongMemory(value);
    }

    public static Memory valueOf(int value) {
        if (value >= -4681 && value <= 4681) {
            return CACHE[value + 4681];
        }
        return new LongMemory(value);
    }

    public static Memory valueOf(byte value) {
        return LongMemory.valueOf((int)value);
    }

    public static Memory valueOf(short value) {
        return LongMemory.valueOf((int)value);
    }

    public static Memory valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public boolean toBoolean() {
        return this.value != 0L;
    }

    @Override
    public Memory toNumeric() {
        return this;
    }

    @Override
    public String toString() {
        if (this.value >= 0L && this.value < 10000L) {
            return STRING_VALUES[(int)this.value];
        }
        return String.valueOf(this.value);
    }

    @Override
    public Memory inc() {
        return new LongMemory(this.value + 1L);
    }

    @Override
    public Memory dec() {
        return new LongMemory(this.value - 1L);
    }

    @Override
    public Memory negative() {
        return new LongMemory(-this.value);
    }

    @Override
    public Memory plus(Memory memory) {
        switch (memory.type) {
            case INT: {
                return LongMemory.valueOf(this.value + ((LongMemory)memory).value);
            }
            case DOUBLE: {
                return new DoubleMemory((double)this.value + ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.plus(memory.toValue());
            }
        }
        return this.plus(memory.toNumeric());
    }

    @Override
    public Memory minus(Memory memory) {
        switch (memory.type) {
            case INT: {
                return LongMemory.valueOf(this.value - ((LongMemory)memory).value);
            }
            case DOUBLE: {
                return new DoubleMemory((double)this.value - ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.minus(memory.toValue());
            }
        }
        return this.minus(memory.toNumeric());
    }

    @Override
    public Memory mul(Memory memory) {
        switch (memory.type) {
            case INT: {
                return LongMemory.valueOf(this.value * ((LongMemory)memory).value);
            }
            case DOUBLE: {
                return new DoubleMemory((double)this.value * ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.mul(memory.toValue());
            }
        }
        return this.mul(memory.toNumeric());
    }

    @Override
    public Memory pow(Memory memory) {
        switch (memory.type) {
            case INT: {
                return this.pow(((LongMemory)memory).value);
            }
            case DOUBLE: {
                return this.pow(((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.pow(memory.toImmutable());
            }
        }
        return this.pow(memory.toNumeric());
    }

    @Override
    public Memory div(Memory memory) {
        switch (memory.type) {
            case INT: {
                long tmp = ((LongMemory)memory).value;
                if (tmp == 0L) {
                    return FALSE;
                }
                if (this.value % tmp == 0L) {
                    return LongMemory.valueOf(this.value / tmp);
                }
                return new DoubleMemory((double)this.value / (double)tmp);
            }
            case DOUBLE: {
                if (((DoubleMemory)memory).value == 0.0) {
                    return FALSE;
                }
                return new DoubleMemory((double)this.value / ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.div(memory.toValue());
            }
        }
        return this.div(memory.toNumeric());
    }

    @Override
    public Memory div(long value) {
        if (value == 0L) {
            return FALSE;
        }
        if (this.value % value == 0L) {
            return LongMemory.valueOf(this.value / value);
        }
        return new DoubleMemory((double)this.value / (double)value);
    }

    @Override
    public boolean identical(Memory memory) {
        return memory.getRealType() == Memory.Type.INT && ((LongMemory)memory).value == this.value;
    }

    @Override
    public boolean equal(Memory memory) {
        switch (memory.type) {
            case INT: {
                return ((LongMemory)memory).value == this.value;
            }
            case DOUBLE: {
                return ((DoubleMemory)memory).value == (double)this.value;
            }
            case STRING: {
                return this.equal(memory.toNumeric());
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return this.value == this.toLong();
    }

    @Override
    public boolean equal(long value) {
        return this.value == value;
    }

    @Override
    public boolean equal(double value) {
        return (double)this.value == value;
    }

    @Override
    public boolean notEqual(Memory memory) {
        switch (memory.type) {
            case INT: {
                return ((LongMemory)memory).value != this.value;
            }
            case DOUBLE: {
                return ((DoubleMemory)memory).value != (double)this.value;
            }
            case STRING: {
                return this.notEqual(memory.toNumeric());
            }
            case REFERENCE: {
                return this.smaller(memory.toValue());
            }
        }
        return this.value != this.toLong();
    }

    @Override
    public String concat(Memory memory) {
        return this.toString().concat(memory.toString());
    }

    @Override
    public boolean smaller(Memory memory) {
        switch (memory.type) {
            case DOUBLE: {
                return (double)this.value < ((DoubleMemory)memory).value;
            }
            case INT: {
                return this.value < ((LongMemory)memory).value;
            }
            case STRING: {
                return this.smaller(memory.toNumeric());
            }
            case REFERENCE: {
                return this.smaller(memory.toValue());
            }
        }
        return this.value < this.toLong();
    }

    @Override
    public boolean smallerEq(Memory memory) {
        switch (memory.type) {
            case DOUBLE: {
                return (double)this.value <= ((DoubleMemory)memory).value;
            }
            case INT: {
                return this.value <= ((LongMemory)memory).value;
            }
            case STRING: {
                return this.smallerEq(memory.toNumeric());
            }
            case REFERENCE: {
                return this.smallerEq(memory.toValue());
            }
        }
        return this.value <= this.toLong();
    }

    @Override
    public boolean greater(Memory memory) {
        return memory.smaller(this);
    }

    @Override
    public boolean greaterEq(Memory memory) {
        return memory.smallerEq(this);
    }

    @Override
    public Memory minus(long value) {
        return LongMemory.valueOf(this.value - value);
    }

    @Override
    public Memory plus(long value) {
        return LongMemory.valueOf(this.value + value);
    }

    @Override
    public Memory div(boolean value) {
        if (!value) {
            return FALSE;
        }
        return this;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof LongMemory)) {
            return false;
        }
        LongMemory that = (LongMemory)o;
        return this.value == that.value;
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return MemoryStringUtils.getBinaryBytes(this);
    }

    static {
        int i;
        STRING_VALUES = new String[10000];
        for (i = 0; i < 10000; ++i) {
            LongMemory.STRING_VALUES[i] = String.valueOf(i);
        }
        CACHE = new LongMemory[Short.MAX_VALUE];
        for (i = -4681; i < 28086; ++i) {
            LongMemory.CACHE[i + 4681] = new LongMemory(i);
        }
    }
}

