/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.lang.exception;

import java.lang.ref.WeakReference;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.CallStackItem;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.JPHPException;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

public abstract class BaseBaseException
extends RuntimeException
implements IObject,
JPHPException {
    protected final ArrayMemory props;
    protected ClassEntity clazz;
    protected WeakReference<Environment> env;
    protected TraceInfo trace;
    protected CallStackItem[] callStack;
    private boolean init = true;
    private boolean isFinalized = false;
    private String nativeMessage = null;

    public BaseBaseException(String message) {
        this((Environment)null);
        this.nativeMessage = message;
    }

    public BaseBaseException(Environment env) {
        this(env, null);
        this.clazz = env == null ? null : env.fetchClass(this.getClass());
    }

    public BaseBaseException(Environment env, ClassEntity clazz) {
        this.clazz = clazz;
        this.props = new ArrayMemory();
        this.env = env == null ? null : new WeakReference<Environment>(env);
    }

    public void setTraceInfo(Environment env, TraceInfo trace) {
        this.callStack = env.getCallStackSnapshot();
        this.trace = trace;
        this.init = false;
    }

    @Override
    public ClassEntity getReflection() {
        return this.clazz;
    }

    @Override
    public ArrayMemory getProperties() {
        if (!this.init) {
            this.init = true;
            if (this.trace != null) {
                Memory m = this.clazz.refOfProperty(this.props, "file");
                if (m.isNull()) {
                    m.assign(this.trace.getFileName());
                }
                if ((m = this.clazz.refOfProperty(this.props, "line")).isNull()) {
                    m.assign(this.trace.getStartLine() + 1);
                }
                if ((m = this.clazz.refOfProperty(this.props, "position")).isNull()) {
                    m.assign(this.trace.getStartPosition() + 1);
                }
                ArrayMemory backTrace = new ArrayMemory();
                for (CallStackItem el : this.callStack) {
                    backTrace.add(el.toArray());
                }
                this.clazz.refOfProperty(this.props, "trace").assign(backTrace);
            }
        }
        return this.props;
    }

    @Override
    public final int getPointer() {
        return super.hashCode();
    }

    @Override
    public boolean isMock() {
        return this.clazz == null;
    }

    @Override
    public void setAsMock() {
        this.clazz = null;
    }

    public CallStackItem[] getCallStack() {
        Environment env = this.getEnvironment();
        if (env != null) {
            env.applySourceMap(this.callStack);
        }
        return this.callStack;
    }

    public TraceInfo getTrace() {
        Environment env = this.getEnvironment();
        if (env != null) {
            return env.getTraceAppliedSourceMap(this.trace);
        }
        return this.trace == null ? TraceInfo.UNKNOWN : this.trace;
    }

    @Reflection.Signature
    public Memory getMessage(Environment env, Memory ... args) {
        if (this.nativeMessage != null) {
            return StringMemory.valueOf(this.nativeMessage);
        }
        return this.clazz.refOfProperty(this.getProperties(), "message").toValue();
    }

    @Reflection.Signature
    public Memory getCode(Environment env, Memory ... args) {
        return this.clazz.refOfProperty(this.getProperties(), "code").toValue();
    }

    @Reflection.Signature
    public Memory getLine(Environment env, Memory ... args) {
        return this.clazz.refOfProperty(this.getProperties(), "line").toValue();
    }

    @Reflection.Signature
    public Memory getPosition(Environment env, Memory ... args) {
        return this.clazz.refOfProperty(this.getProperties(), "position").toValue();
    }

    @Reflection.Signature
    public Memory getFile(Environment env, Memory ... args) {
        return this.clazz.refOfProperty(this.getProperties(), "file").toValue();
    }

    @Reflection.Signature
    public Memory getTrace(Environment env, Memory ... args) {
        return this.clazz.refOfProperty(this.getProperties(), "trace").toValue();
    }

    @Reflection.Signature
    public Memory getPrevious(Environment env, Memory ... args) {
        return this.clazz.refOfProperty(this.getProperties(), "previous").toValue();
    }

    @Reflection.Signature
    public Memory __toString(Environment env, Memory ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("exception '").append(this.clazz.getName()).append("' with message '").append(this.clazz.refOfProperty(this.getProperties(), "message")).append("' in ").append(this.clazz.refOfProperty(this.getProperties(), "file")).append(":").append(this.clazz.refOfProperty(this.getProperties(), "line"));
        sb.append("\nStack Trace:\n");
        sb.append(this.getTraceAsString(env, new Memory[0]));
        return new StringMemory(sb.toString());
    }

    @Reflection.Signature
    public Memory getTraceAsString(Environment env, Memory ... args) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        if (this.callStack != null) {
            for (CallStackItem e : this.getCallStack()) {
                if (i != 0) {
                    sb.append("\n");
                }
                sb.append("#").append(i).append(" ").append(e.toString(false));
                ++i;
            }
            if (i != 0) {
                sb.append("\n");
            }
            sb.append("#").append(i).append(" {main}");
        }
        return new StringMemory(sb.toString());
    }

    @Override
    public Throwable fillInStackTrace() {
        return null;
    }

    @Override
    public Environment getEnvironment() {
        return (Environment)this.env.get();
    }

    @Override
    public boolean isFinalized() {
        return this.isFinalized;
    }

    @Override
    public void doFinalize() {
        this.isFinalized = true;
    }

    @Override
    public String toString() {
        Environment environment;
        if (this.clazz.methodMagicToString != null && (environment = this.getEnvironment()) != null) {
            return environment.invokeMethodNoThrow(this, "__toString", new Memory[0]).toString();
        }
        return super.toString();
    }
}

