/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.lang;

import java.util.NoSuchElementException;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.CallStack;
import php.runtime.env.CallStackItem;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.FinallyException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.lang.BaseException;
import php.runtime.lang.BaseObject;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.lang.support.IManualDestructable;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.helper.GeneratorEntity;
import php.runtime.util.generator.YieldAdapterIterator;

@Reflection.Name(value="Generator")
@Reflection.Final
public abstract class Generator
extends BaseObject
implements Iterator,
IManualDestructable {
    protected Memory self;
    protected final Memory[] uses;
    protected boolean isInit = false;
    protected int counter = 0;
    protected boolean valid = true;
    protected final YieldAdapterIterator<Bucket> iterator;
    protected final php.runtime.util.generator.Generator<Bucket> gen;
    protected static final ThreadLocal<Generator> currentGenerator = new ThreadLocal();
    protected CallStackItem callStackItem;
    protected CallStack callStack;
    protected Throwable lastThrowable = null;
    protected RuntimeException newThrow = null;
    protected boolean busy;
    protected ClosedType closed;

    public Generator(final Environment env, ClassEntity generator, Memory self, Memory[] uses) {
        super(env, generator);
        if (generator == null) {
            throw new CriticalException("Unable to create generator");
        }
        env.registerObjectInGC(this);
        this.self = self;
        this.uses = uses;
        CallStackItem stackItem = env.peekCall(0);
        this.callStack = env.getCallStack();
        this.callStackItem = stackItem == null ? null : new CallStackItem(stackItem);
        this.gen = new php.runtime.util.generator.Generator<Bucket>(){

            @Override
            protected void run(YieldAdapterIterator<Bucket> yieldAdapter) {
                try {
                    currentGenerator.set(Generator.this);
                    env.__replaceCallStack(Generator.this.callStack);
                    Generator.this._run(env, new Memory[0]);
                }
                catch (Throwable e) {
                    Generator.this.lastThrowable = e;
                    Generator.this.setCurrent(Memory.NULL);
                }
            }
        };
        this.iterator = this.gen.iterator();
    }

    protected abstract Memory _run(Environment var1, Memory ... var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Memory _next(Environment env) {
        if (this.busy) {
            env.error(env.trace(), "Cannot resume an already running generator", new Object[0]);
        }
        boolean x2 = false;
        if (this.callStackItem != null) {
            env.pushCall(new CallStackItem(this.callStackItem));
            x2 = true;
        }
        try {
            ++this.counter;
            this.busy = true;
            Memory memory = ((Bucket)this.iterator.next()).getValue();
            return memory;
        }
        catch (NoSuchElementException e) {
            this.valid = false;
            this.callStackItem = null;
        }
        finally {
            if (x2) {
                env.popCall();
            }
            this.busy = false;
            this.checkThrow();
        }
        return null;
    }

    protected void checkNewThrow() {
        if (this.newThrow != null) {
            try {
                throw this.newThrow;
            }
            catch (Throwable throwable) {
                this.newThrow = null;
                throw throwable;
            }
        }
    }

    protected void checkThrow() {
        if (this.lastThrowable != null) {
            try {
                if (this.lastThrowable instanceof RuntimeException) {
                    throw (RuntimeException)this.lastThrowable;
                }
                throw new RuntimeException(this.lastThrowable);
            }
            catch (Throwable throwable) {
                this.lastThrowable = null;
                throw throwable;
            }
        }
    }

    public boolean isReturnReferences() {
        return ((GeneratorEntity)this.getReflection()).isReturnReference();
    }

    @Override
    public void onManualDestruct(Environment env) {
        this.closed = ClosedType.MANUAL;
    }

    @Reflection.Signature
    public Memory __destruct(Environment env, Memory ... args) {
        if (this.isInit) {
            if (this.closed == null) {
                this.closed = ClosedType.DEFAULT;
            }
            this.newThrow = new FinallyException();
            this._next(env);
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory next(Environment env, Memory ... args) {
        this._next(env);
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value")})
    public synchronized Memory send(Environment env, Memory ... args) {
        Bucket current;
        if (!this.isInit) {
            this.rewind(env, new Memory[0]);
        }
        if ((current = this.iterator.getCurrentValue()) == null) {
            this.iterator.setCurrentValue(new Bucket(args[0]));
        } else {
            current.pushValue(args[0]);
        }
        return this._next(env);
    }

    @Reflection.Name(value="throw")
    @Reflection.Signature(value={@Reflection.Arg(value="throwable", nativeType=BaseException.class)})
    public synchronized Memory _throw(Environment env, Memory ... args) {
        if (this.valid) {
            this.newThrow = args[0].toObject(BaseException.class);
            ((BaseException)this.newThrow).setTraceInfo(env, env.trace());
            return this._next(env);
        }
        env.__throwException(args[0].toObject(BaseException.class));
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory rewind(Environment env, Memory ... args) {
        if (!this.valid) {
            env.exception("Cannot traverse an already closed generator", new Object[0]);
        }
        if (this.counter > 1) {
            env.exception("Cannot rewind a generator that was already run", new Object[0]);
        }
        if (!this.isInit) {
            this.counter = 0;
            this._next(env);
            this.isInit = true;
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory valid(Environment env, Memory ... args) {
        return this.valid ? Memory.TRUE : Memory.FALSE;
    }

    @Override
    @Reflection.Signature
    public Memory current(Environment env, Memory ... args) {
        if (!this.isInit) {
            this.rewind(env, new Memory[0]);
        }
        if (this.iterator.getCurrentValue() == null) {
            return Memory.NULL;
        }
        return this.iterator.getCurrentValue().getValue();
    }

    protected Memory __current() {
        Bucket current = this.iterator.getCurrentValue();
        return current == null ? Memory.NULL : current.getValue();
    }

    @Override
    @Reflection.Signature
    public Memory key(Environment env, Memory ... args) {
        if (!this.isInit) {
            this.rewind(env, new Memory[0]);
        }
        if (this.iterator.getCurrentValue() == null) {
            return Memory.NULL;
        }
        return this.iterator.getCurrentValue().getKey();
    }

    @Reflection.Signature
    public final Memory __clone(Environment env, Memory ... args) {
        env.error(ErrorType.E_ERROR, "Trying to clone an uncloneable object of class " + this.getReflection().getName(), new Object[0]);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __wakeup(Environment env, Memory ... args) {
        env.exception("Unserialization of 'Generator' is not allowed", new Object[0]);
        return Memory.NULL;
    }

    @Reflection.Signature
    private Memory __sleep(Environment env, Memory ... args) {
        env.exception(env.trace(), "Serialization of 'Generator' is not allowed", new Object[0]);
        return Memory.NULL;
    }

    public CallStackItem getCallStackItem() {
        return this.callStackItem;
    }

    protected void _setValid(boolean valid) {
        this.checkNewThrow();
        this.valid = valid;
        if (!valid) {
            this.callStackItem = null;
        }
    }

    protected Memory yield(Environment env, TraceInfo trace) {
        return this.yield(env, trace, Memory.NULL);
    }

    protected Bucket setCurrent(Memory value) {
        boolean returnRef = ((GeneratorEntity)this.getReflection()).isReturnReference();
        Bucket current = this.iterator.getCurrentValue();
        if (value instanceof KeyValueMemory) {
            if (current != null) {
                current.setKey(((KeyValueMemory)value).key);
                current.setValue(returnRef ? new ReferenceMemory(value) : value.toValue());
            } else {
                current = new Bucket(((KeyValueMemory)value).key, returnRef ? new ReferenceMemory(value) : value.toValue());
            }
        } else {
            if (returnRef) {
                value = new ReferenceMemory(value);
            }
            if (current != null) {
                current.pushValue(value);
            } else {
                current = new Bucket(Memory.CONST_INT_0, value);
            }
        }
        return current;
    }

    protected Memory yield(Environment env, TraceInfo trace, Memory value) {
        if (this.closed == ClosedType.MANUAL) {
            env.error(trace, "Cannot yield from finally in a force-closed generator", new Object[0]);
        }
        this.checkNewThrow();
        Bucket current = this.setCurrent(value);
        this.gen.yield(current);
        this.checkNewThrow();
        return current.getValue();
    }

    protected Memory yield(Memory key, Memory value) {
        return this.gen.yield(new Bucket(key, value)).getValue();
    }

    public static Generator current() {
        return currentGenerator.get();
    }

    private static class Bucket {
        private Memory key;
        private Memory value;

        private Bucket(Memory value) {
            this.key = Memory.CONST_INT_0;
            this.value = value;
        }

        private Bucket(Memory key, Memory value) {
            this.key = key;
            this.value = value;
        }

        public Memory getKey() {
            return this.key;
        }

        public void setKey(Memory key) {
            this.key = key;
        }

        public Memory getValue() {
            return this.value;
        }

        public void setValue(Memory value) {
            this.value = value;
        }

        public void pushValue(Memory value) {
            this.key = this.key.inc();
            this.value = value;
        }
    }

    private static enum ClosedType {
        DEFAULT,
        MANUAL;

    }
}

