/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.invoke;

import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.Invoker;
import php.runtime.invoke.MagicDynamicMethodInvoker;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.lang.IObject;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ParameterEntity;

public class DynamicMethodInvoker
extends Invoker {
    protected final IObject object;
    protected final MethodEntity method;

    public DynamicMethodInvoker(Environment env, TraceInfo trace, IObject object, MethodEntity method) {
        super(env, trace);
        this.object = object;
        this.method = method;
    }

    @Override
    public ParameterEntity[] getParameters() {
        return this.method.getParameters();
    }

    @Override
    public String getName() {
        return this.object.getReflection().getName() + "::" + this.method.getName();
    }

    public IObject getObject() {
        return this.object;
    }

    public MethodEntity getMethod() {
        return this.method;
    }

    @Override
    public int getArgumentCount() {
        return this.method.getParameters() == null ? 0 : this.method.getParameters().length;
    }

    @Override
    public void pushCall(TraceInfo trace, Memory[] args) {
        this.env.pushCall(trace, this.object, args, this.method.getName(), this.method.getClazz().getName(), this.object.getReflection().getName());
    }

    @Override
    protected Memory invoke(Memory ... args) throws Throwable {
        return ObjectInvokeHelper.invokeMethod(this.object, this.method, this.env, this.trace == null ? TraceInfo.UNKNOWN : this.trace, args, false);
    }

    @Override
    public int canAccess(Environment env) {
        return this.method.canAccess(env);
    }

    public static DynamicMethodInvoker valueOf(Environment env, TraceInfo trace, IObject object, String methodName) {
        MethodEntity methodEntity;
        String methodNameL = methodName.toLowerCase();
        int pos = methodName.indexOf("::");
        if (pos > -1) {
            ClassEntity clazz;
            String className = methodNameL.substring(0, pos);
            methodNameL = methodNameL.substring(pos + 2);
            ClassEntity classEntity = object.getReflection();
            if (!classEntity.isInstanceOf(clazz = env.fetchClass(methodName.substring(0, pos), className, false))) {
                return null;
            }
            methodEntity = clazz.findMethod(methodNameL);
        } else {
            methodEntity = object.getReflection().findMethod(methodNameL);
        }
        if (methodEntity == null) {
            if (object.getReflection().methodMagicCall != null) {
                return new MagicDynamicMethodInvoker(env, trace, object, object.getReflection().methodMagicCall, methodName);
            }
            if (trace == null) {
                return null;
            }
            env.error(trace, Messages.ERR_CALL_TO_UNDEFINED_METHOD.fetch(object.getReflection().getName() + "::" + methodName), new Object[0]);
        }
        return new DynamicMethodInvoker(env, trace, object, methodEntity);
    }

    public static DynamicMethodInvoker valueOf(Environment env, TraceInfo trace, Memory object, String methodName) {
        return DynamicMethodInvoker.valueOf(env, trace, ((ObjectMemory)object).value, methodName);
    }

    public static DynamicMethodInvoker valueOf(Environment env, TraceInfo trace, IObject object) {
        MethodEntity methodEntity = object.getReflection().methodMagicInvoke;
        if (methodEntity == null) {
            if (trace == null) {
                return null;
            }
            env.error(trace, Messages.ERR_CALL_TO_UNDEFINED_METHOD.fetch(object.getReflection().getName() + "::__invoke"), new Object[0]);
        }
        return new DynamicMethodInvoker(env, null, object, methodEntity);
    }

    public static DynamicMethodInvoker valueOf(Environment env, TraceInfo trace, Memory object) {
        return DynamicMethodInvoker.valueOf(env, trace, ((ObjectMemory)object).value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicMethodInvoker)) {
            return false;
        }
        DynamicMethodInvoker that = (DynamicMethodInvoker)o;
        return this.method.equals(that.method) && this.object.getPointer() == that.object.getPointer();
    }

    public int hashCode() {
        int result = this.object.hashCode();
        result = 31 * result + this.method.hashCode();
        return result;
    }
}

