/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.net.WrapURL;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\net\\NetStream")
@Stream.UsePathWithProtocols
public class WrapNetStream
extends Stream {
    protected URL url;
    protected Proxy proxy;
    protected boolean eof = false;
    protected int position = 0;
    protected URLConnection urlConnection;
    protected InputStream currentInputStream;
    protected OutputStream currentOutputStream;

    public WrapNetStream(Environment env, URL url) {
        super(env);
        this.url = url;
    }

    public WrapNetStream(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public URLConnection getURLConnection() throws IOException {
        if (this.urlConnection == null) {
            this.urlConnection = this.proxy != null ? this.url.openConnection(this.proxy) : this.url.openConnection();
            this.urlConnection.setDoInput(false);
            this.urlConnection.setDoOutput(false);
            if (this.getMode().startsWith("r") || this.getMode().startsWith("w") || this.getMode().startsWith("a")) {
                this.urlConnection.setDoInput(true);
            }
            if (this.getMode().startsWith("w") || this.getMode().startsWith("a")) {
                this.urlConnection.setDoOutput(true);
            }
        }
        return this.urlConnection;
    }

    public HttpURLConnection getHttpURLConnection() throws IOException {
        return (HttpURLConnection)this.getURLConnection();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.currentOutputStream == null) {
            this.currentOutputStream = this.getURLConnection().getOutputStream();
        }
        return this.currentOutputStream;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.currentInputStream == null) {
            URLConnection urlConnection = this.getURLConnection();
            try {
                this.currentInputStream = urlConnection.getInputStream();
                if (this.currentInputStream == null && urlConnection instanceof HttpURLConnection) {
                    this.currentInputStream = ((HttpURLConnection)urlConnection).getErrorStream();
                }
            }
            catch (IOException e) {
                if (urlConnection instanceof HttpURLConnection) {
                    this.currentInputStream = ((HttpURLConnection)urlConnection).getErrorStream();
                }
                throw e;
            }
        }
        if (this.currentInputStream == null) {
            throw new IOException("Unable to get input stream for connection " + this.getPath());
        }
        return this.currentInputStream;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="w+"))})
    public Memory __construct(Environment env, Memory ... args) throws IOException {
        super.__construct(env, args);
        if (this.getMode() == null) {
            this.setMode("w+");
        }
        this.url = new URL(args[0].toString());
        this.getInputStream();
        return Memory.NULL;
    }

    @Reflection.Signature
    public WrapURL getURL(Environment env) throws MalformedURLException {
        return new WrapURL(env, new URL(this.getPath()));
    }

    @Override
    public Memory write(Environment env, Memory ... args) throws IOException {
        int len = args[1].toInteger();
        byte[] bytes = args[0].getBinaryBytes(env.getDefaultCharset());
        len = len == 0 || len > bytes.length ? bytes.length : len;
        this.getOutputStream().write(bytes, 0, len);
        return LongMemory.valueOf(len);
    }

    @Override
    public Memory read(Environment env, Memory ... args) throws IOException {
        int len = args[0].toInteger();
        if (len <= 0) {
            return Memory.FALSE;
        }
        byte[] buf = new byte[len];
        int read = this.getInputStream().read(buf);
        boolean bl = this.eof = read == -1;
        if (read == -1) {
            return Memory.FALSE;
        }
        this.position += read;
        return new BinaryMemory(Arrays.copyOf(buf, read));
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="bufferSize", optional=@Reflection.Optional(value="4096"))})
    public Memory readFully(Environment env, Memory ... args) throws IOException {
        int len;
        int bufferSize = args[0].toInteger();
        if (bufferSize <= 0) {
            return Memory.FALSE;
        }
        byte[] buff = new byte[bufferSize];
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        while ((len = this.getInputStream().read(buff)) > 0) {
            tmp.write(buff, 0, len);
            this.position += len;
        }
        return new BinaryMemory(tmp.toByteArray());
    }

    @Override
    public Memory eof(Environment env, Memory ... args) {
        if (this.urlConnection == null) {
            return Memory.FALSE;
        }
        return this.eof ? Memory.TRUE : Memory.FALSE;
    }

    @Override
    public Memory seek(Environment env, Memory ... args) throws IOException {
        throw new IOException("Unavailable seek() operation");
    }

    @Override
    public Memory getPosition(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.position);
    }

    @Override
    public Memory close(Environment env, Memory ... args) throws IOException {
        if (this.urlConnection != null && this.urlConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.urlConnection).disconnect();
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public void setProxy(@Reflection.Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Reflection.Signature
    public Proxy getProxy() {
        return this.proxy;
    }

    @Reflection.Signature
    public URLConnection getUrlConnection() throws IOException {
        return this.getURLConnection();
    }

    @Override
    public boolean _isExternalResourceStream() {
        return true;
    }
}

