/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.java;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.java.JavaClass;
import php.runtime.ext.java.JavaObject;
import php.runtime.ext.java.JavaReflection;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.support.MemoryUtils;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\JavaField")
public final class JavaField
extends JavaReflection {
    protected Field field;
    protected Memory cachedMemory;
    protected boolean canCaching;
    protected int mod;

    public JavaField(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public void setField(Field field) {
        this.field = field;
        field.setAccessible(true);
        this.mod = field.getModifiers();
        this.canCaching = Modifier.isFinal(this.mod) && Modifier.isStatic(this.mod);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object", typeClass="php\\lang\\JavaObject", optional=@Reflection.Optional(value="NULL"))})
    public Memory get(Environment env, Memory ... args) {
        if (this.canCaching && this.cachedMemory != null) {
            return this.cachedMemory;
        }
        try {
            if (args[0].isNull()) {
                this.cachedMemory = MemoryUtils.valueOf(env, this.field.get(null));
                return this.cachedMemory;
            }
            JavaObject javaObject = (JavaObject)args[0].toValue(ObjectMemory.class).value;
            this.cachedMemory = MemoryUtils.valueOf(env, this.field.get(javaObject.object));
            return this.cachedMemory;
        }
        catch (IllegalAccessException e) {
            JavaField.exception(env, e);
            return Memory.NULL;
        }
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object", typeClass="php\\lang\\JavaObject", optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="value")})
    public Memory set(Environment env, Memory ... args) {
        try {
            if (args[0].isNull()) {
                this.field.set(null, MemoryUtils.fromMemory(args[1], this.field.getType()));
            } else {
                JavaObject javaObject = (JavaObject)args[0].toValue(ObjectMemory.class).value;
                this.field.set(javaObject.object, MemoryUtils.fromMemory(args[1], this.field.getType()));
            }
        }
        catch (IllegalAccessException e) {
            JavaField.exception(env, e);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory isFinal(Environment env, Memory ... args) {
        return Modifier.isFinal(this.mod) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isStatic(Environment env, Memory ... args) {
        return Modifier.isStatic(this.mod) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPublic(Environment env, Memory ... args) {
        return Modifier.isPublic(this.mod) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isProtected(Environment env, Memory ... args) {
        return Modifier.isProtected(this.mod) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPrivate(Environment env, Memory ... args) {
        return Modifier.isPrivate(this.mod) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isTransient(Environment env, Memory ... args) {
        return Modifier.isTransient(this.mod) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isVolatile(Environment env, Memory ... args) {
        return Modifier.isVolatile(this.mod) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getDeclaringClass(Environment env, Memory ... args) {
        return new ObjectMemory(JavaClass.of(env, this.field.getDeclaringClass()));
    }

    @Reflection.Signature
    public Memory getModifiers(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.field.getModifiers());
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.field.getName());
    }

    public static JavaField of(Environment env, Field field) {
        JavaField javaField = new JavaField(env, env.fetchClass("php\\lang\\JavaField"));
        javaField.setField(field);
        return javaField;
    }
}

