/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.env.SplClassLoader;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ModuleEntity;

@Reflection.Name(value="php\\lang\\ClassLoader")
public abstract class WrapClassLoader
extends BaseObject {
    protected SplClassLoader splClassLoader;

    public WrapClassLoader(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() {
    }

    @Reflection.Signature
    public abstract boolean loadClass(Environment var1, String var2) throws Throwable;

    @Reflection.Signature
    public void register(Environment env, boolean prepend) {
        if (this.splClassLoader == null) {
            env.registerAutoloader(this._getSplClassLoader(env), prepend);
        } else {
            env.exception("ClassLoader is already registered", new Object[0]);
        }
    }

    @Reflection.Signature
    public void unregister(Environment env) {
        if (this.splClassLoader == null) {
            env.exception("ClassLoader is not registered", new Object[0]);
        }
        env.unRegisterAutoloader(this.splClassLoader);
        this.splClassLoader = null;
    }

    protected synchronized SplClassLoader _getSplClassLoader(Environment env) {
        if (this.splClassLoader == null) {
            ArrayMemory callback = new ArrayMemory();
            callback.add(this);
            callback.add("loadClass");
            Invoker invoker = Invoker.valueOf(env, null, callback);
            this.splClassLoader = new SplClassLoader(invoker, callback);
        }
        return this.splClassLoader;
    }

    @Reflection.Name(value="php\\util\\LauncherClassLoader")
    public static class WrapLauncherClassLoader
    extends WrapClassLoader {
        public WrapLauncherClassLoader(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        @Override
        @Reflection.Signature
        public boolean loadClass(Environment env, String className) throws Throwable {
            ModuleEntity entity;
            String file = className.replace('\\', '/');
            if (file.startsWith("\\") || file.startsWith("/")) {
                file = file.substring(1);
            }
            if ((entity = this.fetchClass(env, file + ".phb", true)) != null) {
                entity.include(env);
                return true;
            }
            entity = this.fetchClass(env, file + ".php", false);
            if (entity != null) {
                entity.include(env);
                return true;
            }
            return false;
        }

        protected ModuleEntity fetchClass(Environment env, String fileName, boolean compiled) throws Throwable {
            return env.getModuleManager().fetchModule("res://" + fileName, compiled);
        }
    }
}

