/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import php.runtime.Memory;
import php.runtime.env.CallStackItem;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.lang.IObject;

public class CallStack {
    protected static final int CALL_STACK_INIT_SIZE = 255;
    protected int callStackTop = 0;
    protected int maxCallStackTop = -1;
    protected CallStackItem[] callStack = new CallStackItem[255];
    protected final Environment env;

    public CallStack(Environment env) {
        this.env = env;
    }

    public int getTop() {
        return this.callStackTop;
    }

    public void push(CallStackItem stackItem) {
        if (this.callStackTop >= this.callStack.length) {
            CallStackItem[] newCallStack = new CallStackItem[this.callStack.length * 2];
            System.arraycopy(this.callStack, 0, newCallStack, 0, this.callStack.length);
            this.callStack = newCallStack;
        }
        this.callStack[this.callStackTop++] = stackItem;
        this.maxCallStackTop = this.callStackTop;
    }

    public void push(TraceInfo trace, IObject self, Memory[] args, String function, String clazz, String staticClazz) {
        if (this.callStackTop >= this.callStack.length) {
            CallStackItem[] newCallStack = new CallStackItem[this.callStack.length * 2];
            System.arraycopy(this.callStack, 0, newCallStack, 0, this.callStack.length);
            this.callStack = newCallStack;
        }
        if (this.callStackTop < this.maxCallStackTop) {
            this.callStack[this.callStackTop++].setParameters(trace, self, args, function, clazz, staticClazz);
        } else {
            this.callStack[this.callStackTop++] = new CallStackItem(trace, self, args, function, clazz, staticClazz);
        }
        this.maxCallStackTop = this.callStackTop;
    }

    public void push(IObject self, String method, Memory ... args) {
        this.push(null, self, args, method, self.getReflection().getName(), null);
    }

    public void push(TraceInfo trace, IObject self, String method, Memory ... args) {
        this.push(trace, self, args, method, self.getReflection().getName(), null);
    }

    public void pop() {
        try {
            this.callStack[--this.callStackTop].clear();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalThreadStateException();
        }
    }

    public CallStackItem peekCall(int depth) {
        if (this.callStackTop - depth > 0) {
            return this.callStack[this.callStackTop - depth - 1];
        }
        return null;
    }

    public CallStack getSnapshotAsCallStack() {
        CallStack stack = new CallStack(this.env);
        stack.callStack = new CallStackItem[this.callStack.length];
        System.arraycopy(this.getSnapshot(), 0, stack.callStack, 0, this.callStackTop);
        stack.callStackTop = this.callStackTop;
        stack.maxCallStackTop = this.maxCallStackTop;
        return stack;
    }

    public CallStackItem[] getSnapshot() {
        if (this.callStackTop < 0) {
            return new CallStackItem[0];
        }
        CallStackItem[] result = new CallStackItem[this.callStackTop];
        int i = 0;
        for (CallStackItem el : this.callStack) {
            if (i == this.callStackTop) break;
            result[i] = new CallStackItem(el);
            ++i;
        }
        return result;
    }

    public TraceInfo trace() {
        if (this.callStackTop <= 0) {
            return TraceInfo.UNKNOWN;
        }
        return this.peekCall((int)0).trace;
    }

    public TraceInfo trace(int systemOffsetStackTrace) {
        return new TraceInfo(Thread.currentThread().getStackTrace()[systemOffsetStackTrace]);
    }
}

