/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.common.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import php.runtime.common.collections.map.AbstractHashedMap;

public class CaseInsensitiveMap<V>
extends AbstractHashedMap<String, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7074655917369299456L;

    public CaseInsensitiveMap() {
        super(16, 0.75f, 12);
    }

    public CaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveMap(Map<? extends String, ? extends V> map) {
        super(map);
    }

    protected String convertKey(String key) {
        if (key != null) {
            return key.toLowerCase();
        }
        return null;
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof String)) {
            return super.get(key);
        }
        return super.get(this.convertKey((String)key));
    }

    @Override
    public V put(String s, V v) {
        return super.put(this.convertKey(s), v);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.doWriteObject(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.doReadObject(in);
    }
}

