/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.common;

import java.util.Map;
import php.runtime.common.collections.map.HashedMap;

public enum HintType {
    ANY,
    STRING,
    INT,
    DOUBLE,
    NUMBER,
    BOOLEAN,
    SCALAR,
    ARRAY,
    OBJECT,
    CALLABLE,
    VARARG,
    TRAVERSABLE;

    private static final Map<String, HintType> values;

    public String toString() {
        switch (this) {
            case ARRAY: {
                return "array";
            }
            case INT: {
                return "int";
            }
            case DOUBLE: {
                return "double";
            }
            case NUMBER: {
                return "number";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case SCALAR: {
                return "scalar";
            }
            case CALLABLE: {
                return "callable";
            }
            case STRING: {
                return "string";
            }
            case OBJECT: {
                return "object";
            }
            case VARARG: {
                return "...";
            }
            case TRAVERSABLE: {
                return "traversable";
            }
        }
        return "";
    }

    public static HintType of(String code) {
        return values.get(code);
    }

    static {
        values = new HashedMap<String, HintType>();
        for (HintType e : HintType.values()) {
            values.put(e.toString(), e);
        }
        values.put("integer", INT);
        values.put("float", DOUBLE);
        values.put("bool", BOOLEAN);
    }
}

