/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.tray.animations;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;
import org.develnext.jphp.ext.javafx.support.tray.animations.AnimationType;
import org.develnext.jphp.ext.javafx.support.tray.animations.TrayAnimation;
import org.develnext.jphp.ext.javafx.support.tray.models.CustomStage;

public class FadeAnimation
implements TrayAnimation {
    private final Timeline showAnimation;
    private final Timeline dismissAnimation;
    private final SequentialTransition sq;
    private final CustomStage stage;
    private boolean trayIsShowing;

    public FadeAnimation(CustomStage customStage) {
        this.stage = customStage;
        this.showAnimation = this.setupShowAnimation();
        this.dismissAnimation = this.setupDismissAnimation();
        this.sq = new SequentialTransition(new Animation[]{this.setupShowAnimation(), this.setupDismissAnimation()});
    }

    private Timeline setupShowAnimation() {
        Timeline tl = new Timeline();
        KeyValue kvOpacity = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)0.0);
        KeyFrame frame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvOpacity});
        KeyValue kvOpacity2 = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)1.0);
        KeyFrame frame2 = new KeyFrame(Duration.millis((double)3000.0), new KeyValue[]{kvOpacity2});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{frame1, frame2});
        tl.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FadeAnimation.this.trayIsShowing = true;
            }
        });
        return tl;
    }

    private Timeline setupDismissAnimation() {
        Timeline tl = new Timeline();
        KeyValue kv1 = new KeyValue((WritableValue)this.stage.opacityProperty(), (Object)0.0);
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{kv1});
        tl.getKeyFrames().addAll((Object[])new KeyFrame[]{kf1});
        tl.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FadeAnimation.this.trayIsShowing = false;
                FadeAnimation.this.stage.hide();
                FadeAnimation.this.stage.setLocation(FadeAnimation.this.stage.getLocation());
            }
        });
        return tl;
    }

    @Override
    public AnimationType getAnimationType() {
        return AnimationType.FADE;
    }

    @Override
    public void setOnFinished(EventHandler<ActionEvent> onFinished) {
        this.sq.setOnFinished(onFinished);
    }

    @Override
    public void playSequential(Duration dismissDelay) {
        ((Animation)this.sq.getChildren().get(1)).setDelay(dismissDelay);
        this.sq.play();
    }

    @Override
    public void playShowAnimation() {
        this.showAnimation.play();
    }

    @Override
    public void playDismissAnimation() {
        this.dismissAnimation.play();
    }

    @Override
    public boolean isShowing() {
        return this.trayIsShowing;
    }
}

