/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control.tabpane.skin;

import com.sun.javafx.scene.control.skin.TabPaneSkin;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import org.develnext.jphp.ext.javafx.support.control.tabpane.DndTabPaneFactory;

public class DnDTabPaneSkin
extends TabPaneSkin
implements DndTabPaneFactory.DragSetup {
    private static Tab DRAGGED_TAB;
    public static final DataFormat TAB_MOVE;
    private Object noneEnum;
    private StyleableProperty<Object> openAnimation;
    private StyleableProperty<Object> closeAnimation;
    private Function<Tab, Boolean> startFunction;
    private Consumer<Tab> dragFinishedConsumer;
    private Consumer<DndTabPaneFactory.FeedbackData> feedbackConsumer;
    private Consumer<DndTabPaneFactory.DroppedData> dropConsumer;
    private Function<Tab, String> clipboardDataFunction;

    public DnDTabPaneSkin(TabPane tabPane) {
        super(tabPane);
        this.hookTabFolderSkin();
    }

    private void hookTabFolderSkin() {
        block5: {
            try {
                Field f_tabHeaderArea = TabPaneSkin.class.getDeclaredField("tabHeaderArea");
                f_tabHeaderArea.setAccessible(true);
                StackPane tabHeaderArea = (StackPane)f_tabHeaderArea.get(this);
                tabHeaderArea.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

                    public void handle(DragEvent e) {
                        e.consume();
                    }
                });
                Field f_headersRegion = tabHeaderArea.getClass().getDeclaredField("headersRegion");
                f_headersRegion.setAccessible(true);
                StackPane headersRegion = (StackPane)f_headersRegion.get(tabHeaderArea);
                EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        DnDTabPaneSkin.this.tabPane_handleDragStart(event);
                    }
                };
                EventHandler<DragEvent> handlerFinished = new EventHandler<DragEvent>(){

                    public void handle(DragEvent event) {
                        DnDTabPaneSkin.this.tabPane_handleDragDone(event);
                    }
                };
                for (Node tabHeaderSkin : headersRegion.getChildren()) {
                    tabHeaderSkin.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)handler);
                    tabHeaderSkin.addEventHandler(DragEvent.DRAG_DONE, (EventHandler)handlerFinished);
                }
                headersRegion.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>((EventHandler)handler, (EventHandler)handlerFinished){
                    final /* synthetic */ EventHandler val$handler;
                    final /* synthetic */ EventHandler val$handlerFinished;
                    {
                        this.val$handler = eventHandler;
                        this.val$handlerFinished = eventHandler2;
                    }

                    public void onChanged(ListChangeListener.Change<? extends Node> change) {
                        while (change.next()) {
                            if (change.wasRemoved()) {
                                for (Node node : change.getRemoved()) {
                                    node.removeEventHandler(MouseEvent.DRAG_DETECTED, this.val$handler);
                                }
                                for (Node node : change.getRemoved()) {
                                    node.removeEventHandler(DragEvent.DRAG_DONE, this.val$handlerFinished);
                                }
                            }
                            if (!change.wasAdded()) continue;
                            for (Node node : change.getAddedSubList()) {
                                node.addEventHandler(MouseEvent.DRAG_DETECTED, this.val$handler);
                            }
                            for (Node node : change.getAddedSubList()) {
                                node.addEventHandler(DragEvent.DRAG_DONE, this.val$handlerFinished);
                            }
                        }
                    }
                });
                tabHeaderArea.addEventHandler(DragEvent.DRAG_OVER, (EventHandler)new EventHandler<DragEvent>((Pane)tabHeaderArea, (Pane)headersRegion){
                    final /* synthetic */ Pane val$tabHeaderArea;
                    final /* synthetic */ Pane val$headersRegion;
                    {
                        this.val$tabHeaderArea = pane;
                        this.val$headersRegion = pane2;
                    }

                    public void handle(DragEvent e) {
                        DnDTabPaneSkin.this.tabPane_handleDragOver(this.val$tabHeaderArea, this.val$headersRegion, e);
                    }
                });
                tabHeaderArea.addEventHandler(DragEvent.DRAG_DROPPED, (EventHandler)new EventHandler<DragEvent>((Pane)tabHeaderArea, (Pane)headersRegion){
                    final /* synthetic */ Pane val$tabHeaderArea;
                    final /* synthetic */ Pane val$headersRegion;
                    {
                        this.val$tabHeaderArea = pane;
                        this.val$headersRegion = pane2;
                    }

                    public void handle(DragEvent e) {
                        DnDTabPaneSkin.this.tabPane_handleDragDropped(this.val$tabHeaderArea, this.val$headersRegion, e);
                    }
                });
                tabHeaderArea.addEventHandler(DragEvent.DRAG_EXITED, (EventHandler)new EventHandler<DragEvent>(){

                    public void handle(DragEvent event) {
                        DnDTabPaneSkin.this.tabPane_handleDragDone(event);
                    }
                });
                Field field = TabPaneSkin.class.getDeclaredField("openTabAnimation");
                field.setAccessible(true);
                this.openAnimation = (StyleableProperty)field.get(this);
                field = TabPaneSkin.class.getDeclaredField("closeTabAnimation");
                field.setAccessible(true);
                this.closeAnimation = (StyleableProperty)field.get(this);
                for (Class<?> cl : this.getClass().getDeclaredClasses()) {
                    if (!"TabAnimation".equals(cl.getSimpleName())) continue;
                    for (Enum enumConstant : (Enum[])cl.getEnumConstants()) {
                        if (!"NONE".equals(enumConstant.name())) continue;
                        this.noneEnum = enumConstant;
                        break block5;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    void tabPane_handleDragStart(MouseEvent event) {
        try {
            Field f_tab = event.getSource().getClass().getDeclaredField("tab");
            f_tab.setAccessible(true);
            Tab t = (Tab)f_tab.get(event.getSource());
            if (t != null && this.efx_canStartDrag(t)) {
                DRAGGED_TAB = t;
                Node node = (Node)event.getSource();
                Dragboard db = node.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                WritableImage snapShot = node.snapshot(new SnapshotParameters(), null);
                PixelReader reader = snapShot.getPixelReader();
                int padX = 10;
                int padY = 10;
                int width = (int)snapShot.getWidth();
                int height = (int)snapShot.getHeight();
                WritableImage image = new WritableImage(width + padX, height + padY);
                PixelWriter writer = image.getPixelWriter();
                int v = 0;
                for (int h = 0; h < width + padX; ++h) {
                    for (v = 0; v < height + padY; ++v) {
                        if (h >= padX && h <= width + padX && v >= padY && v <= height + padY) {
                            writer.setColor(h, v, reader.getColor(h - padX, v - padY));
                            continue;
                        }
                        writer.setColor(h, v, Color.TRANSPARENT);
                    }
                }
                db.setDragView((Image)image, image.getWidth(), image.getHeight() * -1.0);
                ClipboardContent content = new ClipboardContent();
                String data = this.efx_getClipboardContent(t);
                if (data != null) {
                    content.put((Object)TAB_MOVE, (Object)data);
                }
                db.setContent((Map)content);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void tabPane_handleDragOver(Pane tabHeaderArea, Pane headersRegion, DragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        event.consume();
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Object referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            try {
                int idx;
                Field field = referenceNode.getClass().getDeclaredField("tab");
                field.setAccessible(true);
                Tab tab = (Tab)field.get(referenceNode);
                boolean noMove = false;
                if (tab == draggedTab) {
                    noMove = true;
                } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                    idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                    if (idx > 0 && ((TabPane)this.getSkinnable()).getTabs().get(idx - 1) == draggedTab) {
                        noMove = true;
                    }
                } else {
                    idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                    if (idx + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(idx + 1) == draggedTab) {
                        noMove = true;
                    }
                }
                if (noMove) {
                    this.efx_dragFeedback(draggedTab, null, null, DndTabPaneFactory.DropType.NONE);
                    return;
                }
                Bounds b = referenceNode.getBoundsInLocal();
                b = referenceNode.localToScene(b);
                b = ((TabPane)this.getSkinnable()).sceneToLocal(b);
                this.efx_dragFeedback(draggedTab, tab, b, type);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        } else {
            this.efx_dragFeedback(draggedTab, null, null, DndTabPaneFactory.DropType.NONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tabPane_handleDragDropped(Pane tabHeaderArea, Pane headersRegion, DragEvent event) {
        Tab draggedTab = DRAGGED_TAB;
        if (draggedTab == null) {
            return;
        }
        double x = event.getX() - headersRegion.getBoundsInParent().getMinX();
        Object referenceNode = null;
        DndTabPaneFactory.DropType type = DndTabPaneFactory.DropType.AFTER;
        for (Node n : headersRegion.getChildren()) {
            Bounds b = n.getBoundsInParent();
            if (!(b.getMaxX() > x)) continue;
            if (b.getMinX() + b.getWidth() / 2.0 > x) {
                referenceNode = n;
                type = DndTabPaneFactory.DropType.BEFORE;
                break;
            }
            referenceNode = n;
            type = DndTabPaneFactory.DropType.AFTER;
            break;
        }
        if (referenceNode == null && headersRegion.getChildren().size() > 0) {
            referenceNode = (Node)headersRegion.getChildren().get(headersRegion.getChildren().size() - 1);
            type = DndTabPaneFactory.DropType.AFTER;
        }
        if (referenceNode != null) {
            block18: {
                try {
                    int idx;
                    Field field = referenceNode.getClass().getDeclaredField("tab");
                    field.setAccessible(true);
                    Tab tab = (Tab)field.get(referenceNode);
                    boolean noMove = false;
                    if (tab == null) {
                        event.setDropCompleted(false);
                        return;
                    }
                    if (tab == draggedTab) {
                        noMove = true;
                    } else if (type == DndTabPaneFactory.DropType.BEFORE) {
                        idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                        if (idx > 0 && ((TabPane)this.getSkinnable()).getTabs().get(idx - 1) == draggedTab) {
                            noMove = true;
                        }
                    } else {
                        idx = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                        if (idx + 1 < ((TabPane)this.getSkinnable()).getTabs().size() && ((TabPane)this.getSkinnable()).getTabs().get(idx + 1) == draggedTab) {
                            noMove = true;
                        }
                    }
                    if (!noMove) {
                        StyleOrigin openOrigin = this.openAnimation.getStyleOrigin();
                        StyleOrigin closeOrigin = this.closeAnimation.getStyleOrigin();
                        Object openValue = this.openAnimation.getValue();
                        Object closeValue = this.closeAnimation.getValue();
                        try {
                            this.openAnimation.setValue(this.noneEnum);
                            this.closeAnimation.setValue(this.noneEnum);
                            this.efx_dropped(draggedTab, tab, type);
                            event.setDropCompleted(true);
                            break block18;
                        }
                        finally {
                            this.openAnimation.applyStyle(openOrigin, openValue);
                            this.closeAnimation.applyStyle(closeOrigin, closeValue);
                        }
                    }
                    event.setDropCompleted(false);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            event.consume();
        }
    }

    void tabPane_handleDragDone(DragEvent event) {
        Tab tab = DRAGGED_TAB;
        if (tab == null) {
            return;
        }
        this.efx_dragFinished(tab);
    }

    @Override
    public void setClipboardDataFunction(Function<Tab, String> clipboardDataFunction) {
        this.clipboardDataFunction = clipboardDataFunction;
    }

    @Override
    public void setStartFunction(Function<Tab, Boolean> startFunction) {
        this.startFunction = startFunction;
    }

    @Override
    public void setDragFinishedConsumer(Consumer<Tab> dragFinishedConsumer) {
        this.dragFinishedConsumer = dragFinishedConsumer;
    }

    @Override
    public void setFeedbackConsumer(Consumer<DndTabPaneFactory.FeedbackData> feedbackConsumer) {
        this.feedbackConsumer = feedbackConsumer;
    }

    @Override
    public void setDropConsumer(Consumer<DndTabPaneFactory.DroppedData> dropConsumer) {
        this.dropConsumer = dropConsumer;
    }

    private boolean efx_canStartDrag(Tab tab) {
        if (this.startFunction != null) {
            return this.startFunction.apply(tab);
        }
        return true;
    }

    private void efx_dragFeedback(Tab draggedTab, Tab targetTab, Bounds bounds, DndTabPaneFactory.DropType dropType) {
        if (this.feedbackConsumer != null) {
            this.feedbackConsumer.accept(new DndTabPaneFactory.FeedbackData(draggedTab, targetTab, bounds, dropType));
        }
    }

    private void efx_dropped(Tab draggedTab, Tab targetTab, DndTabPaneFactory.DropType dropType) {
        if (this.dropConsumer != null) {
            this.dropConsumer.accept(new DndTabPaneFactory.DroppedData(draggedTab, targetTab, dropType));
        }
    }

    private void efx_dragFinished(Tab tab) {
        if (this.dragFinishedConsumer != null) {
            this.dragFinishedConsumer.accept(tab);
        }
    }

    private String efx_getClipboardContent(Tab t) {
        if (this.clipboardDataFunction != null) {
            return this.clipboardDataFunction.apply(t);
        }
        return System.identityHashCode(t) + "";
    }

    static {
        TAB_MOVE = new DataFormat(new String[]{"DnDTabPane:tabMove"});
    }
}

