/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TextField;

public class MaskTextField
extends TextField {
    public static final char MASK_DIGIT = 'D';
    public static final char MASK_DIG_OR_CHAR = 'W';
    public static final char MASK_CHARACTER = 'A';
    public static final char WHAT_MASK_CHAR = '#';
    public static final char WHAT_MASK_NO_CHAR = '-';
    public static final char PLACEHOLDER_CHAR_DEFAULT = '_';
    private List<Position> objectMask = new ArrayList<Position>();
    private StringProperty plainText;
    private StringProperty mask;
    private StringProperty whatMask;
    private StringProperty placeholder;

    public MaskTextField() {
    }

    public MaskTextField(String text) {
        super(text);
    }

    public final String getPlainText() {
        return (String)this.plainTextProperty().get();
    }

    public final void setPlainText(String value) {
        this.plainTextProperty().set((Object)value);
        this.updateShowingField();
    }

    public final StringProperty plainTextProperty() {
        if (this.plainText == null) {
            this.plainText = new SimpleStringProperty((Object)this, "plainText", "");
        }
        return this.plainText;
    }

    public final String getMask() {
        return (String)this.maskProperty().get();
    }

    public final void setMask(String value) {
        this.maskProperty().set((Object)value);
        this.rebuildObjectMask();
        this.updateShowingField();
    }

    public final StringProperty maskProperty() {
        if (this.mask == null) {
            this.mask = new SimpleStringProperty((Object)this, "mask");
        }
        return this.mask;
    }

    public final String getWhatMask() {
        return (String)this.whatMaskProperty().get();
    }

    public final void setWhatMask(String value) {
        this.whatMaskProperty().set((Object)value);
        this.rebuildObjectMask();
        this.updateShowingField();
    }

    public final StringProperty whatMaskProperty() {
        if (this.whatMask == null) {
            this.whatMask = new SimpleStringProperty((Object)this, "whatMask");
        }
        return this.whatMask;
    }

    public final String getPlaceholder() {
        return (String)this.placeholderProperty().get();
    }

    public final void setPlaceholder(String value) {
        this.placeholderProperty().set((Object)value);
        this.rebuildObjectMask();
        this.updateShowingField();
    }

    public final StringProperty placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleStringProperty((Object)this, "placeholder");
        }
        return this.placeholder;
    }

    private void rebuildObjectMask() {
        this.objectMask = new ArrayList<Position>();
        for (int i = 0; i < this.getMask().length(); ++i) {
            char m = this.getMask().charAt(i);
            char w = '#';
            char p = '_';
            if (this.getWhatMask() != null && i < this.getWhatMask().length()) {
                if (this.getWhatMask().charAt(i) != '#') {
                    w = '-';
                }
            } else if (m != 'A' && m != 'W' && m != 'D') {
                w = '-';
            }
            if (this.getPlaceholder() != null && i < this.getPlaceholder().length()) {
                p = this.getPlaceholder().charAt(i);
            }
            this.objectMask.add(new Position(m, w, p));
        }
    }

    private void updateShowingField() {
        int counterPlainCharInMask = 0;
        int lastPositionPlainCharInMask = 0;
        int firstPlaceholderInMask = -1;
        String textMask = "";
        String textPlain = this.getPlainText();
        for (int i = 0; i < this.objectMask.size(); ++i) {
            Position p = this.objectMask.get(i);
            if (p.isPlainCharacter()) {
                if (textPlain.length() > counterPlainCharInMask) {
                    char c = textPlain.charAt(counterPlainCharInMask);
                    while (!p.isCorrect(c) && (textPlain = textPlain.substring(0, counterPlainCharInMask) + textPlain.substring(counterPlainCharInMask + 1)).length() > counterPlainCharInMask) {
                        c = textPlain.charAt(counterPlainCharInMask);
                    }
                    textMask = textMask + c;
                    lastPositionPlainCharInMask = i;
                } else {
                    textMask = textMask + p.placeholder;
                    if (firstPlaceholderInMask == -1) {
                        firstPlaceholderInMask = i;
                    }
                }
                ++counterPlainCharInMask;
                continue;
            }
            textMask = textMask + p.mask;
        }
        this.setText(textMask);
        if (firstPlaceholderInMask == -1) {
            firstPlaceholderInMask = 0;
        }
        int caretPosition = textPlain.length() > 0 ? lastPositionPlainCharInMask + 1 : firstPlaceholderInMask;
        this.selectRange(caretPosition, caretPosition);
        if (textPlain.length() > counterPlainCharInMask) {
            textPlain = textPlain.substring(0, counterPlainCharInMask);
        }
        if (!textPlain.equals(this.getPlainText())) {
            this.setPlainText(textPlain);
        }
    }

    private int interpretMaskPositionInPlainPosition(int posMask) {
        int posPlain = 0;
        for (int i = 0; i < this.objectMask.size() && i < posMask; ++i) {
            Position p = this.objectMask.get(i);
            if (!p.isPlainCharacter()) continue;
            ++posPlain;
        }
        return posPlain;
    }

    public void replaceText(int start, int end, String text) {
        int plainStart = this.interpretMaskPositionInPlainPosition(start);
        int plainEnd = this.interpretMaskPositionInPlainPosition(end);
        String plainText1 = "";
        plainText1 = this.getPlainText().length() > plainStart ? this.getPlainText().substring(0, plainStart) : this.getPlainText();
        String plainText2 = "";
        plainText2 = this.getPlainText().length() > plainEnd ? this.getPlainText().substring(plainEnd) : "";
        this.setPlainText(plainText1 + text + plainText2);
    }

    private static class Position {
        public char mask;
        public char whatMask;
        public char placeholder;

        public Position(char mask, char whatMask, char placeholder) {
            this.mask = mask;
            this.placeholder = placeholder;
            this.whatMask = whatMask;
        }

        public boolean isPlainCharacter() {
            return this.whatMask == '#';
        }

        public boolean isCorrect(char c) {
            switch (this.mask) {
                case 'D': {
                    return Character.isDigit(c);
                }
                case 'A': {
                    return Character.isLetter(c);
                }
                case 'W': {
                    return Character.isLetter(c) || Character.isDigit(c);
                }
            }
            return false;
        }
    }
}

