/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumnBase;
import javafx.stage.Window;
import org.develnext.jphp.ext.javafx.support.EventProvider;
import org.develnext.jphp.ext.javafx.support.UserData;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;

public final class JavaFxUtils {
    public static ObservableValue findObservable(Object object, String property) {
        String name = property + "Property";
        Class<?> aClass = object.getClass();
        try {
            Method method;
            try {
                method = aClass.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                method = aClass.getDeclaredMethod(name, new Class[0]);
            }
            ReadOnlyProperty bindProperty = (ReadOnlyProperty)method.invoke(object, new Object[0]);
            return bindProperty;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to find the '" + property + "' property for watching, " + e.getClass().getSimpleName() + " " + e.getMessage());
        }
    }

    public static void on(Object target, String event, Invoker invoker) {
        JavaFxUtils.on(target, event, invoker, "general");
    }

    public static void on(Object target, String event, Invoker invoker, String group) {
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.on(target, event, group, invoker);
    }

    public static void off(Object target, String event, @Reflection.Nullable String group) {
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.off(target, event, group);
    }

    public static void off(Object target, String event) {
        JavaFxUtils.off(target, event, null);
    }

    public static <T extends Node> void trigger(T object, String event, Event e) {
        EventProvider eventProvider = EventProvider.get(object, event);
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.trigger(object, event, e);
    }

    protected static Memory _data(Object userData, String name) {
        if (userData instanceof UserData) {
            return ((UserData)userData).get(name);
        }
        return Memory.NULL;
    }

    public static Memory data(Node object, String name) {
        return JavaFxUtils._data(object.getUserData(), name);
    }

    public static Memory data(Window object, String name) {
        return JavaFxUtils._data(object.getUserData(), name);
    }

    public static Memory data(Tab object, String name) {
        return JavaFxUtils._data(object.getUserData(), name);
    }

    public static Memory data(TableColumnBase object, String name) {
        return JavaFxUtils._data(object.getUserData(), name);
    }

    public static Memory data(Environment env, Node object, String name, Memory value) {
        Object userData = object.getUserData();
        if (!(userData instanceof UserData)) {
            userData = new UserData(Memory.wrap(env, userData));
            object.setUserData(userData);
        }
        return ((UserData)userData).set(name, value);
    }

    public static Memory data(Environment env, Tab object, String name, Memory value) {
        Object userData = object.getUserData();
        if (!(userData instanceof UserData)) {
            userData = new UserData(Memory.wrap(env, userData));
            object.setUserData(userData);
        }
        return ((UserData)userData).set(name, value);
    }

    public static Memory data(Environment env, TableColumnBase object, String name, Memory value) {
        Object userData = object.getUserData();
        if (!(userData instanceof UserData)) {
            userData = new UserData(Memory.wrap(env, userData));
            object.setUserData(userData);
        }
        return ((UserData)userData).set(name, value);
    }

    public static Memory data(Environment env, Window object, String name, Memory value) {
        Object userData = object.getUserData();
        if (!(userData instanceof UserData)) {
            userData = new UserData(Memory.wrap(env, userData));
            object.setUserData(userData);
        }
        return ((UserData)userData).set(name, value);
    }

    public static Memory userData(Environment env, Object userData) {
        if (userData == null) {
            return null;
        }
        if (userData instanceof UserData) {
            return ((UserData)userData).getValue();
        }
        return Memory.wrap(env, userData);
    }
}

