/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.develnext.jphp.ext.javafx.classes.text.UXFont;

public class ImageViewEx
extends Canvas
implements Styleable {
    private final GraphicsContext g2;
    protected Image image;
    protected Image originImage;
    protected Image hoverImage;
    protected Image clickImage;
    protected boolean autoSize;
    protected boolean stretch;
    protected boolean smartStretch;
    protected boolean centered;
    protected boolean proportional;
    protected boolean mosaic;
    protected double mosaicGap = 0.0;
    private boolean _entered = false;
    protected Paint background = null;
    protected Font font = new Font("System", 12.0);
    protected Paint textFill = Color.BLACK;
    protected String text;

    public ImageViewEx() {
        this.g2 = this.getGraphicsContext2D();
        this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number t1) {
                ImageViewEx.this.update();
            }
        });
        this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number t1) {
                ImageViewEx.this.update();
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ImageViewEx.this._entered = true;
                if (ImageViewEx.this.hoverImage != null) {
                    ImageViewEx.this.image = ImageViewEx.this.hoverImage;
                    ImageViewEx.this.update();
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ImageViewEx.this.image = ImageViewEx.this.originImage;
                ImageViewEx.this._entered = false;
                ImageViewEx.this.update();
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (ImageViewEx.this.clickImage != null) {
                    ImageViewEx.this.image = ImageViewEx.this.clickImage;
                    ImageViewEx.this.update();
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (ImageViewEx.this._entered && ImageViewEx.this.hoverImage != null) {
                    ImageViewEx.this.image = ImageViewEx.this.hoverImage;
                    ImageViewEx.this.update();
                } else if (ImageViewEx.this.image != ImageViewEx.this.originImage) {
                    ImageViewEx.this.image = ImageViewEx.this.originImage;
                    ImageViewEx.this.update();
                }
            }
        });
    }

    public Image getImage() {
        return this.originImage;
    }

    public void setImage(Image image) {
        this.image = image;
        this.originImage = image;
        this.update();
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public void setHoverImage(Image hoverImage) {
        this.hoverImage = hoverImage;
    }

    public Image getClickImage() {
        return this.clickImage;
    }

    public void setClickImage(Image clickImage) {
        this.clickImage = clickImage;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        this.update();
    }

    public boolean isStretch() {
        return this.stretch;
    }

    public void setStretch(boolean stretch) {
        this.stretch = stretch;
        this.update();
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
        this.update();
    }

    public boolean isMosaic() {
        return this.mosaic;
    }

    public void setMosaic(boolean mosaic) {
        this.mosaic = mosaic;
        this.update();
    }

    public double getMosaicGap() {
        return this.mosaicGap;
    }

    public void setMosaicGap(double mosaicGap) {
        this.mosaicGap = mosaicGap;
        this.update();
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setProportional(boolean proportional) {
        this.proportional = proportional;
        this.update();
    }

    public boolean isPreserveRatio() {
        return this.isProportional();
    }

    public void setPreserveRatio(boolean proportional) {
        this.setProportional(proportional);
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint background) {
        this.background = background;
        this.update();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.update();
    }

    public Paint getTextFill() {
        return this.textFill;
    }

    public void setTextFill(Paint textFill) {
        this.textFill = textFill;
        this.update();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.update();
    }

    public double prefWidth(double height) {
        return this.getWidth();
    }

    public double prefHeight(double width) {
        return this.getHeight();
    }

    public boolean isResizable() {
        return !this.autoSize;
    }

    public void resize(double v, double v1) {
        this.setWidth(v);
        this.setHeight(v1);
    }

    protected void update() {
        if (this.autoSize) {
            this.setWidth(this.image == null ? 0.0 : this.image.getWidth());
            this.setHeight(this.image == null ? 0.0 : this.image.getHeight());
        }
        this.g2.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (this.background != null) {
            this.g2.setFill(this.background);
            this.g2.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        if (this.image != null) {
            double x = 0.0;
            double y = 0.0;
            double w = this.image.getWidth();
            double h = this.image.getHeight();
            if (this.isMosaic()) {
                int startY;
                int horCount = (int)Math.ceil(this.getWidth() / w + this.mosaicGap);
                int verCount = (int)Math.ceil(this.getHeight() / h + this.mosaicGap);
                int startX = 0;
                for (int i = startY = 0; i < verCount; ++i) {
                    for (int j = startX; j < horCount; ++j) {
                        this.g2.drawImage(this.image, (double)j * w + (double)j * this.mosaicGap, (double)i * h + (double)i * this.mosaicGap, w, h);
                    }
                }
            } else {
                if (this.isStretch() && (!this.smartStretch || w > this.getWidth() || h > this.getHeight())) {
                    if (this.isProportional()) {
                        double ratio = Math.min(this.getWidth() / w, this.getHeight() / h);
                        w = (int)(w * ratio);
                        h = (int)(h * ratio);
                    } else {
                        w = this.getWidth();
                        h = this.getHeight();
                    }
                }
                if (this.isCentered()) {
                    x = Math.round(this.getWidth() / 2.0 - w / 2.0);
                    y = Math.round(this.getHeight() / 2.0 - h / 2.0);
                }
                this.g2.drawImage(this.image, x, y, w, h);
            }
        }
        if (this.text != null && !this.text.trim().isEmpty()) {
            this.g2.setFont(this.font);
            this.g2.setFill(this.textFill);
            double fWidth = UXFont.calculateTextWidth(this.text, this.font);
            double fHeight = UXFont.getLineHeight(this.font);
            this.g2.fillText(this.text, this.getWidth() / 2.0 - fWidth / 2.0, this.getHeight() / 2.0 + fHeight / 4.0, this.getWidth());
        }
    }

    public boolean isSmartStretch() {
        return this.smartStretch;
    }

    public void setSmartStretch(boolean smartStretch) {
        this.smartStretch = smartStretch;
        this.update();
    }
}

