/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support;

import java.util.HashMap;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventHandler;
import org.develnext.jphp.ext.javafx.support.ScriptEventHandler;
import php.runtime.invoke.Invoker;

public abstract class EventProvider<T> {
    protected static final Map<Class<?>, EventProvider> eventProviderMap = new HashMap();
    protected Map<String, Handler> handlers = new HashMap<String, Handler>();

    public abstract Class<T> getTargetClass();

    public void trigger(T target, String code, Event e) {
        EventHandler eventHandler;
        Handler handler = this.handlers.get(code.toLowerCase());
        if (handler != null && (eventHandler = handler.get(target)) != null) {
            eventHandler.handle(e);
        }
    }

    public void on(T target, String code, String group, Invoker invoker) {
        Handler handler = this.handlers.get(code.toLowerCase());
        if (handler != null) {
            ScriptEventHandler eventHandler = handler.get(target);
            if (!(eventHandler instanceof ScriptEventHandler)) {
                eventHandler = new ScriptEventHandler(invoker.getEnvironment());
                handler.set(target, eventHandler);
            }
            ScriptEventHandler scriptEventHandler = eventHandler;
            scriptEventHandler.set(invoker, group);
        }
    }

    public void off(T target, String code, String group) {
        Handler handler = this.handlers.get(code.toLowerCase());
        if (handler != null) {
            if (group == null) {
                handler.set(target, null);
            } else {
                EventHandler eventHandler = handler.get(target);
                if (eventHandler != null && eventHandler instanceof ScriptEventHandler) {
                    ((ScriptEventHandler)eventHandler).unset(group);
                }
            }
        }
    }

    protected void setHandler(String event, Handler handler) {
        this.handlers.put(event.toLowerCase(), handler);
    }

    public boolean hasHandler(String event) {
        return this.handlers.containsKey(event.toLowerCase());
    }

    public static void register(EventProvider eventProvider) {
        eventProviderMap.put(eventProvider.getTargetClass(), eventProvider);
    }

    public static EventProvider get(Object object, String event) {
        if (object == null) {
            return null;
        }
        for (Class<?> cls = object.getClass(); cls != null; cls = cls.getSuperclass()) {
            EventProvider eventProvider = eventProviderMap.get(cls);
            if (eventProvider == null || !eventProvider.hasHandler(event)) continue;
            return eventProvider;
        }
        return null;
    }

    protected abstract class Handler {
        protected Handler() {
        }

        public abstract void set(T var1, EventHandler var2);

        public abstract EventHandler get(T var1);
    }
}

