/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXMediaPlayer")
public class UXMediaPlayer
extends BaseWrapper<MediaPlayer> {
    public UXMediaPlayer(Environment env, MediaPlayer wrappedObject) {
        super(env, wrappedObject);
    }

    public UXMediaPlayer(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct(Media media) {
        this.__wrappedObject = new MediaPlayer(media);
    }

    @Reflection.Getter
    public Duration getCurrentTime() {
        return ((MediaPlayer)this.getWrappedObject()).getCurrentTime();
    }

    @Reflection.Setter
    public void setCurrentTime(Duration duration) {
        ((MediaPlayer)this.getWrappedObject()).seek(duration);
    }

    @Reflection.Getter
    public long getCurrentTimeAsPercent() {
        Duration duration = ((MediaPlayer)this.getWrappedObject()).getMedia().getDuration();
        Duration currentTime = ((MediaPlayer)this.getWrappedObject()).getCurrentTime();
        return Math.round(currentTime.toMillis() * 100.0 / duration.toMillis());
    }

    @Reflection.Setter
    public void setCurrentTimeAsPercent(long percent) {
        if (percent > 100L) {
            percent = 100L;
        }
        Duration duration = ((MediaPlayer)this.getWrappedObject()).getMedia().getDuration();
        ((MediaPlayer)this.getWrappedObject()).seek(Duration.millis((double)Math.round(duration.toMillis() * (double)percent / 100.0)));
    }

    static interface WrappedInterface {
        @Reflection.Property
        public double balance();

        @Reflection.Property
        public double rate();

        @Reflection.Property
        public double volume();

        @Reflection.Property
        public boolean mute();

        @Reflection.Property
        public MediaPlayer.Status status();

        @Reflection.Property
        public double currentRate();

        @Reflection.Property
        public int currentCount();

        @Reflection.Property
        public int cycleCount();

        public void seek(Duration var1);

        public void play();

        public void pause();

        public void stop();
    }
}

