/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.awt.Window;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.control.Button;
import javafx.stage.Stage;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.CustomErrorException;
import php.runtime.ext.core.classes.stream.ResourceStream;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="php\\gui\\UXApplication")
public class UXApplication
extends BaseWrapper<Application> {
    private static Invoker onStart;
    private static boolean shutdown;

    public UXApplication(Environment env, Application wrappedObject) {
        super(env, wrappedObject);
    }

    public UXApplication(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public static String getPid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        String pid = jvmName.substring(0, index);
        return pid;
    }

    @Reflection.Signature
    public static boolean isShutdown() {
        return shutdown;
    }

    @Reflection.Signature
    public static void setImplicitExit(boolean value) {
        Platform.setImplicitExit((boolean)value);
    }

    @Reflection.Signature
    public static boolean isImplicitExit() {
        return Platform.isImplicitExit();
    }

    @Reflection.Signature
    public static String getMacAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            if (ip == null) {
                return null;
            }
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                return null;
            }
            byte[] mac = network.getHardwareAddress();
            if (mac == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            return sb.toString();
        }
        catch (UnknownHostException e) {
            return null;
        }
        catch (SocketException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Reflection.Signature
    public static boolean isUiThread() {
        return Platform.isFxApplicationThread();
    }

    @Reflection.Signature
    public static void setTheme(final Memory value) {
        new JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (UXApplication.isShutdown()) {
                    return;
                }
                if (value.instanceOf(Stream.class)) {
                    if (value.instanceOf(ResourceStream.class)) {
                        Application.setUserAgentStylesheet((String)value.toObject(ResourceStream.class).getUrl().toExternalForm());
                    } else {
                        Application.setUserAgentStylesheet((String)value.toObject(Stream.class).getPath());
                    }
                } else {
                    Application.setUserAgentStylesheet((String)value.toString());
                }
            }
        });
    }

    @Reflection.Signature
    public static void runLater(final Invoker callback) {
        if (UXApplication.isShutdown()) {
            return;
        }
        new JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    callback.callNoThrow(new Memory[0]);
                }
                catch (Exception e) {
                    callback.getEnvironment().catchUncaught(e);
                }
            }
        });
    }

    @Reflection.Signature
    public static void shutdown() {
        Window[] windows;
        shutdown = true;
        Platform.exit();
        for (Window window : windows = Window.getWindows()) {
            window.dispose();
        }
    }

    @Reflection.Signature
    public static void launch(Invoker onStart) {
        Environment.addThreadSupport(onStart.getEnvironment());
        UXApplication.onStart = onStart;
        Application.launch(CustomApplication.class, (String[])new String[0]);
    }

    static {
        shutdown = false;
    }

    public static class CustomApplication
    extends Application {
        public void start(Stage stage) throws Exception {
            Environment.addThreadSupport(onStart.getEnvironment());
            Thread thread = Thread.currentThread();
            ClassLoader old = thread.getContextClassLoader();
            new Button();
            try {
                thread.setContextClassLoader(onStart.getEnvironment().scope.getClassLoader());
                onStart.callAny(stage);
            }
            catch (Exception throwable) {
                if (throwable instanceof CriticalException) {
                    throwable.printStackTrace();
                }
                if (throwable instanceof CustomErrorException) {
                    CustomErrorException error = (CustomErrorException)throwable;
                    onStart.getEnvironment().error(error.getType(), error.getMessage(), new Object[0]);
                } else {
                    onStart.getEnvironment().catchUncaught(throwable);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                thread.setContextClassLoader(old);
            }
        }

        public void stop() throws Exception {
            super.stop();
            shutdown = true;
        }
    }
}

