/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.stmt;

import java.util.List;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ArgumentStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;

public class MethodStmtToken
extends FunctionStmtToken {
    private boolean isAbstract;
    private boolean isFinal;
    private boolean isStatic;
    private ClassStmtToken clazz;

    public MethodStmtToken(TokenMeta meta) {
        super(meta);
    }

    public MethodStmtToken(FunctionStmtToken token) {
        this(token.getMeta());
        this.setArguments(token.arguments);
        this.setBody(token.body);
        this.setModifier(token.modifier);
        this.setName(token.name);
        this.setReturnReference(token.returnReference);
        this.setLocal(token.local);
        this.setDynamicLocal(token.dynamicLocal);
        this.setCallsExist(token.callsExist);
        this.setVarsExists(token.varsExists);
        this.setUses(token.uses);
        this.setDocComment(token.docComment);
        this.setGenerator(token.isGenerator);
        this.setId(token.id);
        this.setTypeInfo(token.getTypeInfo());
        this.setGeneratorId(token.generatorId);
        this.labels = token.labels;
        this.variables = token.variables;
        this.namespace = token.namespace;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    @Override
    public List<ArgumentStmtToken> getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(List<ArgumentStmtToken> arguments) {
        this.arguments = arguments;
    }

    public ClassStmtToken getClazz() {
        return this.clazz;
    }

    public void setClazz(ClassStmtToken clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean isInterfacable() {
        return this.body == null;
    }

    public static MethodStmtToken of(String name, ClassStmtToken clazz) {
        MethodStmtToken mToken = new MethodStmtToken(clazz.getMeta());
        mToken.setClazz(clazz);
        mToken.setName(new NameToken(TokenMeta.of(name, (Token)clazz)));
        mToken.setNamespace(null);
        return mToken;
    }
}

