/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr.value;

import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;

public class DoubleExprToken
extends ValueExprToken {
    private double value;

    public DoubleExprToken(TokenMeta meta) {
        super(meta, TokenType.T_DNUMBER);
        this.value = Double.parseDouble(meta.getWord());
    }

    public double getValue() {
        return this.value;
    }

    public boolean isZero() {
        return this.meta.getWord().matches("^0\\.[0]+$");
    }

    public boolean isOne() {
        return this.meta.getWord().matches("^1\\.[0]+$");
    }

    public boolean isFloat() {
        return this.value < 3.4028234663852886E38 && this.value > (double)1.4E-45f;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public Object toNumeric() {
        return this.value;
    }
}

