/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.manually.BodyGenerator;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.CatchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FinallyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TryStmtToken;

public class TryCatchGenerator
extends Generator<TryStmtToken> {
    public TryCatchGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    public void processCatch(CatchStmtToken result, ListIterator<Token> iterator) {
        Token next = this.nextToken(iterator);
        if (!this.isOpenedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, "(");
        }
        if (!((next = this.nextToken(iterator)) instanceof NameToken)) {
            this.unexpectedToken(next, (Object)TokenType.T_STRING);
        }
        FulledNameToken exception = this.analyzer.getRealName((NameToken)next);
        result.setException(exception);
        next = this.nextToken(iterator);
        if (!(next instanceof VariableExprToken)) {
            this.unexpectedToken(next, (Object)TokenType.T_VARIABLE);
        }
        VariableExprToken variable = (VariableExprToken)next;
        result.setVariable(variable);
        if (this.analyzer.getFunction() != null) {
            this.analyzer.getFunction().variable(variable).setUnstable(true);
        }
        this.analyzer.getScope().addVariable(variable);
        next = this.nextToken(iterator);
        if (!this.isClosedBrace(next, BraceExprToken.Kind.SIMPLE)) {
            this.unexpectedToken(next, ")");
        }
        Token body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), (ListIterator)iterator);
        result.setBody((BodyStmtToken)body);
    }

    protected void processFinally(TryStmtToken result, Token current, ListIterator<Token> iterator) {
        if (result.getFinally() != null) {
            this.unexpectedToken(current);
        }
        result.setFinally((BodyStmtToken)this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), (ListIterator)iterator));
        if (!iterator.hasNext()) {
            return;
        }
        current = iterator.next();
        if (current instanceof CatchStmtToken) {
            this.processCatches(result, current, iterator);
        } else {
            iterator.previous();
        }
    }

    protected void processCatches(TryStmtToken result, Token current, ListIterator<Token> iterator) {
        block3: {
            List<CatchStmtToken> catches = result.getCatches();
            do {
                CatchStmtToken _catch = (CatchStmtToken)current;
                this.processCatch(_catch, iterator);
                catches.add(_catch);
                if (!iterator.hasNext()) break block3;
            } while ((current = iterator.next()) instanceof CatchStmtToken);
            if (current instanceof FinallyStmtToken) {
                this.processFinally(result, current, iterator);
            } else {
                iterator.previous();
            }
        }
    }

    @Override
    public TryStmtToken getToken(Token current, ListIterator<Token> iterator) {
        if (current instanceof TryStmtToken) {
            TryStmtToken result = (TryStmtToken)current;
            this.analyzer.addScope(false);
            Token body = this.analyzer.generator(BodyGenerator.class).getToken(this.nextToken(iterator), (ListIterator)iterator);
            result.setBody((BodyStmtToken)body);
            Token next = this.nextToken(iterator);
            result.setCatches(new ArrayList<CatchStmtToken>());
            if (next instanceof CatchStmtToken) {
                this.processCatches(result, next, iterator);
            } else if (next instanceof FinallyStmtToken) {
                this.analyzer.getScope().setLevelForGoto(true);
                this.processFinally(result, next, iterator);
                this.analyzer.getScope().setLevelForGoto(false);
            } else {
                this.unexpectedToken(next, (Object)TokenType.T_CATCH);
            }
            result.setLocal(this.analyzer.removeScope().getVariables());
            return result;
        }
        return null;
    }
}

