/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ListIterator;
import org.develnext.jphp.core.common.Separator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.manually.SimpleExprGenerator;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.CommaToken;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;

public class ConstGenerator
extends Generator<ConstStmtToken> {
    public static final Class<? extends Token>[] valueTokens = new Class[]{ValueExprToken.class, OperatorExprToken.class};

    public ConstGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    @Override
    public ConstStmtToken getToken(Token current, ListIterator<Token> iterator) {
        if (current instanceof ConstStmtToken) {
            ConstStmtToken result = (ConstStmtToken)current;
            Token prev = null;
            if (this.analyzer.getClazz() == null) {
                result.setNamespace(this.analyzer.getNamespace());
            }
            while (true) {
                Token next;
                Token token = next = this.analyzer.getClazz() == null ? this.nextToken(iterator) : this.nextTokenSensitive(iterator, ClassStmtToken.class);
                if (next instanceof NameToken) {
                    Token token2;
                    if (next instanceof FulledNameToken && !((FulledNameToken)next).isProcessed(NamespaceUseStmtToken.UseType.CONSTANT)) {
                        this.unexpectedToken(next, (Object)TokenType.T_STRING);
                    }
                    if (!((token2 = this.nextToken(iterator)) instanceof AssignExprToken)) {
                        this.unexpectedToken(token2, "=");
                    }
                    ExprStmtToken value = this.analyzer.generator(SimpleExprGenerator.class).getToken(this.nextToken(iterator), iterator, Separator.COMMA_OR_SEMICOLON, null);
                    if (!this.isBreak(iterator.previous())) {
                        iterator.next();
                    }
                    if (value == null) {
                        this.unexpectedToken(iterator.previous());
                    }
                    result.add((NameToken)next, value);
                    continue;
                }
                if (next instanceof CommaToken) {
                    if (prev instanceof CommaToken) {
                        this.unexpectedToken(next);
                    }
                    prev = next;
                    continue;
                }
                if (this.isBreak(next)) break;
                this.unexpectedToken(next, (Object)TokenType.T_STRING);
            }
            return result;
        }
        return null;
    }
}

