/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import php.runtime.lang.Closure;
import php.runtime.loader.RuntimeClassLoader;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;

public class JVMStackTracer
implements Iterable<Item> {
    protected final RuntimeClassLoader classLoader;
    protected final List<Item> result;

    public JVMStackTracer(RuntimeClassLoader classLoader, StackTraceElement[] elements) {
        this.classLoader = classLoader;
        this.result = new ArrayList<Item>();
        for (StackTraceElement e : elements) {
            this.result.add(new Item(classLoader, e));
        }
    }

    @Override
    public Iterator<Item> iterator() {
        return this.result.iterator();
    }

    public static class Item {
        public final String fileName;
        public final int lineNumber;
        public final ModuleEntity module;
        public final ClassEntity clazz;
        public final MethodEntity method;
        public final FunctionEntity function;
        protected final StackTraceElement element;

        public Item(RuntimeClassLoader classLoader, StackTraceElement el) {
            this.element = el;
            this.fileName = el.getFileName();
            this.lineNumber = el.getLineNumber();
            String className = el.getClassName();
            FunctionEntity f_e = classLoader.getFunction(className);
            String realMethodName = null;
            if (el.getMethodName() != null) {
                realMethodName = el.getMethodName().indexOf(36) > -1 ? el.getMethodName().substring(0, el.getMethodName().indexOf(36)) : el.getMethodName();
                realMethodName = realMethodName.toLowerCase();
            }
            if (f_e != null) {
                this.function = f_e;
                this.module = f_e.getModule();
                this.clazz = null;
                this.method = null;
            } else {
                ClassEntity c_e = classLoader.getClass(className);
                if (c_e != null) {
                    this.clazz = c_e;
                    this.function = null;
                    this.method = c_e.findMethod(realMethodName);
                    this.module = c_e.getModule();
                } else {
                    this.module = classLoader.getModule(className);
                    this.clazz = null;
                    this.method = null;
                    this.function = null;
                }
            }
        }

        public boolean isSystem() {
            return this.element.getClassName().startsWith("sun.");
        }

        public boolean isInternal() {
            return this.function == null && this.clazz == null && this.module == null;
        }

        public String getSignature() {
            String result = this.function != null ? this.function.getName() : (this.clazz != null && this.method == null ? this.clazz.getName() + ".<init>" : (this.clazz != null && this.clazz.isInstanceOf(Closure.class) ? "<Closure>" : (this.clazz != null ? this.clazz.getName() + "." + this.method.getName() : (this.module != null ? "include " : this.element.getClassName() + "." + this.element.getMethodName()))));
            return result;
        }

        public String toString() {
            String result = this.getSignature();
            result = result + (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)"));
            return result;
        }
    }
}

