/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.output.serialization;

import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.lang.IObject;
import php.runtime.lang.spl.Serializable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

public class Deserializer {
    protected final Environment env;
    protected final TraceInfo trace;
    protected int pos;

    public Deserializer(Environment env, TraceInfo trace) {
        this.env = env;
        this.trace = trace;
    }

    protected Memory error(int offset, int length) {
        this.pos = -1;
        this.env.error(this.trace, ErrorType.E_NOTICE, "unserialize(): Error at offset %s of %s bytes", offset, length);
        return Memory.NULL;
    }

    private int readSize(String input, int pos) {
        int j;
        boolean done = false;
        int length = input.length();
        for (j = pos; j < length; ++j) {
            char ch = input.charAt(j);
            if (ch != ':') continue;
            done = true;
            break;
        }
        this.pos = j;
        if (!done) {
            return -1;
        }
        String what = input.substring(pos, j);
        try {
            return Integer.parseInt(what);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Memory read(String input) {
        return this.read(input, 0);
    }

    public Memory readString(String input, int offset, char endChar) {
        int i = offset;
        int length = input.length();
        int size = this.readSize(input, i);
        if (size == -1) {
            return this.error(i, length);
        }
        i = this.pos;
        if (++i < length && input.charAt(i) == '\"') {
            if (++i + size <= length) {
                String str = input.substring(i, i + size);
                if ((i += size) < length && input.charAt(i) == '\"') {
                    if (++i < length && input.charAt(i) == endChar) {
                        this.pos = i + 1;
                        return new StringMemory(str);
                    }
                    return this.error(i, length);
                }
                return this.error(i + 1, length);
            }
            return this.error(i, length);
        }
        return this.error(i, length);
    }

    public Memory readArray(String input, int offset) {
        int i = offset;
        int length = input.length();
        int size = this.readSize(input, i);
        if (size == -1) {
            this.error(i, length);
            return Memory.NULL;
        }
        i = this.pos;
        if (i >= length || input.charAt(i) != ':') {
            this.error(i, length);
            return Memory.NULL;
        }
        if (++i >= length || input.charAt(i) != '{') {
            this.error(i, length);
            return Memory.NULL;
        }
        ++i;
        ArrayMemory result = new ArrayMemory();
        for (int k = 0; k < size; ++k) {
            Memory key = this.read(input, i);
            if (this.pos == -1) {
                return Memory.NULL;
            }
            i = this.pos;
            Memory value = this.read(input, i);
            if (this.pos == -1) {
                return Memory.NULL;
            }
            i = this.pos;
            result.put(ArrayMemory.toKey(key), value);
        }
        if (i >= length || input.charAt(i) != '}') {
            this.error(i, length);
            return Memory.NULL;
        }
        this.pos = i + 1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory read(String input, int offset) {
        int length = input.length();
        if (offset >= length) {
            this.error(offset, length);
            return Memory.NULL;
        }
        block33: for (int i = offset; i < length; ++i) {
            char ch = input.charAt(i);
            Memory.Type type = null;
            switch (ch) {
                case 'N': {
                    if (++i < length && input.charAt(i) == ';') {
                        this.pos = i + 1;
                        return Memory.NULL;
                    }
                    return this.error(i, length);
                }
                case 'i': {
                    type = Memory.Type.INT;
                }
                case 'd': {
                    if (type == null) {
                        type = Memory.Type.DOUBLE;
                    }
                }
                case 'b': {
                    if (type == null) {
                        type = Memory.Type.BOOL;
                    }
                }
                case 's': {
                    if (type == null) {
                        type = Memory.Type.STRING;
                    }
                }
                case 'a': {
                    if (type == null) {
                        type = Memory.Type.ARRAY;
                    }
                }
                case 'C': 
                case 'O': {
                    if (type == null) {
                        type = Memory.Type.OBJECT;
                    }
                    boolean isSerializable = ch == 'C';
                    if ((ch = input.charAt(++i)) != ':') {
                        this.error(i, length);
                        return Memory.NULL;
                    }
                    ++i;
                    switch (type) {
                        case BOOL: 
                        case INT: 
                        case DOUBLE: {
                            int j;
                            boolean done = false;
                            for (j = i; j < length; ++j) {
                                ch = input.charAt(j);
                                if (ch != ';') continue;
                                done = true;
                                break;
                            }
                            if (!done) {
                                this.error(i, length);
                                return Memory.NULL;
                            }
                            String what = input.substring(i, j);
                            this.pos = i = j + 1;
                            switch (type) {
                                case BOOL: {
                                    if ("1".equals(what)) {
                                        return Memory.TRUE;
                                    }
                                    if ("0".equals(what)) {
                                        return Memory.FALSE;
                                    }
                                    this.error(i + 1, length);
                                    return Memory.NULL;
                                }
                                case INT: {
                                    try {
                                        return LongMemory.valueOf(Long.parseLong(what));
                                    }
                                    catch (NumberFormatException e) {
                                        this.error(i + 1, length);
                                        return Memory.NULL;
                                    }
                                }
                                case DOUBLE: {
                                    try {
                                        return DoubleMemory.valueOf(Double.valueOf(what));
                                    }
                                    catch (NumberFormatException e) {
                                        this.error(i + 1, length);
                                        return Memory.NULL;
                                    }
                                }
                            }
                            continue block33;
                        }
                        case STRING: {
                            return this.readString(input, i, ';');
                        }
                        case ARRAY: {
                            return this.readArray(input, i);
                        }
                        case OBJECT: {
                            String what;
                            Memory memory = this.readString(input, i, ':');
                            if (this.pos == -1) {
                                return Memory.NULL;
                            }
                            if (!memory.isString()) {
                                this.error(i, length);
                                return Memory.NULL;
                            }
                            i = this.pos;
                            ClassEntity classEntity = this.env.fetchClass(memory.toString(), true);
                            if (classEntity == null) {
                                this.env.error(this.trace, ErrorType.E_ERROR, Messages.ERR_CLASS_NOT_FOUND, memory.toString());
                                return Memory.NULL;
                            }
                            try {
                                Object iObject = classEntity.newObjectWithoutConstruct(this.env);
                                if (iObject == null) {
                                    this.env.exception(this.trace, new Messages.Item("Unserialization of '%s' is not allowed").fetch(classEntity.getName()), new Object[0]);
                                }
                                if (isSerializable) {
                                    if (!(iObject instanceof Serializable)) {
                                        this.env.warning(this.trace, "Class %s has no unserializer", classEntity.getName());
                                        return Memory.NULL;
                                    }
                                    int size = this.readSize(input, i);
                                    if (size == -1) {
                                        return this.error(i, length);
                                    }
                                    i = this.pos + 1;
                                    what = input.substring(i + 1, i + size + 1);
                                    if (i >= length || input.charAt(i) != '{') {
                                        return this.error(i, length);
                                    }
                                    i += size;
                                    if (++i >= length || input.charAt(i) != '}') {
                                        return this.error(i, length);
                                    }
                                    this.env.pushCall(this.trace, (IObject)iObject, "unserialize", new StringMemory(what));
                                    try {
                                        ((Serializable)iObject).unserialize(this.env, new StringMemory(what));
                                    }
                                    finally {
                                        this.env.popCall();
                                    }
                                } else {
                                    ArrayMemory props = iObject.getProperties();
                                    Memory serProps = this.readArray(input, i);
                                    if (serProps.isArray()) {
                                        props.putAll(serProps.toValue(ArrayMemory.class));
                                        if (classEntity.methodMagicWakeup != null) {
                                            this.env.pushCall(this.trace, (IObject)iObject, classEntity.methodMagicWakeup.getName(), new Memory[0]);
                                            try {
                                                classEntity.methodMagicWakeup.invokeDynamic((IObject)iObject, this.env, new Memory[0]);
                                            }
                                            finally {
                                                this.env.popCall();
                                            }
                                        }
                                    } else {
                                        return Memory.NULL;
                                    }
                                }
                                return new ObjectMemory((IObject)iObject);
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Throwable throwable) {
                                throw new RuntimeException(throwable);
                            }
                        }
                    }
                    continue block33;
                }
                default: {
                    this.error(i, length);
                    return Memory.NULL;
                }
            }
        }
        return Memory.NULL;
    }
}

