/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.output;

import java.io.Writer;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.Modifier;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.lang.Closure;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.output.Printer;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.PropertyEntity;

public class VarDump
extends Printer {
    private static final int PRINT_INDENT = 2;

    public VarDump(Environment env, Writer writer) {
        super(env, writer);
    }

    @Override
    protected void printReference(ReferenceMemory reference, int level, Set<Integer> used) {
        if (reference.isShortcut()) {
            this.printer.write("&");
        }
        super.printReference(reference, level, used);
    }

    @Override
    protected void printNull() {
        this.printer.write("NULL\n");
    }

    @Override
    protected void printFalse() {
        this.printer.write("bool(false)\n");
    }

    @Override
    protected void printTrue() {
        this.printer.write("bool(true)\n");
    }

    @Override
    protected void printLong(LongMemory value) {
        this.printer.write("int(");
        this.printer.write(value.toString());
        this.printer.write(")\n");
    }

    @Override
    protected void printDouble(DoubleMemory avalue) {
        this.printer.write("float(");
        double value = avalue.toDouble();
        if (value == 0.0 && Double.doubleToRawLongBits(value) != Double.doubleToRawLongBits(0.0)) {
            this.printer.write("-");
        }
        this.printer.write(avalue.toString());
        this.printer.write(")\n");
    }

    @Override
    protected void printString(StringMemory value) {
        String string = value.toString();
        this.printer.write("string(");
        this.printer.write(string.length() + "");
        this.printer.write(") \"");
        this.printer.write(string);
        this.printer.write("\"\n");
    }

    @Override
    protected void printArray(ArrayMemory value, int level, Set<Integer> used) {
        if (used.contains(value.getPointer())) {
            this.printer.write("*RECURSION*\n");
        } else {
            this.printer.write("array(");
            this.printer.write(value.size() + "");
            this.printer.write(") {\n");
            ++level;
            used.add(value.getPointer());
            ForeachIterator iterator = value.foreachIterator(false, false);
            while (iterator.next()) {
                Memory el = iterator.getValue();
                if (el == Memory.UNDEFINED) continue;
                this.printer.write(StringUtils.repeat(' ', level * 2));
                Memory key = iterator.getMemoryKey();
                this.printer.write(91);
                if (key.isString()) {
                    this.printer.write(34);
                    this.printer.write(key.toString());
                    this.printer.write(34);
                } else {
                    this.printer.write(key.toString());
                }
                this.printer.write("]=>\n");
                this.printer.write(StringUtils.repeat(' ', level * 2));
                this.print(el, level, used);
            }
            this.printer.write(StringUtils.repeat(' ', --level * 2));
            this.printer.write("}\n");
            used.remove(value.getPointer());
        }
    }

    @Override
    protected void printClosure(Closure closure, int level, Set<Integer> used) {
        ClassEntity classEntity = closure.getReflection();
        if (used.contains(closure.getPointer())) {
            this.printer.write("*RECURSION*\n");
        } else {
            this.printer.write("object(");
            this.printer.write(Closure.class.getSimpleName());
            this.printer.write(")#" + closure.getPointer());
            this.printer.write(" (" + closure.getUses().length + ") {\n");
            level += 2;
            used.add(closure.getPointer());
            this.printer.write(StringUtils.repeat(' ', level -= 2));
            this.printer.write("}\n");
            used.remove(closure.getPointer());
        }
    }

    @Override
    protected void printObject(ObjectMemory value, int level, Set<Integer> used) {
        ClassEntity classEntity = value.getReflection();
        if (used.contains(value.getPointer())) {
            this.printer.write("*RECURSION*\n");
        } else {
            ArrayMemory arr;
            if (classEntity.methodMagicDebugInfo != null) {
                try {
                    Memory tmp = this.env.invokeMethod(value.value, classEntity.methodMagicDebugInfo.getName(), new Memory[0]);
                    if (tmp.isArray()) {
                        arr = tmp.toValue(ArrayMemory.class);
                    }
                    arr = new ArrayMemory();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            } else {
                arr = value.getProperties();
            }
            this.printer.write("object(");
            this.printer.write(classEntity.getName());
            this.printer.write(")#" + value.getPointer());
            this.printer.write(" (" + arr.size() + ") {\n");
            ++level;
            used.add(value.getPointer());
            if (classEntity.methodMagicDebugInfo == null) {
                for (PropertyEntity entity : classEntity.getProperties()) {
                    if (entity.getGetter() == null || entity.isHiddenInDebugInfo()) continue;
                    this.printer.write(StringUtils.repeat(' ', level * 2));
                    this.printer.write("[\"");
                    this.printer.write(entity.getName());
                    this.printer.write(34);
                    this.printer.write(":getter]=>\n");
                    this.printer.write(StringUtils.repeat(' ', level * 2));
                    try {
                        this.print(entity.getValue(this.env, TraceInfo.UNKNOWN, value.value), level, used);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }
            ForeachIterator iterator = arr.foreachIterator(false, false);
            while (iterator.next()) {
                this.printer.write(StringUtils.repeat(' ', level * 2));
                Memory key = iterator.getMemoryKey();
                this.printer.write(91);
                if (key.isString()) {
                    String realKey = key.toString();
                    Modifier modifier = Modifier.PUBLIC;
                    String className = "";
                    int pos = realKey.lastIndexOf("\u0000");
                    if (pos > -1) {
                        if (realKey.startsWith("\u0000*\u0000")) {
                            modifier = Modifier.PROTECTED;
                        } else {
                            modifier = Modifier.PRIVATE;
                            className = realKey.substring(1, pos);
                        }
                        realKey = realKey.substring(pos + 1);
                    }
                    this.printer.write(34);
                    this.printer.write(realKey);
                    this.printer.write(34);
                    switch (modifier) {
                        case PRIVATE: {
                            this.printer.write(":\"" + className + "\":private");
                            break;
                        }
                        case PROTECTED: {
                            this.printer.write(":protected");
                        }
                    }
                } else {
                    this.printer.write(key.toString());
                }
                this.printer.write("]=>\n");
                this.printer.write(StringUtils.repeat(' ', level * 2));
                this.print(iterator.getValue(), level, used);
            }
            this.printer.write(StringUtils.repeat(' ', --level * 2));
            this.printer.write("}\n");
            used.remove(value.getPointer());
        }
    }
}

